/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.appsec.api.blocking.BlockingException;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.InstrumenterConfig;
import datadog.trace.api.ProductActivation;
import datadog.trace.api.gateway.BlockResponseFunction;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.api.iast.InstrumentationBridge;
import datadog.trace.api.iast.sink.SsrfModule;
import datadog.trace.api.naming.SpanNaming;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.URIUtils;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.bootstrap.instrumentation.decorator.UriBasedClientDecorator;
import datadog.trace.bootstrap.instrumentation.decorator.http.HttpResourceDecorator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.Map;
import java.util.function.BiFunction;

public abstract class HttpClientDecorator<REQUEST, RESPONSE>
extends UriBasedClientDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDecorator.class);
    private static final BitSet CLIENT_ERROR_STATUSES = Config.get().getHttpClientErrorStatuses();
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
    private static final boolean CLIENT_TAG_HEADERS = Config.get().isHttpClientTagHeaders();
    private static final boolean APPSEC_RASP_ENABLED = Config.get().isAppSecRaspEnabled();

    protected abstract String method(REQUEST var1);

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract int status(RESPONSE var1);

    protected abstract String getRequestHeader(REQUEST var1, String var2);

    protected abstract String getResponseHeader(RESPONSE var1, String var2);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_CLIENT;
    }

    @Override
    protected String service() {
        return null;
    }

    protected boolean shouldSetResourceName() {
        return true;
    }

    public AgentSpan onRequest(AgentSpan span, REQUEST request) {
        if (request != null) {
            String method = this.method(request);
            span.setTag("http.method", method);
            if (CLIENT_TAG_HEADERS) {
                for (Map.Entry<String, String> headerTag : AgentTracer.traceConfig(span).getRequestHeaderTags().entrySet()) {
                    String headerValue = this.getRequestHeader(request, headerTag.getKey());
                    if (null == headerValue) continue;
                    span.setTag(headerTag.getValue(), headerValue);
                }
            }
            try {
                URI url = this.url(request);
                if (url != null) {
                    this.onURI(span, url);
                    span.setTag("http.url", URIUtils.lazyValidURL(url.getScheme(), url.getHost(), url.getPort(), url.getPath()));
                    if (Config.get().isHttpClientTagQueryString()) {
                        span.setTag("http.query.string", url.getQuery());
                        span.setTag("http.fragment.string", url.getFragment());
                    }
                    if (this.shouldSetResourceName()) {
                        HttpResourceDecorator.HTTP_RESOURCE_DECORATOR.withClientPath(span, method, url.getPath());
                    }
                    this.onNetworkConnection(url.toString());
                } else if (this.shouldSetResourceName()) {
                    span.setResourceName(DEFAULT_RESOURCE_NAME);
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
            this.ssrfIastCheck(request);
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            int status = this.status(response);
            if (status > 0) {
                span.setHttpStatusCode(status);
                if (CLIENT_ERROR_STATUSES.get(status)) {
                    span.setError(true);
                }
            }
            if (CLIENT_TAG_HEADERS) {
                for (Map.Entry<String, String> headerTag : AgentTracer.traceConfig(span).getResponseHeaderTags().entrySet()) {
                    String headerValue = this.getResponseHeader(response, headerTag.getKey());
                    if (null == headerValue) continue;
                    span.setTag(headerTag.getValue(), headerValue);
                }
            }
        }
        return span;
    }

    public String operationName() {
        return SpanNaming.instance().namingSchema().client().operationForComponent(this.component().toString());
    }

    public String getSpanTagAsString(AgentSpan span, String tag) {
        Object value = span.getTag(tag);
        return value == null ? null : value.toString();
    }

    public long getRequestContentLength(REQUEST request) {
        if (request == null) {
            return 0L;
        }
        String contentLengthStr = this.getRequestHeader(request, "Content-Length");
        if (contentLengthStr != null) {
            try {
                return Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public long getResponseContentLength(RESPONSE response) {
        if (response == null) {
            return 0L;
        }
        String contentLengthStr = this.getResponseHeader(response, "Content-Length");
        if (contentLengthStr != null) {
            try {
                return Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private void onNetworkConnection(String networkConnection) {
        if (!APPSEC_RASP_ENABLED) {
            return;
        }
        if (networkConnection == null) {
            return;
        }
        BiFunction<RequestContext, String, Flow<Void>> networkConnectionCallback = AgentTracer.get().getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.networkConnection());
        if (networkConnectionCallback == null) {
            return;
        }
        AgentSpan span = AgentTracer.get().activeSpan();
        if (span == null) {
            return;
        }
        RequestContext ctx = span.getRequestContext();
        if (ctx == null) {
            return;
        }
        Flow<Void> flow = networkConnectionCallback.apply(ctx, networkConnection);
        Flow.Action action = flow.getAction();
        if (action instanceof Flow.Action.RequestBlockingAction) {
            BlockResponseFunction brf = ctx.getBlockResponseFunction();
            if (brf != null) {
                Flow.Action.RequestBlockingAction rba = (Flow.Action.RequestBlockingAction)action;
                brf.tryCommitBlockingResponse(ctx.getTraceSegment(), rba.getStatusCode(), rba.getBlockingContentType(), rba.getExtraHeaders());
            }
            throw new BlockingException("Blocked request (for SSRF attempt)");
        }
    }

    protected Object sourceUrl(REQUEST request) {
        return null;
    }

    private void ssrfIastCheck(REQUEST request) {
        Object sourceUrl = this.sourceUrl(request);
        if (sourceUrl == null) {
            return;
        }
        if (InstrumenterConfig.get().getIastActivation() != ProductActivation.FULLY_ENABLED) {
            return;
        }
        SsrfModule ssrfModule = InstrumentationBridge.SSRF;
        if (ssrfModule != null) {
            ssrfModule.onURLConnection(sourceUrl);
        }
    }
}

