/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import datadog.trace.api.telemetry.LoginEvent;
import datadog.trace.api.telemetry.LoginFramework;
import datadog.trace.api.telemetry.LoginVersion;
import datadog.trace.api.telemetry.MetricCollector;
import datadog.trace.api.telemetry.RuleType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;

public class WafMetricCollector
implements MetricCollector<WafMetric> {
    private static final int MASK_STRING_TOO_LONG = 1;
    private static final int MASK_LIST_MAP_TOO_LARGE = 2;
    private static final int MASK_OBJECT_TOO_DEEP = 4;
    public static WafMetricCollector INSTANCE = new WafMetricCollector();
    private static final String NAMESPACE = "appsec";
    private static final BlockingQueue<WafMetric> rawMetricsQueue = new ArrayBlockingQueue<WafMetric>(1024);
    private static final AtomicInteger wafInitCounter = new AtomicInteger();
    private static final AtomicInteger wafUpdatesCounter = new AtomicInteger();
    private static final int WAF_REQUEST_COMBINATIONS = 128;
    private final AtomicLongArray wafRequestCounter = new AtomicLongArray(128);
    private static final AtomicLongArray wafInputTruncatedCounter = new AtomicLongArray(8);
    private static final AtomicLongArray raspRuleEvalCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspRuleSkippedCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspRuleMatchCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspTimeoutCounter = new AtomicLongArray(RuleType.getNumValues());
    private static final AtomicLongArray raspErrorCodeCounter = new AtomicLongArray(WafErrorCode.values().length * RuleType.getNumValues());
    private static final AtomicLongArray wafErrorCodeCounter = new AtomicLongArray(WafErrorCode.values().length);
    private static final AtomicLongArray missingUserLoginQueue = new AtomicLongArray(LoginFramework.getNumValues() * LoginEvent.getNumValues());
    private static final AtomicLongArray missingUserIdQueue = new AtomicLongArray(LoginFramework.getNumValues());
    private static final AtomicLongArray appSecSdkEventQueue = new AtomicLongArray(LoginEvent.getNumValues() * LoginVersion.getNumValues());
    private static final AtomicInteger wafConfigErrorCounter = new AtomicInteger();
    private static String wafVersion = "";
    private static String rulesVersion = "";

    public static WafMetricCollector get() {
        return INSTANCE;
    }

    private WafMetricCollector() {
    }

    public void wafInit(String wafVersion, String rulesVersion, boolean success) {
        WafMetricCollector.wafVersion = wafVersion;
        WafMetricCollector.rulesVersion = rulesVersion;
        rawMetricsQueue.offer(new WafInitRawMetric(wafInitCounter.incrementAndGet(), wafVersion, rulesVersion, success));
    }

    public void wafUpdates(String rulesVersion, boolean success) {
        rawMetricsQueue.offer(new WafUpdatesRawMetric(wafUpdatesCounter.incrementAndGet(), wafVersion, rulesVersion, success));
        if (rulesVersion != null && WafMetricCollector.rulesVersion != null && !rulesVersion.equals(WafMetricCollector.rulesVersion)) {
            WafMetricCollector.get().prepareMetrics();
        }
        WafMetricCollector.rulesVersion = rulesVersion;
    }

    public void wafRequest(boolean ruleTriggered, boolean requestBlocked, boolean wafError, boolean wafTimeout, boolean blockFailure, boolean rateLimited, boolean inputTruncated) {
        int index = WafMetricCollector.computeWafRequestIndex(ruleTriggered, requestBlocked, wafError, wafTimeout, blockFailure, rateLimited, inputTruncated);
        this.wafRequestCounter.incrementAndGet(index);
    }

    public void wafInputTruncated(boolean stringTooLong, boolean listMapTooLarge, boolean objectTooDeep) {
        int index = WafMetricCollector.computeWafInputTruncatedIndex(stringTooLong, listMapTooLarge, objectTooDeep);
        wafInputTruncatedCounter.incrementAndGet(index);
    }

    static int computeWafRequestIndex(boolean ruleTriggered, boolean requestBlocked, boolean wafError, boolean wafTimeout, boolean blockFailure, boolean rateLimited, boolean inputTruncated) {
        int index = 0;
        if (ruleTriggered) {
            index |= 1;
        }
        if (requestBlocked) {
            index |= 2;
        }
        if (wafError) {
            index |= 4;
        }
        if (wafTimeout) {
            index |= 8;
        }
        if (blockFailure) {
            index |= 0x10;
        }
        if (rateLimited) {
            index |= 0x20;
        }
        if (inputTruncated) {
            index |= 0x40;
        }
        return index;
    }

    static int computeWafInputTruncatedIndex(boolean stringTooLong, boolean listMapTooLarge, boolean objectTooDeep) {
        int index = 0;
        if (stringTooLong) {
            index |= 1;
        }
        if (listMapTooLarge) {
            index |= 2;
        }
        if (objectTooDeep) {
            index |= 4;
        }
        return index;
    }

    public void raspRuleEval(RuleType ruleType) {
        raspRuleEvalCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspRuleSkipped(RuleType ruleType) {
        raspRuleSkippedCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspRuleMatch(RuleType ruleType) {
        raspRuleMatchCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspTimeout(RuleType ruleType) {
        raspTimeoutCounter.incrementAndGet(ruleType.ordinal());
    }

    public void raspErrorCode(RuleType ruleType, int errorCode) {
        WafErrorCode wafErrorCode = WafErrorCode.fromCode(errorCode);
        if (wafErrorCode == null) {
            return;
        }
        int index = wafErrorCode.ordinal() * RuleType.getNumValues() + ruleType.ordinal();
        raspErrorCodeCounter.incrementAndGet(index);
    }

    public void wafErrorCode(int errorCode) {
        WafErrorCode wafErrorCode = WafErrorCode.fromCode(errorCode);
        if (wafErrorCode == null) {
            return;
        }
        wafErrorCodeCounter.incrementAndGet(wafErrorCode.ordinal());
    }

    public void missingUserLogin(LoginFramework framework, LoginEvent eventType) {
        missingUserLoginQueue.incrementAndGet(framework.ordinal() * LoginEvent.getNumValues() + eventType.ordinal());
    }

    public void missingUserId(LoginFramework framework) {
        missingUserIdQueue.incrementAndGet(framework.ordinal());
    }

    public void appSecSdkEvent(LoginEvent event, LoginVersion version) {
        int index = event.ordinal() * LoginVersion.getNumValues() + version.ordinal();
        appSecSdkEventQueue.incrementAndGet(index);
    }

    @Override
    public Collection<WafMetric> drain() {
        LinkedList<WafMetric> list;
        int drained;
        if (!rawMetricsQueue.isEmpty() && (drained = rawMetricsQueue.drainTo(list = new LinkedList<WafMetric>())) > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void prepareMetrics() {
        int ordinal;
        long counter;
        int i;
        for (i = 0; i < 128; ++i) {
            boolean inputTruncated;
            counter = this.wafRequestCounter.getAndSet(i, 0L);
            if (counter <= 0L) continue;
            boolean bl = (i & 1) != 0;
            boolean requestBlocked = (i & 2) != 0;
            boolean wafError = (i & 4) != 0;
            boolean wafTimeout = (i & 8) != 0;
            boolean blockFailure = (i & 0x10) != 0;
            boolean rateLimited = (i & 0x20) != 0;
            boolean bl2 = inputTruncated = (i & 0x40) != 0;
            if (rawMetricsQueue.offer(new WafRequestsRawMetric(counter, wafVersion, rulesVersion, bl, requestBlocked, wafError, wafTimeout, blockFailure, rateLimited, inputTruncated))) continue;
            return;
        }
        for (i = 0; i < 8; ++i) {
            counter = wafInputTruncatedCounter.getAndSet(i, 0L);
            if (counter <= 0L || rawMetricsQueue.offer(new WafInputTruncated(counter, i))) continue;
            return;
        }
        for (RuleType ruleType : RuleType.values()) {
            long counter2 = raspRuleEvalCounter.getAndSet(ruleType.ordinal(), 0L);
            if (counter2 <= 0L || rawMetricsQueue.offer(new RaspRuleEval(counter2, ruleType, wafVersion))) continue;
            return;
        }
        for (RuleType ruleType : RuleType.values()) {
            long counter3 = raspRuleMatchCounter.getAndSet(ruleType.ordinal(), 0L);
            if (counter3 <= 0L || rawMetricsQueue.offer(new RaspRuleMatch(counter3, ruleType, wafVersion))) continue;
            return;
        }
        for (RuleType ruleType : RuleType.values()) {
            long counter4 = raspTimeoutCounter.getAndSet(ruleType.ordinal(), 0L);
            if (counter4 <= 0L || rawMetricsQueue.offer(new RaspTimeout(counter4, ruleType, wafVersion))) continue;
            return;
        }
        for (Enum enum_ : WafErrorCode.values()) {
            for (RuleType ruleType : RuleType.values()) {
                int index = enum_.ordinal() * RuleType.getNumValues() + ruleType.ordinal();
                long count = raspErrorCodeCounter.getAndSet(index, 0L);
                if (count <= 0L || rawMetricsQueue.offer(new RaspError(count, ruleType, wafVersion, ((WafErrorCode)enum_).getCode()))) continue;
                return;
            }
        }
        for (Enum enum_ : LoginFramework.values()) {
            for (LoginEvent event : LoginEvent.values()) {
                ordinal = enum_.ordinal() * LoginEvent.getNumValues() + event.ordinal();
                long counter5 = missingUserLoginQueue.getAndSet(ordinal, 0L);
                if (counter5 <= 0L || rawMetricsQueue.offer(new MissingUserLoginMetric(counter5, ((LoginFramework)enum_).getTag(), event.getTag()))) continue;
                return;
            }
        }
        for (Enum enum_ : LoginFramework.values()) {
            long counter6 = missingUserIdQueue.getAndSet(enum_.ordinal(), 0L);
            if (counter6 <= 0L || rawMetricsQueue.offer(new MissingUserIdMetric(counter6, ((LoginFramework)enum_).getTag()))) continue;
            return;
        }
        for (Enum enum_ : LoginEvent.values()) {
            for (LoginVersion version : LoginVersion.values()) {
                ordinal = enum_.ordinal() * LoginVersion.getNumValues() + version.ordinal();
                long counter7 = appSecSdkEventQueue.getAndSet(ordinal, 0L);
                if (counter7 <= 0L || rawMetricsQueue.offer(new AppSecSdkEvent(counter7, ((LoginEvent)enum_).getTag(), version.getTag()))) continue;
                return;
            }
        }
        for (Enum enum_ : WafErrorCode.values()) {
            long count = wafErrorCodeCounter.getAndSet(enum_.ordinal(), 0L);
            if (count <= 0L || rawMetricsQueue.offer(new WafError(count, wafVersion, ((WafErrorCode)enum_).getCode()))) continue;
            return;
        }
        for (Enum enum_ : RuleType.values()) {
            long counter8 = raspRuleSkippedCounter.getAndSet(enum_.ordinal(), 0L);
            if (counter8 <= 0L || rawMetricsQueue.offer(new AfterRequestRaspRuleSkipped(counter8, (RuleType)enum_))) continue;
            return;
        }
        int configErrors = wafConfigErrorCounter.getAndSet(0);
        if (configErrors > 0 && !rawMetricsQueue.offer(new WafConfigError(configErrors, wafVersion, rulesVersion))) {
            return;
        }
    }

    public void addWafConfigError(int nbErrors) {
        wafConfigErrorCounter.addAndGet(nbErrors);
    }

    public static enum WafErrorCode {
        INVALID_ARGUMENT(-1),
        INVALID_OBJECT(-2),
        INTERNAL_ERROR(-3),
        BINDING_ERROR(-127);

        private final int code;
        private static final Map<Integer, WafErrorCode> CODE_MAP;

        private WafErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static WafErrorCode fromCode(int code) {
            return CODE_MAP.get(code);
        }

        static {
            HashMap<Integer, WafErrorCode> map = new HashMap<Integer, WafErrorCode>();
            for (WafErrorCode errorCode : WafErrorCode.values()) {
                map.put(errorCode.code, errorCode);
            }
            CODE_MAP = Collections.unmodifiableMap(map);
        }
    }

    public static class WafInputTruncated
    extends WafMetric {
        public WafInputTruncated(long counter, int bitfield) {
            super("waf.input_truncated", counter, "truncation_reason:" + bitfield);
        }
    }

    public static class WafError
    extends WafMetric {
        public WafError(long counter, String wafVersion, Integer ddwafRunError) {
            super("waf.error", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "waf_error:" + ddwafRunError);
        }
    }

    public static class RaspError
    extends WafMetric {
        public RaspError(long counter, RuleType ruleType, String wafVersion, Integer ddwafRunError) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[5];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
                stringArray = stringArray2;
                stringArray2[4] = "waf_error:" + ddwafRunError;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray3[1] = "waf_version:" + wafVersion;
                stringArray = stringArray3;
                stringArray3[2] = "waf_error:" + ddwafRunError;
            }
            super("rasp.error", counter, stringArray);
        }
    }

    public static class RaspTimeout
    extends WafMetric {
        public RaspTimeout(long counter, RuleType ruleType, String wafVersion) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray = stringArray2;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "waf_version:" + wafVersion;
            }
            super("rasp.timeout", counter, stringArray);
        }
    }

    public static class RaspRuleMatch
    extends WafMetric {
        public RaspRuleMatch(long counter, RuleType ruleType, String wafVersion) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray = stringArray2;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "waf_version:" + wafVersion;
            }
            super("rasp.rule.match", counter, stringArray);
        }
    }

    public static class AfterRequestRaspRuleSkipped
    extends WafMetric {
        public AfterRequestRaspRuleSkipped(long counter, RuleType ruleType) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray = stringArray2;
                stringArray2[2] = "reason:after-request";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "reason:after-request";
            }
            super("rasp.rule.skipped", counter, stringArray);
        }
    }

    public static class RaspRuleEval
    extends WafMetric {
        public RaspRuleEval(long counter, RuleType ruleType, String wafVersion) {
            String[] stringArray;
            if (ruleType.variant != null) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray2[1] = "rule_variant:" + (Object)((Object)ruleType.variant);
                stringArray2[2] = "waf_version:" + wafVersion;
                stringArray = stringArray2;
                stringArray2[3] = "event_rules_version:" + rulesVersion;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "rule_type:" + (Object)((Object)ruleType.type);
                stringArray = stringArray3;
                stringArray3[1] = "waf_version:" + wafVersion;
            }
            super("rasp.rule.eval", counter, stringArray);
        }
    }

    public static class WafConfigError
    extends WafMetric {
        public WafConfigError(long counter, String wafVersion, String rulesVersion) {
            super("waf.config_errors", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion);
        }
    }

    public static class WafRequestsRawMetric
    extends WafMetric {
        public WafRequestsRawMetric(long counter, String wafVersion, String rulesVersion, boolean triggered, boolean blocked, boolean wafError, boolean wafTimeout, boolean blockFailure, boolean rateLimited, boolean inputTruncated) {
            super("waf.requests", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "rule_triggered:" + triggered, "request_blocked:" + blocked, "waf_error:" + wafError, "waf_timeout:" + wafTimeout, "block_failure:" + blockFailure, "rate_limited:" + rateLimited, "input_truncated:" + inputTruncated);
        }
    }

    public static class AppSecSdkEvent
    extends WafMetric {
        public AppSecSdkEvent(long counter, String event, String version) {
            super("sdk.event", counter, "event_type:" + event, "sdk_version:" + version);
        }
    }

    public static class MissingUserIdMetric
    extends WafMetric {
        public MissingUserIdMetric(long counter, String framework) {
            super("instrum.user_auth.missing_user_id", counter, "framework:" + framework, "event_type:authenticated_request");
        }
    }

    public static class MissingUserLoginMetric
    extends WafMetric {
        public MissingUserLoginMetric(long counter, String framework, String type) {
            super("instrum.user_auth.missing_user_login", counter, "framework:" + framework, "event_type:" + type);
        }
    }

    public static class WafUpdatesRawMetric
    extends WafMetric {
        public WafUpdatesRawMetric(long counter, String wafVersion, String rulesVersion, boolean success) {
            super("waf.updates", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "success:" + success);
        }
    }

    public static class WafInitRawMetric
    extends WafMetric {
        public WafInitRawMetric(long counter, String wafVersion, String rulesVersion, boolean success) {
            super("waf.init", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "success:" + success);
        }
    }

    public static abstract class WafMetric
    extends MetricCollector.Metric {
        public WafMetric(String metricName, long counter, String ... tags) {
            super(WafMetricCollector.NAMESPACE, true, metricName, "count", (Number)counter, tags);
        }
    }
}

