/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc;

import datadog.trace.bootstrap.otel.api.common.AttributeKey;
import datadog.trace.bootstrap.otel.api.common.AttributesBuilder;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc.RpcAttributesGetter;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.AttributesExtractor;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.AttributesExtractorUtil;
import javax.annotation.Nullable;

abstract class RpcCommonAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    static final AttributeKey<String> RPC_METHOD = AttributeKey.stringKey("rpc.method");
    static final AttributeKey<String> RPC_SERVICE = AttributeKey.stringKey("rpc.service");
    static final AttributeKey<String> RPC_SYSTEM = AttributeKey.stringKey("rpc.system");
    private final RpcAttributesGetter<REQUEST> getter;

    RpcCommonAttributesExtractor(RpcAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public final void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, RPC_SYSTEM, this.getter.getSystem(request));
        AttributesExtractorUtil.internalSet(attributes, RPC_SERVICE, this.getter.getService(request));
        AttributesExtractorUtil.internalSet(attributes, RPC_METHOD, this.getter.getMethod(request));
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

