/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc;

import com.google.auto.value.AutoValue;
import datadog.trace.bootstrap.PatchLogger;
import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogram;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.Meter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.ContextKey;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc.AutoValue_RpcClientMetrics_State;
import datadog.trace.bootstrap.otel.instrumentation.api.incubator.semconv.rpc.RpcMetricsAdvice;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationListener;
import datadog.trace.bootstrap.otel.instrumentation.api.instrumenter.OperationMetrics;
import datadog.trace.bootstrap.otel.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class RpcClientMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("rpc-client-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(RpcClientMetrics.class.getName());
    private final DoubleHistogram clientDurationHistogram;

    private RpcClientMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("rpc.client.duration").setDescription("The duration of an outbound RPC invocation").setUnit("ms");
        RpcMetricsAdvice.applyClientDurationAdvice(durationBuilder);
        this.clientDurationHistogram = durationBuilder.build();
    }

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("rpc client", RpcClientMetrics::new);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_CLIENT_REQUEST_METRICS_STATE, new AutoValue_RpcClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(RPC_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC request metrics.", context);
            return;
        }
        this.clientDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, state.startAttributes().toBuilder().putAll(endAttributes).build(), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

