/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.config.provider.StableConfigSource;
import datadog.trace.bootstrap.config.provider.stableconfig.Rule;
import datadog.trace.bootstrap.config.provider.stableconfig.Selector;
import datadog.trace.bootstrap.config.provider.stableconfig.StableConfig;
import datadog.yaml.YamlParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;

public class StableConfigParser {
    private static final Logger log = LoggerFactory.getLogger(StableConfigParser.class);
    private static final String ENVIRONMENT_VARIABLES_PREFIX = "environment_variables['";
    private static final String PROCESS_ARGUMENTS_PREFIX = "process_arguments['";
    static final int MAX_FILE_SIZE_BYTES = 262144;
    private static final String UNDEFINED_VALUE = "";

    public static StableConfigSource.StableConfig parse(String filePath) throws IOException {
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (Files.size(path) > 262144L) {
                log.warn("Configuration file {} exceeds max size {} bytes; dropping.", (Object)filePath, (Object)262144);
                return StableConfigSource.StableConfig.EMPTY;
            }
            String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            String processedContent = StableConfigParser.processTemplate(content);
            Object parsedYaml = YamlParser.parse(processedContent);
            StableConfig data = new StableConfig(parsedYaml);
            String configId = data.getConfigId();
            Map<String, Object> configMap = data.getApmConfigurationDefault();
            List<Rule> rules = data.getApmConfigurationRules();
            if (!rules.isEmpty()) {
                for (Rule rule : rules) {
                    if (!StableConfigParser.doesRuleMatch(rule)) continue;
                    LinkedHashMap<String, Object> mergedConfigMap = new LinkedHashMap<String, Object>(configMap);
                    mergedConfigMap.putAll(rule.getConfiguration());
                    return new StableConfigSource.StableConfig(configId, mergedConfigMap);
                }
            }
            if (!configMap.isEmpty()) {
                return new StableConfigSource.StableConfig(configId, configMap);
            }
            if (configId != null) {
                return new StableConfigSource.StableConfig(configId, Collections.emptyMap());
            }
        }
        catch (IOException e) {
            log.debug("Failed to read the stable configuration file: {}", (Object)filePath, (Object)e);
        }
        return StableConfigSource.StableConfig.EMPTY;
    }

    private static boolean doesRuleMatch(Rule rule) {
        for (Selector selector : rule.getSelectors()) {
            if (StableConfigParser.selectorMatch(selector.getOrigin(), selector.getMatches(), selector.getOperator(), selector.getKey())) continue;
            return false;
        }
        return true;
    }

    private static boolean validOperatorForLanguageOrigin(String operator) {
        switch (operator = operator.toLowerCase()) {
            case "equals": 
            case "starts_with": 
            case "ends_with": 
            case "contains": {
                return true;
            }
        }
        return false;
    }

    private static boolean checkEnvMatches(List<String> values, List<String> matches, BiPredicate<String, String> compareFunc) {
        if (values == null) {
            return false;
        }
        for (String match : matches) {
            if (match == null) continue;
            for (String value : values) {
                if (!compareFunc.test(value, match.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean selectorMatch(String origin, List<String> matches, String operator, String key) {
        switch (origin.toLowerCase()) {
            case "language": {
                if (!StableConfigParser.validOperatorForLanguageOrigin(operator)) {
                    return false;
                }
                for (String entry : matches) {
                    if (!entry.toLowerCase().contains("java")) continue;
                    return true;
                }
            }
            case "environment_variables": {
                if (key == null) {
                    return false;
                }
                String envValue = System.getenv(key.toUpperCase());
                if (envValue == null) {
                    return false;
                }
                envValue = envValue.toLowerCase();
                switch (operator.toLowerCase()) {
                    case "exists": {
                        return true;
                    }
                    case "equals": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::equalsIgnoreCase);
                    }
                    case "starts_with": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::startsWith);
                    }
                    case "ends_with": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::endsWith);
                    }
                    case "contains": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::contains);
                    }
                }
                return false;
            }
            case "process_arguments": {
                if (!key.startsWith("-D")) {
                    log.warn("Ignoring unsupported process_arguments entry in selector match, '{}'. Only system properties specified with the '-D' prefix are supported.", (Object)key);
                    return false;
                }
                return System.getProperty(key.substring(2)) != null;
            }
            case "tags": {
                return false;
            }
        }
        return false;
    }

    static String processTemplate(String content) throws IOException {
        int closeIndex;
        int openIndex = content.indexOf("{{");
        if (openIndex == -1) {
            return content;
        }
        StringBuilder result = new StringBuilder(content.length());
        result.append(content, 0, openIndex);
        while (true) {
            if ((closeIndex = content.indexOf("}}", openIndex)) == -1) {
                throw new IOException("Unterminated template in config");
            }
            String templateVar = content.substring(openIndex + 2, closeIndex).trim();
            String value = StableConfigParser.processTemplateVar(templateVar);
            result.append(value);
            openIndex = content.indexOf("{{", closeIndex);
            if (openIndex == -1) break;
            result.append(content, closeIndex + 2, openIndex);
        }
        result.append(content, closeIndex + 2, content.length());
        return result.toString();
    }

    private static String processTemplateVar(String templateVar) throws IOException {
        if (templateVar.startsWith(ENVIRONMENT_VARIABLES_PREFIX) && templateVar.endsWith("']")) {
            String envVar = templateVar.substring(ENVIRONMENT_VARIABLES_PREFIX.length(), templateVar.length() - 2).trim();
            if (envVar.isEmpty()) {
                throw new IOException("Empty environment variable name in template");
            }
            String value = System.getenv(envVar.toUpperCase());
            if (value == null || value.isEmpty()) {
                return UNDEFINED_VALUE;
            }
            return value;
        }
        if (templateVar.startsWith(PROCESS_ARGUMENTS_PREFIX) && templateVar.endsWith("']")) {
            String processArg = templateVar.substring(PROCESS_ARGUMENTS_PREFIX.length(), templateVar.length() - 2).trim();
            if (processArg.isEmpty()) {
                throw new IOException("Empty process argument in template");
            }
            if (!processArg.startsWith("-D")) {
                log.warn("Ignoring unsupported process_arguments entry in template variable, '{}'. Only system properties specified with the '-D' prefix are supported.", (Object)processArg);
                return UNDEFINED_VALUE;
            }
            String value = System.getProperty(processArg.substring(2));
            if (value == null || value.isEmpty()) {
                return UNDEFINED_VALUE;
            }
            return value;
        }
        return UNDEFINED_VALUE;
    }
}

