/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.cli.CLIHelper;
import datadog.trace.bootstrap.AgentJar;
import datadog.trace.bootstrap.BootstrapInitializationTelemetry;
import datadog.trace.bootstrap.SystemUtils;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;

public final class AgentBootstrap {
    static final String LIB_INJECTION_ENABLED_ENV_VAR = "DD_INJECTION_ENABLED";
    static final String LIB_INJECTION_FORCE_SYS_PROP = "dd.inject.force";
    private static final Class<?> thisClass = AgentBootstrap.class;
    private static final int MAX_EXCEPTION_CHAIN_LENGTH = 99;
    private static final String JAVA_AGENT_ARGUMENT = "-javaagent:";
    private static boolean initialized = false;
    private static List<File> agentFiles = null;

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentBootstrap.agentmain(agentArgs, inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden
    public static void agentmain(String agentArgs, Instrumentation inst) {
        BootstrapInitializationTelemetry initTelemetry;
        try {
            initTelemetry = AgentBootstrap.createInitializationTelemetry();
        }
        catch (Throwable t) {
            initTelemetry = BootstrapInitializationTelemetry.noOpInstance();
        }
        try {
            AgentBootstrap.agentmainImpl(initTelemetry, agentArgs, inst);
        }
        catch (Throwable ex) {
            initTelemetry.onFatalError(ex);
            if (AgentBootstrap.exceptionCauseChainContains(ex, "datadog.trace.util.throwable.FatalAgentMisconfigurationError")) {
                throw new Error(ex);
            }
            System.err.println("ERROR " + thisClass.getName());
            ex.printStackTrace();
        }
        finally {
            try {
                initTelemetry.finish();
            }
            catch (Throwable t) {}
        }
    }

    private static BootstrapInitializationTelemetry createInitializationTelemetry() {
        String agentVersion;
        String forwarderPath = SystemUtils.tryGetEnv("DD_TELEMETRY_FORWARDER_PATH");
        if (forwarderPath == null) {
            return BootstrapInitializationTelemetry.noOpInstance();
        }
        BootstrapInitializationTelemetry initTelemetry = BootstrapInitializationTelemetry.createFromForwarderPath(forwarderPath);
        initTelemetry.initMetaInfo("runtime_name", "jvm");
        initTelemetry.initMetaInfo("language_name", "jvm");
        String javaVersion = SystemUtils.tryGetProperty("java.version");
        if (javaVersion != null) {
            initTelemetry.initMetaInfo("runtime_version", javaVersion);
            initTelemetry.initMetaInfo("language_version", javaVersion);
        }
        if ((agentVersion = AgentJar.tryGetAgentVersion()) != null) {
            initTelemetry.initMetaInfo("tracer_version", agentVersion);
        }
        return initTelemetry;
    }

    private static void agentmainImpl(BootstrapInitializationTelemetry initTelemetry, String agentArgs, Instrumentation inst) throws IOException, URISyntaxException, ReflectiveOperationException {
        Class<?> agentClass;
        if (AgentBootstrap.alreadyInitialized()) {
            initTelemetry.onError("already_initialized");
            return;
        }
        if (AgentBootstrap.lessThanJava8()) {
            initTelemetry.onAbort("incompatible_runtime");
            return;
        }
        if (AgentBootstrap.isJdkTool()) {
            initTelemetry.onAbort("jdk_tool");
            return;
        }
        if (AgentBootstrap.shouldAbortDueToOtherJavaAgents()) {
            initTelemetry.onAbort("other-java-agents");
            return;
        }
        URL agentJarURL = AgentBootstrap.installAgentJar(inst);
        try {
            agentClass = Class.forName("datadog.trace.bootstrap.Agent", true, null);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException("Unable to load DD Java Agent.", e);
        }
        if (agentClass.getClassLoader() != null) {
            throw new IllegalStateException("DD Java Agent NOT added to bootstrap classpath.");
        }
        Method startMethod = agentClass.getMethod("start", Object.class, Instrumentation.class, URL.class, String.class);
        startMethod.invoke(null, initTelemetry, inst, agentJarURL, agentArgs);
    }

    static boolean getConfig(String configName) {
        switch (configName) {
            case "DD_INJECTION_ENABLED": {
                return System.getenv(LIB_INJECTION_ENABLED_ENV_VAR) != null;
            }
            case "dd.inject.force": {
                String injectionForceFlag = SystemUtils.getPropertyOrEnvVar(LIB_INJECTION_FORCE_SYS_PROP);
                return "true".equalsIgnoreCase(injectionForceFlag) || "1".equals(injectionForceFlag);
            }
        }
        return false;
    }

    static boolean exceptionCauseChainContains(Throwable ex, String exClassName) {
        Set stack = Collections.newSetFromMap(new IdentityHashMap());
        for (Throwable t = ex; t != null && stack.add(t) && stack.size() <= 99; t = t.getCause()) {
            if (!t.getClass().getName().equals(exClassName)) continue;
            return true;
        }
        return false;
    }

    @SuppressForbidden
    private static boolean alreadyInitialized() {
        if (initialized) {
            System.err.println("Warning: dd-java-agent is being initialized more than once. Please check that you are defining -javaagent:dd-java-agent.jar only once.");
            return true;
        }
        initialized = true;
        return false;
    }

    @SuppressForbidden
    private static boolean lessThanJava8() {
        try {
            return AgentBootstrap.lessThanJava8(System.getProperty("java.version"), System.err);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static boolean lessThanJava8(String version, PrintStream output) {
        if (AgentBootstrap.parseJavaMajorVersion(version) < 8) {
            String agentRawVersion = AgentJar.tryGetAgentVersion();
            String agentVersion = agentRawVersion == null ? "This version" : "Version " + agentRawVersion;
            output.println("Warning: " + agentVersion + " of dd-java-agent is not compatible with Java " + version + " and will not be installed.");
            output.println("Please upgrade your Java version to 8+ or use the 0.x version of dd-java-agent in your build tool or download it from https://dtdg.co/java-tracer-v0");
            return true;
        }
        return false;
    }

    private static boolean isJdkTool() {
        String moduleMain = SystemUtils.tryGetProperty("jdk.module.main");
        if (null != moduleMain && !moduleMain.isEmpty() && moduleMain.charAt(0) == 'j') {
            switch (moduleMain) {
                case "java.base": 
                case "java.corba": 
                case "java.desktop": 
                case "java.rmi": 
                case "java.scripting": 
                case "java.security.jgss": 
                case "jdk.aot": 
                case "jdk.compiler": 
                case "jdk.dev": 
                case "jdk.hotspot.agent": 
                case "jdk.httpserver": 
                case "jdk.jartool": 
                case "jdk.javadoc": 
                case "jdk.jcmd": 
                case "jdk.jconsole": 
                case "jdk.jdeps": 
                case "jdk.jdi": 
                case "jdk.jfr": 
                case "jdk.jlink": 
                case "jdk.jpackage": 
                case "jdk.jshell": 
                case "jdk.jstatd": 
                case "jdk.jvmstat.rmi": 
                case "jdk.pack": 
                case "jdk.pack200": 
                case "jdk.policytool": 
                case "jdk.rmic": 
                case "jdk.scripting.nashorn.shell": 
                case "jdk.xml.bind": 
                case "jdk.xml.ws": {
                    return true;
                }
            }
        }
        return false;
    }

    static int parseJavaMajorVersion(String version) {
        char c;
        int major = 0;
        if (null == version || version.isEmpty()) {
            return major;
        }
        int start = 0;
        if (version.charAt(0) == '1' && version.length() >= 3 && version.charAt(1) == '.' && Character.isDigit(version.charAt(2))) {
            start = 2;
        }
        for (int i = start; i < version.length() && Character.isDigit(c = version.charAt(i)); ++i) {
            major *= 10;
            major += Character.digit(c, 10);
        }
        return major;
    }

    @SuppressForbidden
    static boolean shouldAbortDueToOtherJavaAgents() {
        if (!AgentBootstrap.getConfig(LIB_INJECTION_ENABLED_ENV_VAR) || AgentBootstrap.getConfig(LIB_INJECTION_FORCE_SYS_PROP) || AgentBootstrap.getAgentFilesFromVMArguments().size() <= 1) {
            return false;
        }
        if (AgentBootstrap.getAgentFilesFromVMArguments().size() == 2) {
            for (File agentFile : AgentBootstrap.getAgentFilesFromVMArguments()) {
                if (!agentFile.getName().toLowerCase().contains("log4j")) continue;
                return false;
            }
        }
        StringBuilder agentFiles = new StringBuilder();
        boolean first = true;
        for (File agentFile : AgentBootstrap.getAgentFilesFromVMArguments()) {
            if (first) {
                first = false;
            } else {
                agentFiles.append(", ");
            }
            agentFiles.append('\"');
            agentFiles.append(agentFile.getAbsolutePath());
            agentFiles.append('\"');
        }
        System.err.println("Info: multiple JVM agents detected, found " + agentFiles + ". Loading multiple APM/Tracing agent is not a recommended or supported configuration.Please set the environment variable DD_INJECT_FORCE or the system property dd.inject.force to TRUE to load Datadog APM/Tracing agent.");
        return true;
    }

    public static void main(String[] args) {
        if (AgentBootstrap.lessThanJava8()) {
            return;
        }
        AgentJar.main(args);
    }

    @SuppressForbidden
    private static synchronized URL installAgentJar(Instrumentation inst) throws IOException, URISyntaxException {
        URL ddJavaAgentJarURL;
        File ddJavaAgentJarPath;
        URL ddJavaAgentJarURL2;
        CodeSource codeSource = thisClass.getProtectionDomain().getCodeSource();
        if (codeSource != null && (ddJavaAgentJarURL2 = codeSource.getLocation()) != null && !(ddJavaAgentJarPath = new File(ddJavaAgentJarURL2.toURI())).isDirectory()) {
            return AgentBootstrap.appendAgentToBootstrapClassLoaderSearch(inst, ddJavaAgentJarURL2, ddJavaAgentJarPath);
        }
        System.err.println("Could not get bootstrap jar from code source, using -javaagent arg");
        File javaagentFile = AgentBootstrap.getAgentFileFromJavaagentArg(AgentBootstrap.getAgentFilesFromVMArguments());
        if (javaagentFile != null) {
            ddJavaAgentJarURL = javaagentFile.toURI().toURL();
            return AgentBootstrap.appendAgentToBootstrapClassLoaderSearch(inst, ddJavaAgentJarURL, javaagentFile);
        }
        System.err.println("Could not get agent jar from -javaagent arg, using ClassLoader#getResource");
        javaagentFile = AgentBootstrap.getAgentFileUsingClassLoaderLookup();
        if (!javaagentFile.isDirectory()) {
            ddJavaAgentJarURL = javaagentFile.toURI().toURL();
            return AgentBootstrap.appendAgentToBootstrapClassLoaderSearch(inst, ddJavaAgentJarURL, javaagentFile);
        }
        throw new IllegalStateException("Could not determine agent jar location, not installing tracing agent");
    }

    private static URL appendAgentToBootstrapClassLoaderSearch(Instrumentation inst, URL ddJavaAgentJarURL, File javaagentFile) throws IOException {
        AgentBootstrap.checkJarManifestMainClassIsThis(ddJavaAgentJarURL);
        inst.appendToBootstrapClassLoaderSearch(new JarFile(javaagentFile));
        return ddJavaAgentJarURL;
    }

    @SuppressForbidden
    private static File getAgentFileFromJavaagentArg(List<File> agentFiles) {
        if (agentFiles.isEmpty()) {
            System.err.println("Could not get bootstrap jar from -javaagent arg: no argument specified");
            return null;
        }
        if (agentFiles.size() > 1) {
            System.err.println("Could not get bootstrap jar from -javaagent arg: multiple javaagents specified");
            return null;
        }
        return agentFiles.get(0);
    }

    @SuppressForbidden
    private static List<File> getAgentFilesFromVMArguments() {
        if (agentFiles == null) {
            agentFiles = new ArrayList<File>();
            for (String argument : CLIHelper.getVmArgs()) {
                if (!argument.startsWith(JAVA_AGENT_ARGUMENT)) continue;
                int index = argument.indexOf(61, JAVA_AGENT_ARGUMENT.length());
                String agentPathname = argument.substring(JAVA_AGENT_ARGUMENT.length(), index == -1 ? argument.length() : index);
                File agentFile = new File(agentPathname);
                if (agentFile.exists() && agentFile.isFile()) {
                    agentFiles.add(agentFile);
                    continue;
                }
                System.err.println("Could not get bootstrap jar from -javaagent arg: unable to find javaagent file: " + agentFile);
            }
        }
        return agentFiles;
    }

    @SuppressForbidden
    private static File getAgentFileUsingClassLoaderLookup() throws URISyntaxException {
        String thisClassResourceName = thisClass.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = thisClass.getClassLoader();
        URL thisClassUrl = classLoader == null ? ClassLoader.getSystemResource(thisClassResourceName) : classLoader.getResource(thisClassResourceName);
        if (thisClassUrl == null) {
            throw new IllegalStateException("Could not locate agent bootstrap class resource, not installing tracing agent");
        }
        File javaagentFile = new File(new URI(thisClassUrl.getFile().split("!")[0]));
        return javaagentFile;
    }

    private static void checkJarManifestMainClassIsThis(URL jarUrl) throws IOException {
        URL manifestUrl = new URL("jar:" + jarUrl + "!/META-INF/MANIFEST.MF");
        String mainClassLine = "Main-Class: " + thisClass.getCanonicalName();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(manifestUrl.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.equals(mainClassLine)) continue;
                return;
            }
        }
        throw new IllegalStateException("dd-java-agent is not installed, because class '" + thisClass.getCanonicalName() + "' is located in '" + jarUrl + "'. Make sure you don't have this .class-file anywhere, besides dd-java-agent.jar");
    }
}

