/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.civisibility.telemetry;

import datadog.trace.api.civisibility.telemetry.CiVisibilityMetricData;
import datadog.trace.api.civisibility.telemetry.TagValue;
import datadog.trace.api.civisibility.telemetry.tag.AgentlessLogSubmissionEnabled;
import datadog.trace.api.civisibility.telemetry.tag.AutoInjected;
import datadog.trace.api.civisibility.telemetry.tag.BrowserDriver;
import datadog.trace.api.civisibility.telemetry.tag.Command;
import datadog.trace.api.civisibility.telemetry.tag.CoverageEnabled;
import datadog.trace.api.civisibility.telemetry.tag.CoverageErrorType;
import datadog.trace.api.civisibility.telemetry.tag.EarlyFlakeDetectionAbortReason;
import datadog.trace.api.civisibility.telemetry.tag.EarlyFlakeDetectionEnabled;
import datadog.trace.api.civisibility.telemetry.tag.Endpoint;
import datadog.trace.api.civisibility.telemetry.tag.ErrorType;
import datadog.trace.api.civisibility.telemetry.tag.EventType;
import datadog.trace.api.civisibility.telemetry.tag.ExitCode;
import datadog.trace.api.civisibility.telemetry.tag.FailFastTestOrderEnabled;
import datadog.trace.api.civisibility.telemetry.tag.FlakyTestRetriesEnabled;
import datadog.trace.api.civisibility.telemetry.tag.HasCodeowner;
import datadog.trace.api.civisibility.telemetry.tag.HasFailedAllRetries;
import datadog.trace.api.civisibility.telemetry.tag.ImpactedTestsDetectionEnabled;
import datadog.trace.api.civisibility.telemetry.tag.IsAttemptToFix;
import datadog.trace.api.civisibility.telemetry.tag.IsDisabled;
import datadog.trace.api.civisibility.telemetry.tag.IsHeadless;
import datadog.trace.api.civisibility.telemetry.tag.IsModified;
import datadog.trace.api.civisibility.telemetry.tag.IsNew;
import datadog.trace.api.civisibility.telemetry.tag.IsQuarantined;
import datadog.trace.api.civisibility.telemetry.tag.IsRetry;
import datadog.trace.api.civisibility.telemetry.tag.IsRum;
import datadog.trace.api.civisibility.telemetry.tag.IsUnsupportedCI;
import datadog.trace.api.civisibility.telemetry.tag.ItrEnabled;
import datadog.trace.api.civisibility.telemetry.tag.ItrSkipEnabled;
import datadog.trace.api.civisibility.telemetry.tag.KnownTestsEnabled;
import datadog.trace.api.civisibility.telemetry.tag.Provider;
import datadog.trace.api.civisibility.telemetry.tag.RequestCompressed;
import datadog.trace.api.civisibility.telemetry.tag.RequireGit;
import datadog.trace.api.civisibility.telemetry.tag.RetryReason;
import datadog.trace.api.civisibility.telemetry.tag.StatusCode;
import datadog.trace.api.civisibility.telemetry.tag.TestFrameworkInstrumentation;
import datadog.trace.api.civisibility.telemetry.tag.TestManagementEnabled;
import java.util.Arrays;

public enum CiVisibilityCountMetric {
    TEST_SESSION("test_session", Provider.class, AutoInjected.class, AgentlessLogSubmissionEnabled.class, FailFastTestOrderEnabled.class),
    EVENT_CREATED("event_created", TestFrameworkInstrumentation.class, EventType.class, IsHeadless.class, HasCodeowner.class, IsUnsupportedCI.class),
    EVENT_FINISHED("event_finished", TestFrameworkInstrumentation.class, EventType.class, IsHeadless.class, HasCodeowner.class, IsUnsupportedCI.class, EarlyFlakeDetectionAbortReason.class),
    TEST_EVENT_FINISHED("event_finished", TestFrameworkInstrumentation.class, EventType.class, IsNew.class, IsModified.class, IsQuarantined.class, IsDisabled.class, IsAttemptToFix.class, IsRetry.class, HasFailedAllRetries.class, RetryReason.class, IsRum.class, BrowserDriver.class),
    CODE_COVERAGE_IS_EMPTY("code_coverage.is_empty", new Class[0]),
    CODE_COVERAGE_ERRORS("code_coverage.errors", CoverageErrorType.class),
    MANUAL_API_EVENTS("manual_api_events", EventType.class),
    EVENTS_ENQUEUED_FOR_SERIALIZATION("events_enqueued_for_serialization", new Class[0]),
    ENDPOINT_PAYLOAD_REQUESTS("endpoint_payload.requests", Endpoint.class, RequestCompressed.class),
    ENDPOINT_PAYLOAD_REQUESTS_ERRORS("endpoint_payload.requests_errors", Endpoint.class, ErrorType.class, StatusCode.class),
    ENDPOINT_PAYLOAD_DROPPED("endpoint_payload.dropped", Endpoint.class),
    GIT_COMMAND("git.command", Command.class),
    GIT_COMMAND_ERRORS("git.command_errors", Command.class, ExitCode.class),
    GIT_REQUESTS_SEARCH_COMMITS("git_requests.search_commits", RequestCompressed.class),
    GIT_REQUESTS_SEARCH_COMMITS_ERRORS("git_requests.search_commits_errors", ErrorType.class, StatusCode.class),
    GIT_REQUESTS_OBJECTS_PACK("git_requests.objects_pack", RequestCompressed.class),
    GIT_REQUESTS_OBJECTS_PACK_ERRORS("git_requests.objects_pack_errors", ErrorType.class, StatusCode.class),
    GIT_REQUESTS_SETTINGS("git_requests.settings", RequestCompressed.class),
    GIT_REQUESTS_SETTINGS_ERRORS("git_requests.settings_errors", ErrorType.class, StatusCode.class),
    GIT_REQUESTS_SETTINGS_RESPONSE("git_requests.settings_response", ItrEnabled.class, ItrSkipEnabled.class, CoverageEnabled.class, EarlyFlakeDetectionEnabled.class, FlakyTestRetriesEnabled.class, ImpactedTestsDetectionEnabled.class, KnownTestsEnabled.class, TestManagementEnabled.class, RequireGit.class),
    ITR_SKIPPABLE_TESTS_REQUEST("itr_skippable_tests.request", RequestCompressed.class),
    ITR_SKIPPABLE_TESTS_REQUEST_ERRORS("itr_skippable_tests.request_errors", ErrorType.class, StatusCode.class),
    ITR_SKIPPABLE_TESTS_RESPONSE_TESTS("itr_skippable_tests.response_tests", new Class[0]),
    ITR_SKIPPED("itr_skipped", EventType.class),
    ITR_UNSKIPPABLE("itr_unskippable", EventType.class),
    ITR_FORCED_RUN("itr_forced_run", EventType.class),
    KNOWN_TESTS_REQUEST("known_tests.request", RequestCompressed.class),
    KNOWN_TESTS_REQUEST_ERRORS("known_tests.request_errors", ErrorType.class, StatusCode.class),
    FLAKY_TESTS_REQUEST("flaky_tests.request", RequestCompressed.class),
    FLAKY_TESTS_REQUEST_ERRORS("flaky_tests.request_errors", ErrorType.class, StatusCode.class),
    IMPACTED_TESTS_DETECTION_REQUEST("impacted_tests_detection.request", RequestCompressed.class),
    IMPACTED_TESTS_DETECTION_REQUEST_ERRORS("impacted_tests_detection.request_errors", ErrorType.class, StatusCode.class),
    TEST_MANAGEMENT_TESTS_REQUEST("test_management.request", RequestCompressed.class),
    TEST_MANAGEMENT_TESTS_REQUEST_ERRORS("test_management.request_errors", ErrorType.class, StatusCode.class);

    private final String name;
    private final int index;
    private final Class<? extends TagValue>[] tags;
    private final TagValue[][] tagValues;
    private final int[] tagIdxMultipliers;

    @SafeVarargs
    private CiVisibilityCountMetric(String metricName, Class<? extends TagValue> ... metricTags) {
        int i;
        this.name = metricName;
        this.index = IndexHolder.INDEX;
        this.tags = metricTags;
        this.tagValues = new TagValue[this.tags.length][];
        for (i = 0; i < this.tags.length; ++i) {
            this.tagValues[i] = this.tags[i].getEnumConstants();
        }
        this.tagIdxMultipliers = new int[this.tags.length];
        if (this.tags.length != 0) {
            this.tagIdxMultipliers[0] = 1;
        }
        for (i = 1; i < this.tags.length; ++i) {
            this.tagIdxMultipliers[i] = this.tagIdxMultipliers[i - 1] * (this.tagValues[i - 1].length + 1);
        }
        IndexHolder.INDEX = this.getEndIndex();
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends TagValue>[] getTags() {
        return this.tags;
    }

    public int getEndIndex() {
        int delta = this.tagValues.length > 0 ? this.tagIdxMultipliers[this.tagIdxMultipliers.length - 1] * (this.tagValues[this.tagValues.length - 1].length + 1) : 1;
        return this.index + delta;
    }

    public CiVisibilityMetricData createData(long value, TagValue ... tagValues) {
        return new CiVisibilityMetricData(this.name, value, tagValues);
    }

    public int getIndex(TagValue ... tagValues) {
        int index = this.index;
        for (TagValue tagValue : tagValues) {
            if (tagValue == null) continue;
            index += this.calculateIdxDelta(tagValue);
        }
        return index;
    }

    private int calculateIdxDelta(TagValue tagValue) {
        Class<? extends TagValue> tag = tagValue.getDeclaringClass();
        for (int i = 0; i < this.tags.length; ++i) {
            if (tag != this.tags[i]) continue;
            return this.tagIdxMultipliers[i] * (tagValue.ordinal() + 1);
        }
        throw new IllegalArgumentException("Metric " + this.name() + " cannot be tagged with " + tag.getSimpleName() + ", allowed tags are " + Arrays.toString(this.tags));
    }

    public TagValue[] getTagValues(int index) {
        int tagValueIdx = 0;
        TagValue[] values = new TagValue[this.tags.length];
        index -= this.index;
        for (int i = 0; i < this.tags.length; ++i) {
            TagValue[] possibleValues = this.tagValues[i];
            int tagCardinality = possibleValues.length + 1;
            int tagOrdinal = index % tagCardinality;
            if (tagOrdinal != 0) {
                values[tagValueIdx++] = possibleValues[--tagOrdinal];
            }
            index /= tagCardinality;
        }
        return tagValueIdx == values.length ? values : Arrays.copyOf(values, tagValueIdx);
    }

    public static int count() {
        return IndexHolder.INDEX;
    }

    static class IndexHolder {
        private static int INDEX = 0;

        IndexHolder() {
        }
    }
}

