/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsLookupProcessorType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"is_enabled", "lookup_enrichment_table", "name", "source", "target", "type"})
public class ReferenceTableLogsLookupProcessor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_LOOKUP_ENRICHMENT_TABLE = "lookup_enrichment_table";
    private String lookupEnrichmentTable;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private String source;
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsLookupProcessorType type = LogsLookupProcessorType.LOOKUP_PROCESSOR;

    public ReferenceTableLogsLookupProcessor() {
    }

    @JsonCreator
    public ReferenceTableLogsLookupProcessor(@JsonProperty(required=true, value="lookup_enrichment_table") String lookupEnrichmentTable, @JsonProperty(required=true, value="source") String source, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsLookupProcessorType type) {
        this.lookupEnrichmentTable = lookupEnrichmentTable;
        this.source = source;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ReferenceTableLogsLookupProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public ReferenceTableLogsLookupProcessor lookupEnrichmentTable(String lookupEnrichmentTable) {
        this.lookupEnrichmentTable = lookupEnrichmentTable;
        return this;
    }

    @JsonProperty(value="lookup_enrichment_table")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLookupEnrichmentTable() {
        return this.lookupEnrichmentTable;
    }

    public void setLookupEnrichmentTable(String lookupEnrichmentTable) {
        this.lookupEnrichmentTable = lookupEnrichmentTable;
    }

    public ReferenceTableLogsLookupProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReferenceTableLogsLookupProcessor source(String source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ReferenceTableLogsLookupProcessor target(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public ReferenceTableLogsLookupProcessor type(LogsLookupProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsLookupProcessorType getType() {
        return this.type;
    }

    public void setType(LogsLookupProcessorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceTableLogsLookupProcessor referenceTableLogsLookupProcessor = (ReferenceTableLogsLookupProcessor)o;
        return Objects.equals(this.isEnabled, referenceTableLogsLookupProcessor.isEnabled) && Objects.equals(this.lookupEnrichmentTable, referenceTableLogsLookupProcessor.lookupEnrichmentTable) && Objects.equals(this.name, referenceTableLogsLookupProcessor.name) && Objects.equals(this.source, referenceTableLogsLookupProcessor.source) && Objects.equals(this.target, referenceTableLogsLookupProcessor.target) && Objects.equals(this.type, referenceTableLogsLookupProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.lookupEnrichmentTable, this.name, this.source, this.target, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReferenceTableLogsLookupProcessor {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    lookupEnrichmentTable: ").append(this.toIndentedString(this.lookupEnrichmentTable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

