/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsFilter;
import com.datadog.api.client.v1.model.LogsPipelineProcessorType;
import com.datadog.api.client.v1.model.LogsProcessor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"filter", "is_enabled", "name", "processors", "type"})
public class LogsPipelineProcessor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROCESSORS = "processors";
    private List<LogsProcessor> processors = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsPipelineProcessorType type = LogsPipelineProcessorType.PIPELINE;

    public LogsPipelineProcessor() {
    }

    @JsonCreator
    public LogsPipelineProcessor(@JsonProperty(required=true, value="type") LogsPipelineProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsPipelineProcessor filter(LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    public LogsPipelineProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsPipelineProcessor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsPipelineProcessor processors(List<LogsProcessor> processors) {
        this.processors = processors;
        for (LogsProcessor item : processors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsPipelineProcessor addProcessorsItem(LogsProcessor processorsItem) {
        if (this.processors == null) {
            this.processors = new ArrayList<LogsProcessor>();
        }
        this.processors.add(processorsItem);
        this.unparsed |= processorsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="processors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<LogsProcessor> processors) {
        this.processors = processors;
    }

    public LogsPipelineProcessor type(LogsPipelineProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsPipelineProcessorType getType() {
        return this.type;
    }

    public void setType(LogsPipelineProcessorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsPipelineProcessor logsPipelineProcessor = (LogsPipelineProcessor)o;
        return Objects.equals(this.filter, logsPipelineProcessor.filter) && Objects.equals(this.isEnabled, logsPipelineProcessor.isEnabled) && Objects.equals(this.name, logsPipelineProcessor.name) && Objects.equals(this.processors, logsPipelineProcessor.processors) && Objects.equals(this.type, logsPipelineProcessor.type);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.isEnabled, this.name, this.processors, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsPipelineProcessor {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    processors: ").append(this.toIndentedString(this.processors)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

