/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.DistributionPointItem;
import com.datadog.api.client.v1.model.DistributionPointsType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"host", "metric", "points", "tags", "type"})
public class DistributionPointsSeries {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_POINTS = "points";
    private List<List<DistributionPointItem>> points = new ArrayList<List<DistributionPointItem>>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DistributionPointsType type = DistributionPointsType.DISTRIBUTION;

    public DistributionPointsSeries() {
    }

    @JsonCreator
    public DistributionPointsSeries(@JsonProperty(required=true, value="metric") String metric, @JsonProperty(required=true, value="points") List<List<DistributionPointItem>> points) {
        this.metric = metric;
        this.points = points;
    }

    public DistributionPointsSeries host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public DistributionPointsSeries metric(String metric) {
        this.metric = metric;
        return this;
    }

    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public DistributionPointsSeries points(List<List<DistributionPointItem>> points) {
        this.points = points;
        return this;
    }

    public DistributionPointsSeries addPointsItem(List<DistributionPointItem> pointsItem) {
        this.points.add(pointsItem);
        return this;
    }

    @JsonProperty(value="points")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<List<DistributionPointItem>> getPoints() {
        return this.points;
    }

    public void setPoints(List<List<DistributionPointItem>> points) {
        this.points = points;
    }

    public DistributionPointsSeries tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public DistributionPointsSeries addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public DistributionPointsSeries type(DistributionPointsType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DistributionPointsType getType() {
        return this.type;
    }

    public void setType(DistributionPointsType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionPointsSeries distributionPointsSeries = (DistributionPointsSeries)o;
        return Objects.equals(this.host, distributionPointsSeries.host) && Objects.equals(this.metric, distributionPointsSeries.metric) && Objects.equals(this.points, distributionPointsSeries.points) && Objects.equals(this.tags, distributionPointsSeries.tags) && Objects.equals(this.type, distributionPointsSeries.type);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.metric, this.points, this.tags, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DistributionPointsSeries {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

