/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AWSAssumeRoleType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "external_id", "principal_id", "role", "type"})
public class AWSAssumeRole {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "external_id";
    private String externalId;
    public static final String JSON_PROPERTY_PRINCIPAL_ID = "principal_id";
    private String principalId;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AWSAssumeRoleType type;
    private Map<String, Object> additionalProperties;

    public AWSAssumeRole() {
    }

    @JsonCreator
    public AWSAssumeRole(@JsonProperty(required=true, value="account_id") String accountId, @JsonProperty(required=true, value="role") String role, @JsonProperty(required=true, value="type") AWSAssumeRoleType type) {
        this.accountId = accountId;
        this.role = role;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AWSAssumeRole accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Nullable
    @JsonProperty(value="external_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @Nullable
    @JsonProperty(value="principal_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrincipalId() {
        return this.principalId;
    }

    public AWSAssumeRole role(String role) {
        this.role = role;
        return this;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public AWSAssumeRole type(AWSAssumeRoleType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AWSAssumeRoleType getType() {
        return this.type;
    }

    public void setType(AWSAssumeRoleType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AWSAssumeRole putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAssumeRole awsAssumeRole = (AWSAssumeRole)o;
        return Objects.equals(this.accountId, awsAssumeRole.accountId) && Objects.equals(this.externalId, awsAssumeRole.externalId) && Objects.equals(this.principalId, awsAssumeRole.principalId) && Objects.equals(this.role, awsAssumeRole.role) && Objects.equals(this.type, awsAssumeRole.type) && Objects.equals(this.additionalProperties, awsAssumeRole.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.externalId, this.principalId, this.role, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAssumeRole {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    principalId: ").append(this.toIndentedString(this.principalId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

