/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.EntityData;
import com.datadog.api.client.v2.model.EntityResponseArray;
import com.datadog.api.client.v2.model.IncludeType;
import com.datadog.api.client.v2.model.KindData;
import com.datadog.api.client.v2.model.ListEntityCatalogResponse;
import com.datadog.api.client.v2.model.ListKindCatalogResponse;
import com.datadog.api.client.v2.model.ListRelationCatalogResponse;
import com.datadog.api.client.v2.model.RelationIncludeType;
import com.datadog.api.client.v2.model.RelationResponse;
import com.datadog.api.client.v2.model.RelationType;
import com.datadog.api.client.v2.model.UpsertCatalogEntityRequest;
import com.datadog.api.client.v2.model.UpsertCatalogEntityResponse;
import com.datadog.api.client.v2.model.UpsertCatalogKindRequest;
import com.datadog.api.client.v2.model.UpsertCatalogKindResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class SoftwareCatalogApi {
    private ApiClient apiClient;

    public SoftwareCatalogApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SoftwareCatalogApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteCatalogEntity(String entityId) throws ApiException {
        this.deleteCatalogEntityWithHttpInfo(entityId);
    }

    public CompletableFuture<Void> deleteCatalogEntityAsync(String entityId) {
        return this.deleteCatalogEntityWithHttpInfoAsync(entityId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCatalogEntityWithHttpInfo(String entityId) throws ApiException {
        Object localVarPostBody = null;
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling deleteCatalogEntity");
        }
        String localVarPath = "/api/v2/catalog/entity/{entity_id}".replaceAll("\\{entity_id\\}", this.apiClient.escapeString(entityId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.deleteCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCatalogEntityWithHttpInfoAsync(String entityId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (entityId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entityId' when calling deleteCatalogEntity"));
            return result;
        }
        String localVarPath = "/api/v2/catalog/entity/{entity_id}".replaceAll("\\{entity_id\\}", this.apiClient.escapeString(entityId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.deleteCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteCatalogKind(String kindId) throws ApiException {
        this.deleteCatalogKindWithHttpInfo(kindId);
    }

    public CompletableFuture<Void> deleteCatalogKindAsync(String kindId) {
        return this.deleteCatalogKindWithHttpInfoAsync(kindId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCatalogKindWithHttpInfo(String kindId) throws ApiException {
        Object localVarPostBody = null;
        if (kindId == null) {
            throw new ApiException(400, "Missing the required parameter 'kindId' when calling deleteCatalogKind");
        }
        String localVarPath = "/api/v2/catalog/kind/{kind_id}".replaceAll("\\{kind_id\\}", this.apiClient.escapeString(kindId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.deleteCatalogKind", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCatalogKindWithHttpInfoAsync(String kindId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (kindId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'kindId' when calling deleteCatalogKind"));
            return result;
        }
        String localVarPath = "/api/v2/catalog/kind/{kind_id}".replaceAll("\\{kind_id\\}", this.apiClient.escapeString(kindId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.deleteCatalogKind", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ListEntityCatalogResponse listCatalogEntity() throws ApiException {
        return this.listCatalogEntityWithHttpInfo(new ListCatalogEntityOptionalParameters()).getData();
    }

    public CompletableFuture<ListEntityCatalogResponse> listCatalogEntityAsync() {
        return this.listCatalogEntityWithHttpInfoAsync(new ListCatalogEntityOptionalParameters()).thenApply(response -> (ListEntityCatalogResponse)response.getData());
    }

    public ListEntityCatalogResponse listCatalogEntity(ListCatalogEntityOptionalParameters parameters) throws ApiException {
        return this.listCatalogEntityWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListEntityCatalogResponse> listCatalogEntityAsync(ListCatalogEntityOptionalParameters parameters) {
        return this.listCatalogEntityWithHttpInfoAsync(parameters).thenApply(response -> (ListEntityCatalogResponse)response.getData());
    }

    public PaginationIterable<EntityData> listCatalogEntityWithPagination() {
        ListCatalogEntityOptionalParameters parameters = new ListCatalogEntityOptionalParameters();
        return this.listCatalogEntityWithPagination(parameters);
    }

    public PaginationIterable<EntityData> listCatalogEntityWithPagination(ListCatalogEntityOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 100L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<EntityData> iterator = new PaginationIterable<EntityData>(this, "listCatalogEntity", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListEntityCatalogResponse> listCatalogEntityWithHttpInfo(ListCatalogEntityOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String filterId = parameters.filterId;
        String filterRef = parameters.filterRef;
        String filterName = parameters.filterName;
        String filterKind = parameters.filterKind;
        String filterOwner = parameters.filterOwner;
        RelationType filterRelationType = parameters.filterRelationType;
        String filterExcludeSnapshot = parameters.filterExcludeSnapshot;
        IncludeType include = parameters.include;
        Boolean includeDiscovered = parameters.includeDiscovered;
        String localVarPath = "/api/v2/catalog/entity";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[ref]", filterRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[kind]", filterKind));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[owner]", filterOwner));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[relation][type]", filterRelationType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[exclude_snapshot]", filterExcludeSnapshot));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeDiscovered", includeDiscovered));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogEntity", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListEntityCatalogResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListEntityCatalogResponse>> listCatalogEntityWithHttpInfoAsync(ListCatalogEntityOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String filterId = parameters.filterId;
        String filterRef = parameters.filterRef;
        String filterName = parameters.filterName;
        String filterKind = parameters.filterKind;
        String filterOwner = parameters.filterOwner;
        RelationType filterRelationType = parameters.filterRelationType;
        String filterExcludeSnapshot = parameters.filterExcludeSnapshot;
        IncludeType include = parameters.include;
        Boolean includeDiscovered = parameters.includeDiscovered;
        String localVarPath = "/api/v2/catalog/entity";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[ref]", filterRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[kind]", filterKind));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[owner]", filterOwner));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[relation][type]", filterRelationType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[exclude_snapshot]", filterExcludeSnapshot));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeDiscovered", includeDiscovered));
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogEntity", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListEntityCatalogResponse>> result = new CompletableFuture<ApiResponse<ListEntityCatalogResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListEntityCatalogResponse>(){});
    }

    public ListKindCatalogResponse listCatalogKind() throws ApiException {
        return this.listCatalogKindWithHttpInfo(new ListCatalogKindOptionalParameters()).getData();
    }

    public CompletableFuture<ListKindCatalogResponse> listCatalogKindAsync() {
        return this.listCatalogKindWithHttpInfoAsync(new ListCatalogKindOptionalParameters()).thenApply(response -> (ListKindCatalogResponse)response.getData());
    }

    public ListKindCatalogResponse listCatalogKind(ListCatalogKindOptionalParameters parameters) throws ApiException {
        return this.listCatalogKindWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListKindCatalogResponse> listCatalogKindAsync(ListCatalogKindOptionalParameters parameters) {
        return this.listCatalogKindWithHttpInfoAsync(parameters).thenApply(response -> (ListKindCatalogResponse)response.getData());
    }

    public PaginationIterable<KindData> listCatalogKindWithPagination() {
        ListCatalogKindOptionalParameters parameters = new ListCatalogKindOptionalParameters();
        return this.listCatalogKindWithPagination(parameters);
    }

    public PaginationIterable<KindData> listCatalogKindWithPagination(ListCatalogKindOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 100L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<KindData> iterator = new PaginationIterable<KindData>(this, "listCatalogKind", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListKindCatalogResponse> listCatalogKindWithHttpInfo(ListCatalogKindOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String filterId = parameters.filterId;
        String filterName = parameters.filterName;
        String localVarPath = "/api/v2/catalog/kind";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogKind", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListKindCatalogResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListKindCatalogResponse>> listCatalogKindWithHttpInfoAsync(ListCatalogKindOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String filterId = parameters.filterId;
        String filterName = parameters.filterName;
        String localVarPath = "/api/v2/catalog/kind";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogKind", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListKindCatalogResponse>> result = new CompletableFuture<ApiResponse<ListKindCatalogResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListKindCatalogResponse>(){});
    }

    public ListRelationCatalogResponse listCatalogRelation() throws ApiException {
        return this.listCatalogRelationWithHttpInfo(new ListCatalogRelationOptionalParameters()).getData();
    }

    public CompletableFuture<ListRelationCatalogResponse> listCatalogRelationAsync() {
        return this.listCatalogRelationWithHttpInfoAsync(new ListCatalogRelationOptionalParameters()).thenApply(response -> (ListRelationCatalogResponse)response.getData());
    }

    public ListRelationCatalogResponse listCatalogRelation(ListCatalogRelationOptionalParameters parameters) throws ApiException {
        return this.listCatalogRelationWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListRelationCatalogResponse> listCatalogRelationAsync(ListCatalogRelationOptionalParameters parameters) {
        return this.listCatalogRelationWithHttpInfoAsync(parameters).thenApply(response -> (ListRelationCatalogResponse)response.getData());
    }

    public PaginationIterable<RelationResponse> listCatalogRelationWithPagination() {
        ListCatalogRelationOptionalParameters parameters = new ListCatalogRelationOptionalParameters();
        return this.listCatalogRelationWithPagination(parameters);
    }

    public PaginationIterable<RelationResponse> listCatalogRelationWithPagination(ListCatalogRelationOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 100L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<RelationResponse> iterator = new PaginationIterable<RelationResponse>(this, "listCatalogRelation", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListRelationCatalogResponse> listCatalogRelationWithHttpInfo(ListCatalogRelationOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        RelationType filterType = parameters.filterType;
        String filterFromRef = parameters.filterFromRef;
        String filterToRef = parameters.filterToRef;
        RelationIncludeType include = parameters.include;
        Boolean includeDiscovered = parameters.includeDiscovered;
        String localVarPath = "/api/v2/catalog/relation";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from_ref]", filterFromRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to_ref]", filterToRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeDiscovered", includeDiscovered));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogRelation", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListRelationCatalogResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListRelationCatalogResponse>> listCatalogRelationWithHttpInfoAsync(ListCatalogRelationOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        RelationType filterType = parameters.filterType;
        String filterFromRef = parameters.filterFromRef;
        String filterToRef = parameters.filterToRef;
        RelationIncludeType include = parameters.include;
        Boolean includeDiscovered = parameters.includeDiscovered;
        String localVarPath = "/api/v2/catalog/relation";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from_ref]", filterFromRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to_ref]", filterToRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeDiscovered", includeDiscovered));
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogRelation", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListRelationCatalogResponse>> result = new CompletableFuture<ApiResponse<ListRelationCatalogResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListRelationCatalogResponse>(){});
    }

    public EntityResponseArray previewCatalogEntities() throws ApiException {
        return this.previewCatalogEntitiesWithHttpInfo().getData();
    }

    public CompletableFuture<EntityResponseArray> previewCatalogEntitiesAsync() {
        return this.previewCatalogEntitiesWithHttpInfoAsync().thenApply(response -> (EntityResponseArray)response.getData());
    }

    public ApiResponse<EntityResponseArray> previewCatalogEntitiesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/catalog/entity/preview";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.previewCatalogEntities", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EntityResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<EntityResponseArray>> previewCatalogEntitiesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/catalog/entity/preview";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.previewCatalogEntities", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EntityResponseArray>> result = new CompletableFuture<ApiResponse<EntityResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EntityResponseArray>(){});
    }

    public UpsertCatalogEntityResponse upsertCatalogEntity(UpsertCatalogEntityRequest body) throws ApiException {
        return this.upsertCatalogEntityWithHttpInfo(body).getData();
    }

    public CompletableFuture<UpsertCatalogEntityResponse> upsertCatalogEntityAsync(UpsertCatalogEntityRequest body) {
        return this.upsertCatalogEntityWithHttpInfoAsync(body).thenApply(response -> (UpsertCatalogEntityResponse)response.getData());
    }

    public ApiResponse<UpsertCatalogEntityResponse> upsertCatalogEntityWithHttpInfo(UpsertCatalogEntityRequest body) throws ApiException {
        UpsertCatalogEntityRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogEntity");
        }
        String localVarPath = "/api/v2/catalog/entity";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.upsertCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpsertCatalogEntityResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>> upsertCatalogEntityWithHttpInfoAsync(UpsertCatalogEntityRequest body) {
        Invocation.Builder builder;
        UpsertCatalogEntityRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>> result = new CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogEntity"));
            return result;
        }
        String localVarPath = "/api/v2/catalog/entity";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.upsertCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>> result = new CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpsertCatalogEntityResponse>(){});
    }

    public UpsertCatalogKindResponse upsertCatalogKind(UpsertCatalogKindRequest body) throws ApiException {
        return this.upsertCatalogKindWithHttpInfo(body).getData();
    }

    public CompletableFuture<UpsertCatalogKindResponse> upsertCatalogKindAsync(UpsertCatalogKindRequest body) {
        return this.upsertCatalogKindWithHttpInfoAsync(body).thenApply(response -> (UpsertCatalogKindResponse)response.getData());
    }

    public ApiResponse<UpsertCatalogKindResponse> upsertCatalogKindWithHttpInfo(UpsertCatalogKindRequest body) throws ApiException {
        UpsertCatalogKindRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogKind");
        }
        String localVarPath = "/api/v2/catalog/kind";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.upsertCatalogKind", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpsertCatalogKindResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpsertCatalogKindResponse>> upsertCatalogKindWithHttpInfoAsync(UpsertCatalogKindRequest body) {
        Invocation.Builder builder;
        UpsertCatalogKindRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UpsertCatalogKindResponse>> result = new CompletableFuture<ApiResponse<UpsertCatalogKindResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogKind"));
            return result;
        }
        String localVarPath = "/api/v2/catalog/kind";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.upsertCatalogKind", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpsertCatalogKindResponse>> result = new CompletableFuture<ApiResponse<UpsertCatalogKindResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpsertCatalogKindResponse>(){});
    }

    public static class ListCatalogRelationOptionalParameters {
        private Long pageOffset;
        private Long pageLimit;
        private RelationType filterType;
        private String filterFromRef;
        private String filterToRef;
        private RelationIncludeType include;
        private Boolean includeDiscovered;

        public ListCatalogRelationOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListCatalogRelationOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListCatalogRelationOptionalParameters filterType(RelationType filterType) {
            this.filterType = filterType;
            return this;
        }

        public ListCatalogRelationOptionalParameters filterFromRef(String filterFromRef) {
            this.filterFromRef = filterFromRef;
            return this;
        }

        public ListCatalogRelationOptionalParameters filterToRef(String filterToRef) {
            this.filterToRef = filterToRef;
            return this;
        }

        public ListCatalogRelationOptionalParameters include(RelationIncludeType include) {
            this.include = include;
            return this;
        }

        public ListCatalogRelationOptionalParameters includeDiscovered(Boolean includeDiscovered) {
            this.includeDiscovered = includeDiscovered;
            return this;
        }
    }

    public static class ListCatalogKindOptionalParameters {
        private Long pageOffset;
        private Long pageLimit;
        private String filterId;
        private String filterName;

        public ListCatalogKindOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListCatalogKindOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListCatalogKindOptionalParameters filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public ListCatalogKindOptionalParameters filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }
    }

    public static class ListCatalogEntityOptionalParameters {
        private Long pageOffset;
        private Long pageLimit;
        private String filterId;
        private String filterRef;
        private String filterName;
        private String filterKind;
        private String filterOwner;
        private RelationType filterRelationType;
        private String filterExcludeSnapshot;
        private IncludeType include;
        private Boolean includeDiscovered;

        public ListCatalogEntityOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListCatalogEntityOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterRef(String filterRef) {
            this.filterRef = filterRef;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterKind(String filterKind) {
            this.filterKind = filterKind;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterOwner(String filterOwner) {
            this.filterOwner = filterOwner;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterRelationType(RelationType filterRelationType) {
            this.filterRelationType = filterRelationType;
            return this;
        }

        public ListCatalogEntityOptionalParameters filterExcludeSnapshot(String filterExcludeSnapshot) {
            this.filterExcludeSnapshot = filterExcludeSnapshot;
            return this;
        }

        public ListCatalogEntityOptionalParameters include(IncludeType include) {
            this.include = include;
            return this;
        }

        public ListCatalogEntityOptionalParameters includeDiscovered(Boolean includeDiscovered) {
            this.includeDiscovered = includeDiscovered;
            return this;
        }
    }
}

