/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsSchemaData;
import com.datadog.api.client.v1.model.LogsSchemaMapper;
import com.datadog.api.client.v1.model.LogsSchemaProcessorType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"is_enabled", "mappers", "name", "schema", "type"})
public class LogsSchemaProcessor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_MAPPERS = "mappers";
    private List<LogsSchemaMapper> mappers = new ArrayList<LogsSchemaMapper>();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private LogsSchemaData schema;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsSchemaProcessorType type = LogsSchemaProcessorType.SCHEMA_PROCESSOR;
    private Map<String, Object> additionalProperties;

    public LogsSchemaProcessor() {
    }

    @JsonCreator
    public LogsSchemaProcessor(@JsonProperty(required=true, value="mappers") List<LogsSchemaMapper> mappers, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="schema") LogsSchemaData schema, @JsonProperty(required=true, value="type") LogsSchemaProcessorType type) {
        this.mappers = mappers;
        this.name = name;
        this.schema = schema;
        this.unparsed |= schema.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsSchemaProcessor isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsSchemaProcessor mappers(List<LogsSchemaMapper> mappers) {
        this.mappers = mappers;
        for (LogsSchemaMapper item : mappers) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsSchemaProcessor addMappersItem(LogsSchemaMapper mappersItem) {
        this.mappers.add(mappersItem);
        this.unparsed |= mappersItem.unparsed;
        return this;
    }

    @JsonProperty(value="mappers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<LogsSchemaMapper> getMappers() {
        return this.mappers;
    }

    public void setMappers(List<LogsSchemaMapper> mappers) {
        this.mappers = mappers;
    }

    public LogsSchemaProcessor name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsSchemaProcessor schema(LogsSchemaData schema) {
        this.schema = schema;
        this.unparsed |= schema.unparsed;
        return this;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsSchemaData getSchema() {
        return this.schema;
    }

    public void setSchema(LogsSchemaData schema) {
        this.schema = schema;
    }

    public LogsSchemaProcessor type(LogsSchemaProcessorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsSchemaProcessorType getType() {
        return this.type;
    }

    public void setType(LogsSchemaProcessorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public LogsSchemaProcessor putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsSchemaProcessor logsSchemaProcessor = (LogsSchemaProcessor)o;
        return Objects.equals(this.isEnabled, logsSchemaProcessor.isEnabled) && Objects.equals(this.mappers, logsSchemaProcessor.mappers) && Objects.equals(this.name, logsSchemaProcessor.name) && Objects.equals(this.schema, logsSchemaProcessor.schema) && Objects.equals(this.type, logsSchemaProcessor.type) && Objects.equals(this.additionalProperties, logsSchemaProcessor.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.mappers, this.name, this.schema, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsSchemaProcessor {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    mappers: ").append(this.toIndentedString(this.mappers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

