/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FiltersPerProduct;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "principals", "product_filters"})
public class DatasetAttributesRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRINCIPALS = "principals";
    private List<String> principals = new ArrayList<String>();
    public static final String JSON_PROPERTY_PRODUCT_FILTERS = "product_filters";
    private List<FiltersPerProduct> productFilters = new ArrayList<FiltersPerProduct>();
    private Map<String, Object> additionalProperties;

    public DatasetAttributesRequest() {
    }

    @JsonCreator
    public DatasetAttributesRequest(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="principals") List<String> principals, @JsonProperty(required=true, value="product_filters") List<FiltersPerProduct> productFilters) {
        this.name = name;
        this.principals = principals;
        this.productFilters = productFilters;
    }

    public DatasetAttributesRequest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatasetAttributesRequest principals(List<String> principals) {
        this.principals = principals;
        return this;
    }

    public DatasetAttributesRequest addPrincipalsItem(String principalsItem) {
        this.principals.add(principalsItem);
        return this;
    }

    @JsonProperty(value="principals")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
    }

    public DatasetAttributesRequest productFilters(List<FiltersPerProduct> productFilters) {
        this.productFilters = productFilters;
        for (FiltersPerProduct item : productFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public DatasetAttributesRequest addProductFiltersItem(FiltersPerProduct productFiltersItem) {
        this.productFilters.add(productFiltersItem);
        this.unparsed |= productFiltersItem.unparsed;
        return this;
    }

    @JsonProperty(value="product_filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FiltersPerProduct> getProductFilters() {
        return this.productFilters;
    }

    public void setProductFilters(List<FiltersPerProduct> productFilters) {
        this.productFilters = productFilters;
    }

    @JsonAnySetter
    public DatasetAttributesRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetAttributesRequest datasetAttributesRequest = (DatasetAttributesRequest)o;
        return Objects.equals(this.name, datasetAttributesRequest.name) && Objects.equals(this.principals, datasetAttributesRequest.principals) && Objects.equals(this.productFilters, datasetAttributesRequest.productFilters) && Objects.equals(this.additionalProperties, datasetAttributesRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.principals, this.productFilters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetAttributesRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    principals: ").append(this.toIndentedString(this.principals)).append("\n");
        sb.append("    productFilters: ").append(this.toIndentedString(this.productFilters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

