/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetConfigurationFile;
import com.datadog.api.client.v2.model.FleetDetectedIntegration;
import com.datadog.api.client.v2.model.FleetIntegrationDetails;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"configuration_files", "datadog_agent_key", "error_integrations", "missing_integrations", "warning_integrations", "working_integrations"})
public class FleetIntegrationsByStatus {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIGURATION_FILES = "configuration_files";
    private List<FleetConfigurationFile> configurationFiles = null;
    public static final String JSON_PROPERTY_DATADOG_AGENT_KEY = "datadog_agent_key";
    private String datadogAgentKey;
    public static final String JSON_PROPERTY_ERROR_INTEGRATIONS = "error_integrations";
    private List<FleetIntegrationDetails> errorIntegrations = null;
    public static final String JSON_PROPERTY_MISSING_INTEGRATIONS = "missing_integrations";
    private List<FleetDetectedIntegration> missingIntegrations = null;
    public static final String JSON_PROPERTY_WARNING_INTEGRATIONS = "warning_integrations";
    private List<FleetIntegrationDetails> warningIntegrations = null;
    public static final String JSON_PROPERTY_WORKING_INTEGRATIONS = "working_integrations";
    private List<FleetIntegrationDetails> workingIntegrations = null;
    private Map<String, Object> additionalProperties;

    public FleetIntegrationsByStatus configurationFiles(List<FleetConfigurationFile> configurationFiles) {
        this.configurationFiles = configurationFiles;
        for (FleetConfigurationFile item : configurationFiles) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetIntegrationsByStatus addConfigurationFilesItem(FleetConfigurationFile configurationFilesItem) {
        if (this.configurationFiles == null) {
            this.configurationFiles = new ArrayList<FleetConfigurationFile>();
        }
        this.configurationFiles.add(configurationFilesItem);
        this.unparsed |= configurationFilesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="configuration_files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetConfigurationFile> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void setConfigurationFiles(List<FleetConfigurationFile> configurationFiles) {
        this.configurationFiles = configurationFiles;
    }

    public FleetIntegrationsByStatus datadogAgentKey(String datadogAgentKey) {
        this.datadogAgentKey = datadogAgentKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="datadog_agent_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatadogAgentKey() {
        return this.datadogAgentKey;
    }

    public void setDatadogAgentKey(String datadogAgentKey) {
        this.datadogAgentKey = datadogAgentKey;
    }

    public FleetIntegrationsByStatus errorIntegrations(List<FleetIntegrationDetails> errorIntegrations) {
        this.errorIntegrations = errorIntegrations;
        for (FleetIntegrationDetails item : errorIntegrations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetIntegrationsByStatus addErrorIntegrationsItem(FleetIntegrationDetails errorIntegrationsItem) {
        if (this.errorIntegrations == null) {
            this.errorIntegrations = new ArrayList<FleetIntegrationDetails>();
        }
        this.errorIntegrations.add(errorIntegrationsItem);
        this.unparsed |= errorIntegrationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="error_integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetIntegrationDetails> getErrorIntegrations() {
        return this.errorIntegrations;
    }

    public void setErrorIntegrations(List<FleetIntegrationDetails> errorIntegrations) {
        this.errorIntegrations = errorIntegrations;
    }

    public FleetIntegrationsByStatus missingIntegrations(List<FleetDetectedIntegration> missingIntegrations) {
        this.missingIntegrations = missingIntegrations;
        for (FleetDetectedIntegration item : missingIntegrations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetIntegrationsByStatus addMissingIntegrationsItem(FleetDetectedIntegration missingIntegrationsItem) {
        if (this.missingIntegrations == null) {
            this.missingIntegrations = new ArrayList<FleetDetectedIntegration>();
        }
        this.missingIntegrations.add(missingIntegrationsItem);
        this.unparsed |= missingIntegrationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="missing_integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetDetectedIntegration> getMissingIntegrations() {
        return this.missingIntegrations;
    }

    public void setMissingIntegrations(List<FleetDetectedIntegration> missingIntegrations) {
        this.missingIntegrations = missingIntegrations;
    }

    public FleetIntegrationsByStatus warningIntegrations(List<FleetIntegrationDetails> warningIntegrations) {
        this.warningIntegrations = warningIntegrations;
        for (FleetIntegrationDetails item : warningIntegrations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetIntegrationsByStatus addWarningIntegrationsItem(FleetIntegrationDetails warningIntegrationsItem) {
        if (this.warningIntegrations == null) {
            this.warningIntegrations = new ArrayList<FleetIntegrationDetails>();
        }
        this.warningIntegrations.add(warningIntegrationsItem);
        this.unparsed |= warningIntegrationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="warning_integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetIntegrationDetails> getWarningIntegrations() {
        return this.warningIntegrations;
    }

    public void setWarningIntegrations(List<FleetIntegrationDetails> warningIntegrations) {
        this.warningIntegrations = warningIntegrations;
    }

    public FleetIntegrationsByStatus workingIntegrations(List<FleetIntegrationDetails> workingIntegrations) {
        this.workingIntegrations = workingIntegrations;
        for (FleetIntegrationDetails item : workingIntegrations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetIntegrationsByStatus addWorkingIntegrationsItem(FleetIntegrationDetails workingIntegrationsItem) {
        if (this.workingIntegrations == null) {
            this.workingIntegrations = new ArrayList<FleetIntegrationDetails>();
        }
        this.workingIntegrations.add(workingIntegrationsItem);
        this.unparsed |= workingIntegrationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="working_integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetIntegrationDetails> getWorkingIntegrations() {
        return this.workingIntegrations;
    }

    public void setWorkingIntegrations(List<FleetIntegrationDetails> workingIntegrations) {
        this.workingIntegrations = workingIntegrations;
    }

    @JsonAnySetter
    public FleetIntegrationsByStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetIntegrationsByStatus fleetIntegrationsByStatus = (FleetIntegrationsByStatus)o;
        return Objects.equals(this.configurationFiles, fleetIntegrationsByStatus.configurationFiles) && Objects.equals(this.datadogAgentKey, fleetIntegrationsByStatus.datadogAgentKey) && Objects.equals(this.errorIntegrations, fleetIntegrationsByStatus.errorIntegrations) && Objects.equals(this.missingIntegrations, fleetIntegrationsByStatus.missingIntegrations) && Objects.equals(this.warningIntegrations, fleetIntegrationsByStatus.warningIntegrations) && Objects.equals(this.workingIntegrations, fleetIntegrationsByStatus.workingIntegrations) && Objects.equals(this.additionalProperties, fleetIntegrationsByStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.configurationFiles, this.datadogAgentKey, this.errorIntegrations, this.missingIntegrations, this.warningIntegrations, this.workingIntegrations, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetIntegrationsByStatus {\n");
        sb.append("    configurationFiles: ").append(this.toIndentedString(this.configurationFiles)).append("\n");
        sb.append("    datadogAgentKey: ").append(this.toIndentedString(this.datadogAgentKey)).append("\n");
        sb.append("    errorIntegrations: ").append(this.toIndentedString(this.errorIntegrations)).append("\n");
        sb.append("    missingIntegrations: ").append(this.toIndentedString(this.missingIntegrations)).append("\n");
        sb.append("    warningIntegrations: ").append(this.toIndentedString(this.warningIntegrations)).append("\n");
        sb.append("    workingIntegrations: ").append(this.toIndentedString(this.workingIntegrations)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

