/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RelationEntity;
import com.datadog.api.client.v2.model.RelationType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"from", "to", "type"})
public class RelationAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FROM = "from";
    private RelationEntity from;
    public static final String JSON_PROPERTY_TO = "to";
    private RelationEntity to;
    public static final String JSON_PROPERTY_TYPE = "type";
    private RelationType type;
    private Map<String, Object> additionalProperties;

    public RelationAttributes from(RelationEntity from) {
        this.from = from;
        this.unparsed |= from.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationEntity getFrom() {
        return this.from;
    }

    public void setFrom(RelationEntity from) {
        this.from = from;
    }

    public RelationAttributes to(RelationEntity to) {
        this.to = to;
        this.unparsed |= to.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationEntity getTo() {
        return this.to;
    }

    public void setTo(RelationEntity to) {
        this.to = to;
    }

    public RelationAttributes type(RelationType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationType getType() {
        return this.type;
    }

    public void setType(RelationType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public RelationAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationAttributes relationAttributes = (RelationAttributes)o;
        return Objects.equals(this.from, relationAttributes.from) && Objects.equals(this.to, relationAttributes.to) && Objects.equals(this.type, relationAttributes.type) && Objects.equals(this.additionalProperties, relationAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationAttributes {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

