/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AlertEventAttributesLinksItem;
import com.datadog.api.client.v2.model.AlertEventAttributesPriority;
import com.datadog.api.client.v2.model.AlertEventAttributesStatus;
import com.datadog.api.client.v2.model.EventSystemAttributes;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation_key", "custom", "evt", "links", "priority", "service", "status", "timestamp", "title"})
public class AlertEventAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION_KEY = "aggregation_key";
    private String aggregationKey;
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    private Object custom;
    public static final String JSON_PROPERTY_EVT = "evt";
    private EventSystemAttributes evt;
    public static final String JSON_PROPERTY_LINKS = "links";
    private List<AlertEventAttributesLinksItem> links = null;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private AlertEventAttributesPriority priority;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_STATUS = "status";
    private AlertEventAttributesStatus status;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    private Map<String, Object> additionalProperties;

    public AlertEventAttributes aggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggregationKey() {
        return this.aggregationKey;
    }

    public void setAggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
    }

    public AlertEventAttributes custom(Object custom) {
        this.custom = custom;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustom() {
        return this.custom;
    }

    public void setCustom(Object custom) {
        this.custom = custom;
    }

    public AlertEventAttributes evt(EventSystemAttributes evt) {
        this.evt = evt;
        this.unparsed |= evt.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="evt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventSystemAttributes getEvt() {
        return this.evt;
    }

    public void setEvt(EventSystemAttributes evt) {
        this.evt = evt;
    }

    public AlertEventAttributes links(List<AlertEventAttributesLinksItem> links) {
        this.links = links;
        for (AlertEventAttributesLinksItem item : links) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AlertEventAttributes addLinksItem(AlertEventAttributesLinksItem linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<AlertEventAttributesLinksItem>();
        }
        this.links.add(linksItem);
        this.unparsed |= linksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AlertEventAttributesLinksItem> getLinks() {
        return this.links;
    }

    public void setLinks(List<AlertEventAttributesLinksItem> links) {
        this.links = links;
    }

    public AlertEventAttributes priority(AlertEventAttributesPriority priority) {
        this.priority = priority;
        this.unparsed |= !priority.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AlertEventAttributesPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AlertEventAttributesPriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = priority;
    }

    public AlertEventAttributes service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public AlertEventAttributes status(AlertEventAttributesStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AlertEventAttributesStatus getStatus() {
        return this.status;
    }

    public void setStatus(AlertEventAttributesStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public AlertEventAttributes timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AlertEventAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnySetter
    public AlertEventAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertEventAttributes alertEventAttributes = (AlertEventAttributes)o;
        return Objects.equals(this.aggregationKey, alertEventAttributes.aggregationKey) && Objects.equals(this.custom, alertEventAttributes.custom) && Objects.equals(this.evt, alertEventAttributes.evt) && Objects.equals(this.links, alertEventAttributes.links) && Objects.equals(this.priority, alertEventAttributes.priority) && Objects.equals(this.service, alertEventAttributes.service) && Objects.equals(this.status, alertEventAttributes.status) && Objects.equals(this.timestamp, alertEventAttributes.timestamp) && Objects.equals(this.title, alertEventAttributes.title) && Objects.equals(this.additionalProperties, alertEventAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationKey, this.custom, this.evt, this.links, this.priority, this.service, this.status, this.timestamp, this.title, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlertEventAttributes {\n");
        sb.append("    aggregationKey: ").append(this.toIndentedString(this.aggregationKey)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    evt: ").append(this.toIndentedString(this.evt)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

