/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.luben.zstd;

import com.datadoghq.com.github.luben.zstd.Zstd;
import com.datadoghq.com.github.luben.zstd.ZstdDictDecompress;
import com.datadoghq.com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferDecompressingStreamNoFinalizer
implements Closeable {
    private ByteBuffer source;
    private final long stream;
    private boolean finishedFrame = false;
    private boolean closed = false;
    private boolean streamEnd = false;
    private int consumed;
    private int produced;

    protected ByteBuffer refill(ByteBuffer byteBuffer) {
        return byteBuffer;
    }

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native long freeDStream(long var0);

    private native long initDStream(long var1);

    private native long decompressStream(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    public ZstdDirectBufferDecompressingStreamNoFinalizer(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        this.source = byteBuffer;
        this.stream = ZstdDirectBufferDecompressingStreamNoFinalizer.createDStream();
        this.initDStream(this.stream);
    }

    public boolean hasRemaining() {
        return !this.streamEnd && (this.source.hasRemaining() || !this.finishedFrame);
    }

    public static int recommendedTargetBufferSize() {
        return (int)ZstdDirectBufferDecompressingStreamNoFinalizer.recommendedDOutSize();
    }

    public ZstdDirectBufferDecompressingStreamNoFinalizer setDict(byte[] byArray) throws IOException {
        long l = Zstd.loadDictDecompress(this.stream, byArray, byArray.length);
        if (Zstd.isError(l)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(l));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDirectBufferDecompressingStreamNoFinalizer setDict(ZstdDictDecompress zstdDictDecompress) throws IOException {
        zstdDictDecompress.acquireSharedLock();
        try {
            long l = Zstd.loadFastDictDecompress(this.stream, zstdDictDecompress);
            if (Zstd.isError(l)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(l));
            }
        }
        finally {
            zstdDictDecompress.releaseSharedLock();
        }
        return this;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.streamEnd) {
            return 0;
        }
        long l = this.decompressStream(this.stream, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.source, this.source.position(), this.source.remaining());
        if (Zstd.isError(l)) {
            throw new IOException(Zstd.getErrorName(l));
        }
        this.source.position(this.source.position() + this.consumed);
        byteBuffer.position(byteBuffer.position() + this.produced);
        if (!this.source.hasRemaining()) {
            this.source = this.refill(this.source);
            if (!this.source.isDirect()) {
                throw new IllegalArgumentException("Source buffer should be a direct buffer");
            }
        }
        boolean bl = this.finishedFrame = l == 0L;
        if (this.finishedFrame) {
            this.streamEnd = !this.source.hasRemaining();
        }
        return this.produced;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                ZstdDirectBufferDecompressingStreamNoFinalizer.freeDStream(this.stream);
            }
            finally {
                this.closed = true;
                this.source = null;
            }
        }
    }

    static {
        Native.load();
    }
}

