/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Spec;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"createdAt", "description", "name", "published", "spec", "tags", "updatedAt", "webhookSecret"})
public class WorkflowDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PUBLISHED = "published";
    private Boolean published;
    public static final String JSON_PROPERTY_SPEC = "spec";
    private Spec spec;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_WEBHOOK_SECRET = "webhookSecret";
    private String webhookSecret;
    private Map<String, Object> additionalProperties;

    public WorkflowDataAttributes() {
    }

    @JsonCreator
    public WorkflowDataAttributes(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="spec") Spec spec) {
        this.name = name;
        this.spec = spec;
        this.unparsed |= spec.unparsed;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public WorkflowDataAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkflowDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowDataAttributes published(Boolean published) {
        this.published = published;
        return this;
    }

    @Nullable
    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public WorkflowDataAttributes spec(Spec spec) {
        this.spec = spec;
        this.unparsed |= spec.unparsed;
        return this;
    }

    @JsonProperty(value="spec")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Spec getSpec() {
        return this.spec;
    }

    public void setSpec(Spec spec) {
        this.spec = spec;
    }

    public WorkflowDataAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public WorkflowDataAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public WorkflowDataAttributes webhookSecret(String webhookSecret) {
        this.webhookSecret = webhookSecret;
        return this;
    }

    @Nullable
    @JsonProperty(value="webhookSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebhookSecret() {
        return this.webhookSecret;
    }

    public void setWebhookSecret(String webhookSecret) {
        this.webhookSecret = webhookSecret;
    }

    @JsonAnySetter
    public WorkflowDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowDataAttributes workflowDataAttributes = (WorkflowDataAttributes)o;
        return Objects.equals(this.createdAt, workflowDataAttributes.createdAt) && Objects.equals(this.description, workflowDataAttributes.description) && Objects.equals(this.name, workflowDataAttributes.name) && Objects.equals(this.published, workflowDataAttributes.published) && Objects.equals(this.spec, workflowDataAttributes.spec) && Objects.equals(this.tags, workflowDataAttributes.tags) && Objects.equals(this.updatedAt, workflowDataAttributes.updatedAt) && Objects.equals(this.webhookSecret, workflowDataAttributes.webhookSecret) && Objects.equals(this.additionalProperties, workflowDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.description, this.name, this.published, this.spec, this.tags, this.updatedAt, this.webhookSecret, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowDataAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    webhookSecret: ").append(this.toIndentedString(this.webhookSecret)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

