/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.StateVariableProperties;
import com.datadog.api.client.v2.model.StateVariableType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "name", "properties", "type"})
public class StateVariable {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private StateVariableProperties properties;
    public static final String JSON_PROPERTY_TYPE = "type";
    private StateVariableType type = StateVariableType.STATEVARIABLE;
    private Map<String, Object> additionalProperties;

    public StateVariable() {
    }

    @JsonCreator
    public StateVariable(@JsonProperty(required=true, value="id") UUID id, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="properties") StateVariableProperties properties, @JsonProperty(required=true, value="type") StateVariableType type) {
        this.id = id;
        this.name = name;
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public StateVariable id(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public StateVariable name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StateVariable properties(StateVariableProperties properties) {
        this.properties = properties;
        this.unparsed |= properties.unparsed;
        return this;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateVariableProperties getProperties() {
        return this.properties;
    }

    public void setProperties(StateVariableProperties properties) {
        this.properties = properties;
    }

    public StateVariable type(StateVariableType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateVariableType getType() {
        return this.type;
    }

    public void setType(StateVariableType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public StateVariable putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateVariable stateVariable = (StateVariable)o;
        return Objects.equals(this.id, stateVariable.id) && Objects.equals(this.name, stateVariable.name) && Objects.equals(this.properties, stateVariable.properties) && Objects.equals(this.type, stateVariable.type) && Objects.equals(this.additionalProperties, stateVariable.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.properties, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StateVariable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

