/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IssueLanguage;
import com.datadog.api.client.v2.model.IssuePlatform;
import com.datadog.api.client.v2.model.IssueState;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"error_message", "error_type", "file_path", "first_seen", "first_seen_version", "function_name", "is_crash", "languages", "last_seen", "last_seen_version", "platform", "service", "state"})
public class IssueAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "error_message";
    private String errorMessage;
    public static final String JSON_PROPERTY_ERROR_TYPE = "error_type";
    private String errorType;
    public static final String JSON_PROPERTY_FILE_PATH = "file_path";
    private String filePath;
    public static final String JSON_PROPERTY_FIRST_SEEN = "first_seen";
    private Long firstSeen;
    public static final String JSON_PROPERTY_FIRST_SEEN_VERSION = "first_seen_version";
    private String firstSeenVersion;
    public static final String JSON_PROPERTY_FUNCTION_NAME = "function_name";
    private String functionName;
    public static final String JSON_PROPERTY_IS_CRASH = "is_crash";
    private Boolean isCrash;
    public static final String JSON_PROPERTY_LANGUAGES = "languages";
    private List<IssueLanguage> languages = null;
    public static final String JSON_PROPERTY_LAST_SEEN = "last_seen";
    private Long lastSeen;
    public static final String JSON_PROPERTY_LAST_SEEN_VERSION = "last_seen_version";
    private String lastSeenVersion;
    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private IssuePlatform platform;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_STATE = "state";
    private IssueState state;
    private Map<String, Object> additionalProperties;

    public IssueAttributes errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="error_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public IssueAttributes errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @Nullable
    @JsonProperty(value="error_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public IssueAttributes filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    @Nullable
    @JsonProperty(value="file_path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public IssueAttributes firstSeen(Long firstSeen) {
        this.firstSeen = firstSeen;
        return this;
    }

    @Nullable
    @JsonProperty(value="first_seen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFirstSeen() {
        return this.firstSeen;
    }

    public void setFirstSeen(Long firstSeen) {
        this.firstSeen = firstSeen;
    }

    public IssueAttributes firstSeenVersion(String firstSeenVersion) {
        this.firstSeenVersion = firstSeenVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="first_seen_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirstSeenVersion() {
        return this.firstSeenVersion;
    }

    public void setFirstSeenVersion(String firstSeenVersion) {
        this.firstSeenVersion = firstSeenVersion;
    }

    public IssueAttributes functionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    @Nullable
    @JsonProperty(value="function_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public IssueAttributes isCrash(Boolean isCrash) {
        this.isCrash = isCrash;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_crash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCrash() {
        return this.isCrash;
    }

    public void setIsCrash(Boolean isCrash) {
        this.isCrash = isCrash;
    }

    public IssueAttributes languages(List<IssueLanguage> languages) {
        this.languages = languages;
        return this;
    }

    public IssueAttributes addLanguagesItem(IssueLanguage languagesItem) {
        if (this.languages == null) {
            this.languages = new ArrayList<IssueLanguage>();
        }
        this.languages.add(languagesItem);
        this.unparsed |= !languagesItem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="languages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IssueLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<IssueLanguage> languages) {
        this.languages = languages;
    }

    public IssueAttributes lastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Nullable
    @JsonProperty(value="last_seen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public IssueAttributes lastSeenVersion(String lastSeenVersion) {
        this.lastSeenVersion = lastSeenVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="last_seen_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastSeenVersion() {
        return this.lastSeenVersion;
    }

    public void setLastSeenVersion(String lastSeenVersion) {
        this.lastSeenVersion = lastSeenVersion;
    }

    public IssueAttributes platform(IssuePlatform platform) {
        this.platform = platform;
        this.unparsed |= !platform.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IssuePlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(IssuePlatform platform) {
        if (!platform.isValid()) {
            this.unparsed = true;
        }
        this.platform = platform;
    }

    public IssueAttributes service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public IssueAttributes state(IssueState state) {
        this.state = state;
        this.unparsed |= !state.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IssueState getState() {
        return this.state;
    }

    public void setState(IssueState state) {
        if (!state.isValid()) {
            this.unparsed = true;
        }
        this.state = state;
    }

    @JsonAnySetter
    public IssueAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueAttributes issueAttributes = (IssueAttributes)o;
        return Objects.equals(this.errorMessage, issueAttributes.errorMessage) && Objects.equals(this.errorType, issueAttributes.errorType) && Objects.equals(this.filePath, issueAttributes.filePath) && Objects.equals(this.firstSeen, issueAttributes.firstSeen) && Objects.equals(this.firstSeenVersion, issueAttributes.firstSeenVersion) && Objects.equals(this.functionName, issueAttributes.functionName) && Objects.equals(this.isCrash, issueAttributes.isCrash) && Objects.equals(this.languages, issueAttributes.languages) && Objects.equals(this.lastSeen, issueAttributes.lastSeen) && Objects.equals(this.lastSeenVersion, issueAttributes.lastSeenVersion) && Objects.equals(this.platform, issueAttributes.platform) && Objects.equals(this.service, issueAttributes.service) && Objects.equals(this.state, issueAttributes.state) && Objects.equals(this.additionalProperties, issueAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessage, this.errorType, this.filePath, this.firstSeen, this.firstSeenVersion, this.functionName, this.isCrash, this.languages, this.lastSeen, this.lastSeenVersion, this.platform, this.service, this.state, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueAttributes {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorType: ").append(this.toIndentedString(this.errorType)).append("\n");
        sb.append("    filePath: ").append(this.toIndentedString(this.filePath)).append("\n");
        sb.append("    firstSeen: ").append(this.toIndentedString(this.firstSeen)).append("\n");
        sb.append("    firstSeenVersion: ").append(this.toIndentedString(this.firstSeenVersion)).append("\n");
        sb.append("    functionName: ").append(this.toIndentedString(this.functionName)).append("\n");
        sb.append("    isCrash: ").append(this.toIndentedString(this.isCrash)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    lastSeenVersion: ").append(this.toIndentedString(this.lastSeenVersion)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

