/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.HTTPBody;
import com.datadog.api.client.v2.model.HTTPHeaderUpdate;
import com.datadog.api.client.v2.model.HTTPTokenAuthType;
import com.datadog.api.client.v2.model.HTTPTokenUpdate;
import com.datadog.api.client.v2.model.UrlParamUpdate;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"body", "headers", "tokens", "type", "url_parameters"})
public class HTTPTokenAuthUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BODY = "body";
    private HTTPBody body;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private List<HTTPHeaderUpdate> headers = null;
    public static final String JSON_PROPERTY_TOKENS = "tokens";
    private List<HTTPTokenUpdate> tokens = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private HTTPTokenAuthType type;
    public static final String JSON_PROPERTY_URL_PARAMETERS = "url_parameters";
    private List<UrlParamUpdate> urlParameters = null;
    private Map<String, Object> additionalProperties;

    public HTTPTokenAuthUpdate() {
    }

    @JsonCreator
    public HTTPTokenAuthUpdate(@JsonProperty(required=true, value="type") HTTPTokenAuthType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public HTTPTokenAuthUpdate body(HTTPBody body) {
        this.body = body;
        this.unparsed |= body.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HTTPBody getBody() {
        return this.body;
    }

    public void setBody(HTTPBody body) {
        this.body = body;
    }

    public HTTPTokenAuthUpdate headers(List<HTTPHeaderUpdate> headers) {
        this.headers = headers;
        for (HTTPHeaderUpdate item : headers) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HTTPTokenAuthUpdate addHeadersItem(HTTPHeaderUpdate headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<HTTPHeaderUpdate>();
        }
        this.headers.add(headersItem);
        this.unparsed |= headersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HTTPHeaderUpdate> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HTTPHeaderUpdate> headers) {
        this.headers = headers;
    }

    public HTTPTokenAuthUpdate tokens(List<HTTPTokenUpdate> tokens) {
        this.tokens = tokens;
        for (HTTPTokenUpdate item : tokens) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HTTPTokenAuthUpdate addTokensItem(HTTPTokenUpdate tokensItem) {
        if (this.tokens == null) {
            this.tokens = new ArrayList<HTTPTokenUpdate>();
        }
        this.tokens.add(tokensItem);
        this.unparsed |= tokensItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="tokens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<HTTPTokenUpdate> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<HTTPTokenUpdate> tokens) {
        this.tokens = tokens;
    }

    public HTTPTokenAuthUpdate type(HTTPTokenAuthType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HTTPTokenAuthType getType() {
        return this.type;
    }

    public void setType(HTTPTokenAuthType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public HTTPTokenAuthUpdate urlParameters(List<UrlParamUpdate> urlParameters) {
        this.urlParameters = urlParameters;
        for (UrlParamUpdate item : urlParameters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public HTTPTokenAuthUpdate addUrlParametersItem(UrlParamUpdate urlParametersItem) {
        if (this.urlParameters == null) {
            this.urlParameters = new ArrayList<UrlParamUpdate>();
        }
        this.urlParameters.add(urlParametersItem);
        this.unparsed |= urlParametersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="url_parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UrlParamUpdate> getUrlParameters() {
        return this.urlParameters;
    }

    public void setUrlParameters(List<UrlParamUpdate> urlParameters) {
        this.urlParameters = urlParameters;
    }

    @JsonAnySetter
    public HTTPTokenAuthUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPTokenAuthUpdate httpTokenAuthUpdate = (HTTPTokenAuthUpdate)o;
        return Objects.equals(this.body, httpTokenAuthUpdate.body) && Objects.equals(this.headers, httpTokenAuthUpdate.headers) && Objects.equals(this.tokens, httpTokenAuthUpdate.tokens) && Objects.equals(this.type, httpTokenAuthUpdate.type) && Objects.equals(this.urlParameters, httpTokenAuthUpdate.urlParameters) && Objects.equals(this.additionalProperties, httpTokenAuthUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.headers, this.tokens, this.type, this.urlParameters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTTPTokenAuthUpdate {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    tokens: ").append(this.toIndentedString(this.tokens)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    urlParameters: ").append(this.toIndentedString(this.urlParameters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

