/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EventsCompute;
import com.datadog.api.client.v2.model.EventsDataSource;
import com.datadog.api.client.v2.model.EventsGroupBy;
import com.datadog.api.client.v2.model.EventsSearch;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "data_source", "group_by", "indexes", "name", "search"})
public class EventsTimeseriesQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private EventsCompute compute;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private EventsDataSource dataSource = EventsDataSource.LOGS;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<EventsGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SEARCH = "search";
    private EventsSearch search;
    private Map<String, Object> additionalProperties;

    public EventsTimeseriesQuery() {
    }

    @JsonCreator
    public EventsTimeseriesQuery(@JsonProperty(required=true, value="compute") EventsCompute compute, @JsonProperty(required=true, value="data_source") EventsDataSource dataSource) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
    }

    public EventsTimeseriesQuery compute(EventsCompute compute) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        return this;
    }

    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventsCompute getCompute() {
        return this.compute;
    }

    public void setCompute(EventsCompute compute) {
        this.compute = compute;
    }

    public EventsTimeseriesQuery dataSource(EventsDataSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventsDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(EventsDataSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public EventsTimeseriesQuery groupBy(List<EventsGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (EventsGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EventsTimeseriesQuery addGroupByItem(EventsGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<EventsGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventsGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<EventsGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public EventsTimeseriesQuery indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public EventsTimeseriesQuery addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public EventsTimeseriesQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventsTimeseriesQuery search(EventsSearch search) {
        this.search = search;
        this.unparsed |= search.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="search")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsSearch getSearch() {
        return this.search;
    }

    public void setSearch(EventsSearch search) {
        this.search = search;
    }

    @JsonAnySetter
    public EventsTimeseriesQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsTimeseriesQuery eventsTimeseriesQuery = (EventsTimeseriesQuery)o;
        return Objects.equals(this.compute, eventsTimeseriesQuery.compute) && Objects.equals(this.dataSource, eventsTimeseriesQuery.dataSource) && Objects.equals(this.groupBy, eventsTimeseriesQuery.groupBy) && Objects.equals(this.indexes, eventsTimeseriesQuery.indexes) && Objects.equals(this.name, eventsTimeseriesQuery.name) && Objects.equals(this.search, eventsTimeseriesQuery.search) && Objects.equals(this.additionalProperties, eventsTimeseriesQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.dataSource, this.groupBy, this.indexes, this.name, this.search, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsTimeseriesQuery {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    search: ").append(this.toIndentedString(this.search)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

