/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EventCategory;
import com.datadog.api.client.v2.model.EventPayloadAttributes;
import com.datadog.api.client.v2.model.EventPayloadIntegrationId;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation_key", "attributes", "category", "integration_id", "message", "tags", "timestamp", "title"})
public class EventPayload {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION_KEY = "aggregation_key";
    private String aggregationKey;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private EventPayloadAttributes attributes;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private EventCategory category;
    public static final String JSON_PROPERTY_INTEGRATION_ID = "integration_id";
    private EventPayloadIntegrationId integrationId;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private String timestamp;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public EventPayload() {
    }

    @JsonCreator
    public EventPayload(@JsonProperty(required=true, value="attributes") EventPayloadAttributes attributes, @JsonProperty(required=true, value="category") EventCategory category, @JsonProperty(required=true, value="title") String title) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.category = category;
        this.unparsed |= !category.isValid();
        this.title = title;
    }

    public EventPayload aggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAggregationKey() {
        return this.aggregationKey;
    }

    public void setAggregationKey(String aggregationKey) {
        this.aggregationKey = aggregationKey;
    }

    public EventPayload attributes(EventPayloadAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventPayloadAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(EventPayloadAttributes attributes) {
        this.attributes = attributes;
    }

    public EventPayload category(EventCategory category) {
        this.category = category;
        this.unparsed |= !category.isValid();
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventCategory getCategory() {
        return this.category;
    }

    public void setCategory(EventCategory category) {
        if (!category.isValid()) {
            this.unparsed = true;
        }
        this.category = category;
    }

    public EventPayload integrationId(EventPayloadIntegrationId integrationId) {
        this.integrationId = integrationId;
        this.unparsed |= !integrationId.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="integration_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventPayloadIntegrationId getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(EventPayloadIntegrationId integrationId) {
        if (!integrationId.isValid()) {
            this.unparsed = true;
        }
        this.integrationId = integrationId;
    }

    public EventPayload message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public EventPayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EventPayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public EventPayload timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public EventPayload title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventPayload eventPayload = (EventPayload)o;
        return Objects.equals(this.aggregationKey, eventPayload.aggregationKey) && Objects.equals(this.attributes, eventPayload.attributes) && Objects.equals(this.category, eventPayload.category) && Objects.equals(this.integrationId, eventPayload.integrationId) && Objects.equals(this.message, eventPayload.message) && Objects.equals(this.tags, eventPayload.tags) && Objects.equals(this.timestamp, eventPayload.timestamp) && Objects.equals(this.title, eventPayload.title);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationKey, this.attributes, this.category, this.integrationId, this.message, this.tags, this.timestamp, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventPayload {\n");
        sb.append("    aggregationKey: ").append(this.toIndentedString(this.aggregationKey)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

