/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.DowntimeMonitorIdentifier;
import com.datadog.api.client.v2.model.DowntimeNotifyEndStateActions;
import com.datadog.api.client.v2.model.DowntimeNotifyEndStateTypes;
import com.datadog.api.client.v2.model.DowntimeScheduleCreateRequest;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import com.datadoghq.org.openapitools.jackson.nullable.JsonNullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"display_timezone", "message", "monitor_identifier", "mute_first_recovery_notification", "notify_end_states", "notify_end_types", "schedule", "scope"})
public class DowntimeCreateRequestAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DISPLAY_TIMEZONE = "display_timezone";
    private JsonNullable<String> displayTimezone = JsonNullable.of("UTC");
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private JsonNullable<String> message = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MONITOR_IDENTIFIER = "monitor_identifier";
    private DowntimeMonitorIdentifier monitorIdentifier;
    public static final String JSON_PROPERTY_MUTE_FIRST_RECOVERY_NOTIFICATION = "mute_first_recovery_notification";
    private Boolean muteFirstRecoveryNotification;
    public static final String JSON_PROPERTY_NOTIFY_END_STATES = "notify_end_states";
    private List<DowntimeNotifyEndStateTypes> notifyEndStates = null;
    public static final String JSON_PROPERTY_NOTIFY_END_TYPES = "notify_end_types";
    private List<DowntimeNotifyEndStateActions> notifyEndTypes = null;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private DowntimeScheduleCreateRequest schedule;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    private Map<String, Object> additionalProperties;

    public DowntimeCreateRequestAttributes() {
    }

    @JsonCreator
    public DowntimeCreateRequestAttributes(@JsonProperty(required=true, value="monitor_identifier") DowntimeMonitorIdentifier monitorIdentifier, @JsonProperty(required=true, value="scope") String scope) {
        this.monitorIdentifier = monitorIdentifier;
        this.unparsed |= monitorIdentifier.unparsed;
        this.scope = scope;
    }

    public DowntimeCreateRequestAttributes displayTimezone(String displayTimezone) {
        this.displayTimezone = JsonNullable.of(displayTimezone);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDisplayTimezone() {
        return this.displayTimezone.orElse(null);
    }

    @JsonProperty(value="display_timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDisplayTimezone_JsonNullable() {
        return this.displayTimezone;
    }

    @JsonProperty(value="display_timezone")
    public void setDisplayTimezone_JsonNullable(JsonNullable<String> displayTimezone) {
        this.displayTimezone = displayTimezone;
    }

    public void setDisplayTimezone(String displayTimezone) {
        this.displayTimezone = JsonNullable.of(displayTimezone);
    }

    public DowntimeCreateRequestAttributes message(String message) {
        this.message = JsonNullable.of(message);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getMessage() {
        return this.message.orElse(null);
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getMessage_JsonNullable() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage_JsonNullable(JsonNullable<String> message) {
        this.message = message;
    }

    public void setMessage(String message) {
        this.message = JsonNullable.of(message);
    }

    public DowntimeCreateRequestAttributes monitorIdentifier(DowntimeMonitorIdentifier monitorIdentifier) {
        this.monitorIdentifier = monitorIdentifier;
        this.unparsed |= monitorIdentifier.unparsed;
        return this;
    }

    @JsonProperty(value="monitor_identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DowntimeMonitorIdentifier getMonitorIdentifier() {
        return this.monitorIdentifier;
    }

    public void setMonitorIdentifier(DowntimeMonitorIdentifier monitorIdentifier) {
        this.monitorIdentifier = monitorIdentifier;
    }

    public DowntimeCreateRequestAttributes muteFirstRecoveryNotification(Boolean muteFirstRecoveryNotification) {
        this.muteFirstRecoveryNotification = muteFirstRecoveryNotification;
        return this;
    }

    @Nullable
    @JsonProperty(value="mute_first_recovery_notification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMuteFirstRecoveryNotification() {
        return this.muteFirstRecoveryNotification;
    }

    public void setMuteFirstRecoveryNotification(Boolean muteFirstRecoveryNotification) {
        this.muteFirstRecoveryNotification = muteFirstRecoveryNotification;
    }

    public DowntimeCreateRequestAttributes notifyEndStates(List<DowntimeNotifyEndStateTypes> notifyEndStates) {
        this.notifyEndStates = notifyEndStates;
        return this;
    }

    public DowntimeCreateRequestAttributes addNotifyEndStatesItem(DowntimeNotifyEndStateTypes notifyEndStatesItem) {
        if (this.notifyEndStates == null) {
            this.notifyEndStates = new ArrayList<DowntimeNotifyEndStateTypes>();
        }
        this.notifyEndStates.add(notifyEndStatesItem);
        this.unparsed |= !notifyEndStatesItem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="notify_end_states")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DowntimeNotifyEndStateTypes> getNotifyEndStates() {
        return this.notifyEndStates;
    }

    public void setNotifyEndStates(List<DowntimeNotifyEndStateTypes> notifyEndStates) {
        this.notifyEndStates = notifyEndStates;
    }

    public DowntimeCreateRequestAttributes notifyEndTypes(List<DowntimeNotifyEndStateActions> notifyEndTypes) {
        this.notifyEndTypes = notifyEndTypes;
        return this;
    }

    public DowntimeCreateRequestAttributes addNotifyEndTypesItem(DowntimeNotifyEndStateActions notifyEndTypesItem) {
        if (this.notifyEndTypes == null) {
            this.notifyEndTypes = new ArrayList<DowntimeNotifyEndStateActions>();
        }
        this.notifyEndTypes.add(notifyEndTypesItem);
        this.unparsed |= !notifyEndTypesItem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="notify_end_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DowntimeNotifyEndStateActions> getNotifyEndTypes() {
        return this.notifyEndTypes;
    }

    public void setNotifyEndTypes(List<DowntimeNotifyEndStateActions> notifyEndTypes) {
        this.notifyEndTypes = notifyEndTypes;
    }

    public DowntimeCreateRequestAttributes schedule(DowntimeScheduleCreateRequest schedule) {
        this.schedule = schedule;
        this.unparsed |= schedule.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowntimeScheduleCreateRequest getSchedule() {
        return this.schedule;
    }

    public void setSchedule(DowntimeScheduleCreateRequest schedule) {
        this.schedule = schedule;
    }

    public DowntimeCreateRequestAttributes scope(String scope) {
        this.scope = scope;
        return this;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @JsonAnySetter
    public DowntimeCreateRequestAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DowntimeCreateRequestAttributes downtimeCreateRequestAttributes = (DowntimeCreateRequestAttributes)o;
        return Objects.equals(this.displayTimezone, downtimeCreateRequestAttributes.displayTimezone) && Objects.equals(this.message, downtimeCreateRequestAttributes.message) && Objects.equals(this.monitorIdentifier, downtimeCreateRequestAttributes.monitorIdentifier) && Objects.equals(this.muteFirstRecoveryNotification, downtimeCreateRequestAttributes.muteFirstRecoveryNotification) && Objects.equals(this.notifyEndStates, downtimeCreateRequestAttributes.notifyEndStates) && Objects.equals(this.notifyEndTypes, downtimeCreateRequestAttributes.notifyEndTypes) && Objects.equals(this.schedule, downtimeCreateRequestAttributes.schedule) && Objects.equals(this.scope, downtimeCreateRequestAttributes.scope) && Objects.equals(this.additionalProperties, downtimeCreateRequestAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.displayTimezone, this.message, this.monitorIdentifier, this.muteFirstRecoveryNotification, this.notifyEndStates, this.notifyEndTypes, this.schedule, this.scope, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DowntimeCreateRequestAttributes {\n");
        sb.append("    displayTimezone: ").append(this.toIndentedString(this.displayTimezone)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    monitorIdentifier: ").append(this.toIndentedString(this.monitorIdentifier)).append("\n");
        sb.append("    muteFirstRecoveryNotification: ").append(this.toIndentedString(this.muteFirstRecoveryNotification)).append("\n");
        sb.append("    notifyEndStates: ").append(this.toIndentedString(this.notifyEndStates)).append("\n");
        sb.append("    notifyEndTypes: ").append(this.toIndentedString(this.notifyEndTypes)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

