/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.CloudflareAPIToken;
import com.datadog.api.client.v2.model.CloudflareGlobalAPIToken;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.core.JsonGenerator;
import com.datadoghq.com.fasterxml.jackson.core.JsonParser;
import com.datadoghq.com.fasterxml.jackson.core.JsonProcessingException;
import com.datadoghq.com.fasterxml.jackson.core.JsonToken;
import com.datadoghq.com.fasterxml.jackson.core.type.TypeReference;
import com.datadoghq.com.fasterxml.jackson.databind.DeserializationContext;
import com.datadoghq.com.fasterxml.jackson.databind.JsonMappingException;
import com.datadoghq.com.fasterxml.jackson.databind.JsonNode;
import com.datadoghq.com.fasterxml.jackson.databind.MapperFeature;
import com.datadoghq.com.fasterxml.jackson.databind.ObjectMapper;
import com.datadoghq.com.fasterxml.jackson.databind.SerializerProvider;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.datadoghq.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.datadoghq.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=CloudflareCredentialsDeserializer.class)
@JsonSerialize(using=CloudflareCredentialsSerializer.class)
public class CloudflareCredentials
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(CloudflareCredentials.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public CloudflareCredentials() {
        super("oneOf", Boolean.FALSE);
    }

    public CloudflareCredentials(CloudflareAPIToken o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public CloudflareCredentials(CloudflareGlobalAPIToken o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(CloudflareAPIToken.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(CloudflareGlobalAPIToken.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be CloudflareAPIToken, CloudflareGlobalAPIToken");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public CloudflareAPIToken getCloudflareAPIToken() throws ClassCastException {
        return (CloudflareAPIToken)super.getActualInstance();
    }

    public CloudflareGlobalAPIToken getCloudflareGlobalAPIToken() throws ClassCastException {
        return (CloudflareGlobalAPIToken)super.getActualInstance();
    }

    static {
        schemas.put("CloudflareAPIToken", new GenericType<CloudflareAPIToken>(){});
        schemas.put("CloudflareGlobalAPIToken", new GenericType<CloudflareGlobalAPIToken>(){});
        JSON.registerDescendants(CloudflareCredentials.class, Collections.unmodifiableMap(schemas));
    }

    public static class CloudflareCredentialsDeserializer
    extends StdDeserializer<CloudflareCredentials> {
        public CloudflareCredentialsDeserializer() {
            this(CloudflareCredentials.class);
        }

        public CloudflareCredentialsDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public CloudflareCredentials deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((CloudflareAPIToken.class.equals(Integer.class) || CloudflareAPIToken.class.equals(Long.class) || CloudflareAPIToken.class.equals(Float.class) || CloudflareAPIToken.class.equals(Double.class) || CloudflareAPIToken.class.equals(Boolean.class) || CloudflareAPIToken.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (CloudflareAPIToken.class.equals(Integer.class) || CloudflareAPIToken.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!CloudflareAPIToken.class.equals(Float.class) && !CloudflareAPIToken.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= CloudflareAPIToken.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= CloudflareAPIToken.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(CloudflareAPIToken.class);
                    if (!((CloudflareAPIToken)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'CloudflareAPIToken'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'CloudflareAPIToken'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((CloudflareGlobalAPIToken.class.equals(Integer.class) || CloudflareGlobalAPIToken.class.equals(Long.class) || CloudflareGlobalAPIToken.class.equals(Float.class) || CloudflareGlobalAPIToken.class.equals(Double.class) || CloudflareGlobalAPIToken.class.equals(Boolean.class) || CloudflareGlobalAPIToken.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (CloudflareGlobalAPIToken.class.equals(Integer.class) || CloudflareGlobalAPIToken.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!CloudflareGlobalAPIToken.class.equals(Float.class) && !CloudflareGlobalAPIToken.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= CloudflareGlobalAPIToken.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= CloudflareGlobalAPIToken.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(CloudflareGlobalAPIToken.class);
                    if (!((CloudflareGlobalAPIToken)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'CloudflareGlobalAPIToken'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'CloudflareGlobalAPIToken'", e);
            }
            CloudflareCredentials ret = new CloudflareCredentials();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map<String, Object> res = new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        @Override
        public CloudflareCredentials getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "CloudflareCredentials cannot be null");
        }
    }

    public static class CloudflareCredentialsSerializer
    extends StdSerializer<CloudflareCredentials> {
        public CloudflareCredentialsSerializer(Class<CloudflareCredentials> t) {
            super(t);
        }

        public CloudflareCredentialsSerializer() {
            this((Class<CloudflareCredentials>)null);
        }

        @Override
        public void serialize(CloudflareCredentials value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

