/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.PermissionsResponse;
import com.datadog.api.client.v2.model.RelationshipToPermission;
import com.datadog.api.client.v2.model.RelationshipToUser;
import com.datadog.api.client.v2.model.RoleCloneRequest;
import com.datadog.api.client.v2.model.RoleCreateRequest;
import com.datadog.api.client.v2.model.RoleCreateResponse;
import com.datadog.api.client.v2.model.RoleResponse;
import com.datadog.api.client.v2.model.RoleUpdateRequest;
import com.datadog.api.client.v2.model.RoleUpdateResponse;
import com.datadog.api.client.v2.model.RolesResponse;
import com.datadog.api.client.v2.model.RolesSort;
import com.datadog.api.client.v2.model.UsersResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class RolesApi {
    private ApiClient apiClient;

    public RolesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public RolesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PermissionsResponse addPermissionToRole(String roleId, RelationshipToPermission body) throws ApiException {
        return this.addPermissionToRoleWithHttpInfo(roleId, body).getData();
    }

    public CompletableFuture<PermissionsResponse> addPermissionToRoleAsync(String roleId, RelationshipToPermission body) {
        return this.addPermissionToRoleWithHttpInfoAsync(roleId, body).thenApply(response -> (PermissionsResponse)response.getData());
    }

    public ApiResponse<PermissionsResponse> addPermissionToRoleWithHttpInfo(String roleId, RelationshipToPermission body) throws ApiException {
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addPermissionToRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addPermissionToRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.addPermissionToRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<PermissionsResponse>> addPermissionToRoleWithHttpInfoAsync(String roleId, RelationshipToPermission body) {
        Invocation.Builder builder;
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling addPermissionToRole"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling addPermissionToRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.addPermissionToRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public UsersResponse addUserToRole(String roleId, RelationshipToUser body) throws ApiException {
        return this.addUserToRoleWithHttpInfo(roleId, body).getData();
    }

    public CompletableFuture<UsersResponse> addUserToRoleAsync(String roleId, RelationshipToUser body) {
        return this.addUserToRoleWithHttpInfoAsync(roleId, body).thenApply(response -> (UsersResponse)response.getData());
    }

    public ApiResponse<UsersResponse> addUserToRoleWithHttpInfo(String roleId, RelationshipToUser body) throws ApiException {
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addUserToRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addUserToRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.addUserToRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsersResponse>> addUserToRoleWithHttpInfoAsync(String roleId, RelationshipToUser body) {
        Invocation.Builder builder;
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling addUserToRole"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling addUserToRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.addUserToRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public RoleResponse cloneRole(String roleId, RoleCloneRequest body) throws ApiException {
        return this.cloneRoleWithHttpInfo(roleId, body).getData();
    }

    public CompletableFuture<RoleResponse> cloneRoleAsync(String roleId, RoleCloneRequest body) {
        return this.cloneRoleWithHttpInfoAsync(roleId, body).thenApply(response -> (RoleResponse)response.getData());
    }

    public ApiResponse<RoleResponse> cloneRoleWithHttpInfo(String roleId, RoleCloneRequest body) throws ApiException {
        RoleCloneRequest localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling cloneRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling cloneRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/clone".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.cloneRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleResponse>(){});
    }

    public CompletableFuture<ApiResponse<RoleResponse>> cloneRoleWithHttpInfoAsync(String roleId, RoleCloneRequest body) {
        Invocation.Builder builder;
        RoleCloneRequest localVarPostBody = body;
        if (roleId == null) {
            CompletableFuture<ApiResponse<RoleResponse>> result = new CompletableFuture<ApiResponse<RoleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling cloneRole"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RoleResponse>> result = new CompletableFuture<ApiResponse<RoleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling cloneRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}/clone".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.cloneRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RoleResponse>> result = new CompletableFuture<ApiResponse<RoleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleResponse>(){});
    }

    public RoleCreateResponse createRole(RoleCreateRequest body) throws ApiException {
        return this.createRoleWithHttpInfo(body).getData();
    }

    public CompletableFuture<RoleCreateResponse> createRoleAsync(RoleCreateRequest body) {
        return this.createRoleWithHttpInfoAsync(body).thenApply(response -> (RoleCreateResponse)response.getData());
    }

    public ApiResponse<RoleCreateResponse> createRoleWithHttpInfo(RoleCreateRequest body) throws ApiException {
        RoleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRole");
        }
        String localVarPath = "/api/v2/roles";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.createRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<RoleCreateResponse>> createRoleWithHttpInfoAsync(RoleCreateRequest body) {
        Invocation.Builder builder;
        RoleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<RoleCreateResponse>> result = new CompletableFuture<ApiResponse<RoleCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.createRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RoleCreateResponse>> result = new CompletableFuture<ApiResponse<RoleCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleCreateResponse>(){});
    }

    public void deleteRole(String roleId) throws ApiException {
        this.deleteRoleWithHttpInfo(roleId);
    }

    public CompletableFuture<Void> deleteRoleAsync(String roleId) {
        return this.deleteRoleWithHttpInfoAsync(roleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.deleteRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRoleWithHttpInfoAsync(String roleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (roleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.deleteRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RoleResponse getRole(String roleId) throws ApiException {
        return this.getRoleWithHttpInfo(roleId).getData();
    }

    public CompletableFuture<RoleResponse> getRoleAsync(String roleId) {
        return this.getRoleWithHttpInfoAsync(roleId).thenApply(response -> (RoleResponse)response.getData());
    }

    public ApiResponse<RoleResponse> getRoleWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.getRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleResponse>(){});
    }

    public CompletableFuture<ApiResponse<RoleResponse>> getRoleWithHttpInfoAsync(String roleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (roleId == null) {
            CompletableFuture<ApiResponse<RoleResponse>> result = new CompletableFuture<ApiResponse<RoleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling getRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.getRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RoleResponse>> result = new CompletableFuture<ApiResponse<RoleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleResponse>(){});
    }

    public PermissionsResponse listPermissions() throws ApiException {
        return this.listPermissionsWithHttpInfo().getData();
    }

    public CompletableFuture<PermissionsResponse> listPermissionsAsync() {
        return this.listPermissionsWithHttpInfoAsync().thenApply(response -> (PermissionsResponse)response.getData());
    }

    public ApiResponse<PermissionsResponse> listPermissionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/permissions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.listPermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<PermissionsResponse>> listPermissionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/permissions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.listPermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public PermissionsResponse listRolePermissions(String roleId) throws ApiException {
        return this.listRolePermissionsWithHttpInfo(roleId).getData();
    }

    public CompletableFuture<PermissionsResponse> listRolePermissionsAsync(String roleId) {
        return this.listRolePermissionsWithHttpInfoAsync(roleId).thenApply(response -> (PermissionsResponse)response.getData());
    }

    public ApiResponse<PermissionsResponse> listRolePermissionsWithHttpInfo(String roleId) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listRolePermissions");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.listRolePermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<PermissionsResponse>> listRolePermissionsWithHttpInfoAsync(String roleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (roleId == null) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling listRolePermissions"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.listRolePermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public RolesResponse listRoles() throws ApiException {
        return this.listRolesWithHttpInfo(new ListRolesOptionalParameters()).getData();
    }

    public CompletableFuture<RolesResponse> listRolesAsync() {
        return this.listRolesWithHttpInfoAsync(new ListRolesOptionalParameters()).thenApply(response -> (RolesResponse)response.getData());
    }

    public RolesResponse listRoles(ListRolesOptionalParameters parameters) throws ApiException {
        return this.listRolesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<RolesResponse> listRolesAsync(ListRolesOptionalParameters parameters) {
        return this.listRolesWithHttpInfoAsync(parameters).thenApply(response -> (RolesResponse)response.getData());
    }

    public ApiResponse<RolesResponse> listRolesWithHttpInfo(ListRolesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        RolesSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterId = parameters.filterId;
        String localVarPath = "/api/v2/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[id]", filterId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.listRoles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RolesResponse>(){});
    }

    public CompletableFuture<ApiResponse<RolesResponse>> listRolesWithHttpInfoAsync(ListRolesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        RolesSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterId = parameters.filterId;
        String localVarPath = "/api/v2/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[id]", filterId));
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.listRoles", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RolesResponse>> result = new CompletableFuture<ApiResponse<RolesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RolesResponse>(){});
    }

    public UsersResponse listRoleUsers(String roleId) throws ApiException {
        return this.listRoleUsersWithHttpInfo(roleId, new ListRoleUsersOptionalParameters()).getData();
    }

    public CompletableFuture<UsersResponse> listRoleUsersAsync(String roleId) {
        return this.listRoleUsersWithHttpInfoAsync(roleId, new ListRoleUsersOptionalParameters()).thenApply(response -> (UsersResponse)response.getData());
    }

    public UsersResponse listRoleUsers(String roleId, ListRoleUsersOptionalParameters parameters) throws ApiException {
        return this.listRoleUsersWithHttpInfo(roleId, parameters).getData();
    }

    public CompletableFuture<UsersResponse> listRoleUsersAsync(String roleId, ListRoleUsersOptionalParameters parameters) {
        return this.listRoleUsersWithHttpInfoAsync(roleId, parameters).thenApply(response -> (UsersResponse)response.getData());
    }

    public ApiResponse<UsersResponse> listRoleUsersWithHttpInfo(String roleId, ListRoleUsersOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listRoleUsers");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.listRoleUsers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsersResponse>> listRoleUsersWithHttpInfoAsync(String roleId, ListRoleUsersOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (roleId == null) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling listRoleUsers"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.listRoleUsers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public PermissionsResponse removePermissionFromRole(String roleId, RelationshipToPermission body) throws ApiException {
        return this.removePermissionFromRoleWithHttpInfo(roleId, body).getData();
    }

    public CompletableFuture<PermissionsResponse> removePermissionFromRoleAsync(String roleId, RelationshipToPermission body) {
        return this.removePermissionFromRoleWithHttpInfoAsync(roleId, body).thenApply(response -> (PermissionsResponse)response.getData());
    }

    public ApiResponse<PermissionsResponse> removePermissionFromRoleWithHttpInfo(String roleId, RelationshipToPermission body) throws ApiException {
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling removePermissionFromRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removePermissionFromRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.removePermissionFromRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<PermissionsResponse>> removePermissionFromRoleWithHttpInfoAsync(String roleId, RelationshipToPermission body) {
        Invocation.Builder builder;
        RelationshipToPermission localVarPostBody = body;
        if (roleId == null) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling removePermissionFromRole"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling removePermissionFromRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}/permissions".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.removePermissionFromRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public UsersResponse removeUserFromRole(String roleId, RelationshipToUser body) throws ApiException {
        return this.removeUserFromRoleWithHttpInfo(roleId, body).getData();
    }

    public CompletableFuture<UsersResponse> removeUserFromRoleAsync(String roleId, RelationshipToUser body) {
        return this.removeUserFromRoleWithHttpInfoAsync(roleId, body).thenApply(response -> (UsersResponse)response.getData());
    }

    public ApiResponse<UsersResponse> removeUserFromRoleWithHttpInfo(String roleId, RelationshipToUser body) throws ApiException {
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling removeUserFromRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeUserFromRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.removeUserFromRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsersResponse>> removeUserFromRoleWithHttpInfoAsync(String roleId, RelationshipToUser body) {
        Invocation.Builder builder;
        RelationshipToUser localVarPostBody = body;
        if (roleId == null) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling removeUserFromRole"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling removeUserFromRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.removeUserFromRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public RoleUpdateResponse updateRole(String roleId, RoleUpdateRequest body) throws ApiException {
        return this.updateRoleWithHttpInfo(roleId, body).getData();
    }

    public CompletableFuture<RoleUpdateResponse> updateRoleAsync(String roleId, RoleUpdateRequest body) {
        return this.updateRoleWithHttpInfoAsync(roleId, body).thenApply(response -> (RoleUpdateResponse)response.getData());
    }

    public ApiResponse<RoleUpdateResponse> updateRoleWithHttpInfo(String roleId, RoleUpdateRequest body) throws ApiException {
        RoleUpdateRequest localVarPostBody = body;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling updateRole");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRole");
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RolesApi.updateRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<RoleUpdateResponse>> updateRoleWithHttpInfoAsync(String roleId, RoleUpdateRequest body) {
        Invocation.Builder builder;
        RoleUpdateRequest localVarPostBody = body;
        if (roleId == null) {
            CompletableFuture<ApiResponse<RoleUpdateResponse>> result = new CompletableFuture<ApiResponse<RoleUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'roleId' when calling updateRole"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RoleUpdateResponse>> result = new CompletableFuture<ApiResponse<RoleUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateRole"));
            return result;
        }
        String localVarPath = "/api/v2/roles/{role_id}".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RolesApi.updateRole", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RoleUpdateResponse>> result = new CompletableFuture<ApiResponse<RoleUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RoleUpdateResponse>(){});
    }

    public static class ListRoleUsersOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private String sort;
        private String filter;

        public ListRoleUsersOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListRoleUsersOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListRoleUsersOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListRoleUsersOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class ListRolesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private RolesSort sort;
        private String filter;
        private String filterId;

        public ListRolesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListRolesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListRolesOptionalParameters sort(RolesSort sort) {
            this.sort = sort;
            return this;
        }

        public ListRolesOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListRolesOptionalParameters filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }
    }
}

