/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CustomDestinationCreateRequest;
import com.datadog.api.client.v2.model.CustomDestinationResponse;
import com.datadog.api.client.v2.model.CustomDestinationUpdateRequest;
import com.datadog.api.client.v2.model.CustomDestinationsResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class LogsCustomDestinationsApi {
    private ApiClient apiClient;

    public LogsCustomDestinationsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public LogsCustomDestinationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CustomDestinationResponse createLogsCustomDestination(CustomDestinationCreateRequest body) throws ApiException {
        return this.createLogsCustomDestinationWithHttpInfo(body).getData();
    }

    public CompletableFuture<CustomDestinationResponse> createLogsCustomDestinationAsync(CustomDestinationCreateRequest body) {
        return this.createLogsCustomDestinationWithHttpInfoAsync(body).thenApply(response -> (CustomDestinationResponse)response.getData());
    }

    public ApiResponse<CustomDestinationResponse> createLogsCustomDestinationWithHttpInfo(CustomDestinationCreateRequest body) throws ApiException {
        CustomDestinationCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsCustomDestination");
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.createLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomDestinationResponse>> createLogsCustomDestinationWithHttpInfoAsync(CustomDestinationCreateRequest body) {
        Invocation.Builder builder;
        CustomDestinationCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createLogsCustomDestination"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.createLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationResponse>(){});
    }

    public void deleteLogsCustomDestination(String customDestinationId) throws ApiException {
        this.deleteLogsCustomDestinationWithHttpInfo(customDestinationId);
    }

    public CompletableFuture<Void> deleteLogsCustomDestinationAsync(String customDestinationId) {
        return this.deleteLogsCustomDestinationWithHttpInfoAsync(customDestinationId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteLogsCustomDestinationWithHttpInfo(String customDestinationId) throws ApiException {
        Object localVarPostBody = null;
        if (customDestinationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customDestinationId' when calling deleteLogsCustomDestination");
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations/{custom_destination_id}".replaceAll("\\{custom_destination_id\\}", this.apiClient.escapeString(customDestinationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.deleteLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteLogsCustomDestinationWithHttpInfoAsync(String customDestinationId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (customDestinationId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customDestinationId' when calling deleteLogsCustomDestination"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations/{custom_destination_id}".replaceAll("\\{custom_destination_id\\}", this.apiClient.escapeString(customDestinationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.deleteLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CustomDestinationResponse getLogsCustomDestination(String customDestinationId) throws ApiException {
        return this.getLogsCustomDestinationWithHttpInfo(customDestinationId).getData();
    }

    public CompletableFuture<CustomDestinationResponse> getLogsCustomDestinationAsync(String customDestinationId) {
        return this.getLogsCustomDestinationWithHttpInfoAsync(customDestinationId).thenApply(response -> (CustomDestinationResponse)response.getData());
    }

    public ApiResponse<CustomDestinationResponse> getLogsCustomDestinationWithHttpInfo(String customDestinationId) throws ApiException {
        Object localVarPostBody = null;
        if (customDestinationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customDestinationId' when calling getLogsCustomDestination");
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations/{custom_destination_id}".replaceAll("\\{custom_destination_id\\}", this.apiClient.escapeString(customDestinationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.getLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomDestinationResponse>> getLogsCustomDestinationWithHttpInfoAsync(String customDestinationId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (customDestinationId == null) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customDestinationId' when calling getLogsCustomDestination"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations/{custom_destination_id}".replaceAll("\\{custom_destination_id\\}", this.apiClient.escapeString(customDestinationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.getLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationResponse>(){});
    }

    public CustomDestinationsResponse listLogsCustomDestinations() throws ApiException {
        return this.listLogsCustomDestinationsWithHttpInfo().getData();
    }

    public CompletableFuture<CustomDestinationsResponse> listLogsCustomDestinationsAsync() {
        return this.listLogsCustomDestinationsWithHttpInfoAsync().thenApply(response -> (CustomDestinationsResponse)response.getData());
    }

    public ApiResponse<CustomDestinationsResponse> listLogsCustomDestinationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/custom-destinations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.listLogsCustomDestinations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationsResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomDestinationsResponse>> listLogsCustomDestinationsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/custom-destinations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.listLogsCustomDestinations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomDestinationsResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationsResponse>(){});
    }

    public CustomDestinationResponse updateLogsCustomDestination(String customDestinationId, CustomDestinationUpdateRequest body) throws ApiException {
        return this.updateLogsCustomDestinationWithHttpInfo(customDestinationId, body).getData();
    }

    public CompletableFuture<CustomDestinationResponse> updateLogsCustomDestinationAsync(String customDestinationId, CustomDestinationUpdateRequest body) {
        return this.updateLogsCustomDestinationWithHttpInfoAsync(customDestinationId, body).thenApply(response -> (CustomDestinationResponse)response.getData());
    }

    public ApiResponse<CustomDestinationResponse> updateLogsCustomDestinationWithHttpInfo(String customDestinationId, CustomDestinationUpdateRequest body) throws ApiException {
        CustomDestinationUpdateRequest localVarPostBody = body;
        if (customDestinationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customDestinationId' when calling updateLogsCustomDestination");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsCustomDestination");
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations/{custom_destination_id}".replaceAll("\\{custom_destination_id\\}", this.apiClient.escapeString(customDestinationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.updateLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationResponse>(){});
    }

    public CompletableFuture<ApiResponse<CustomDestinationResponse>> updateLogsCustomDestinationWithHttpInfoAsync(String customDestinationId, CustomDestinationUpdateRequest body) {
        Invocation.Builder builder;
        CustomDestinationUpdateRequest localVarPostBody = body;
        if (customDestinationId == null) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customDestinationId' when calling updateLogsCustomDestination"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateLogsCustomDestination"));
            return result;
        }
        String localVarPath = "/api/v2/logs/config/custom-destinations/{custom_destination_id}".replaceAll("\\{custom_destination_id\\}", this.apiClient.escapeString(customDestinationId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsCustomDestinationsApi.updateLogsCustomDestination", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CustomDestinationResponse>> result = new CompletableFuture<ApiResponse<CustomDestinationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CustomDestinationResponse>(){});
    }
}

