/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.FastlyAccountCreateRequest;
import com.datadog.api.client.v2.model.FastlyAccountResponse;
import com.datadog.api.client.v2.model.FastlyAccountUpdateRequest;
import com.datadog.api.client.v2.model.FastlyAccountsResponse;
import com.datadog.api.client.v2.model.FastlyServiceRequest;
import com.datadog.api.client.v2.model.FastlyServiceResponse;
import com.datadog.api.client.v2.model.FastlyServicesResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class FastlyIntegrationApi {
    private ApiClient apiClient;

    public FastlyIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public FastlyIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FastlyAccountResponse createFastlyAccount(FastlyAccountCreateRequest body) throws ApiException {
        return this.createFastlyAccountWithHttpInfo(body).getData();
    }

    public CompletableFuture<FastlyAccountResponse> createFastlyAccountAsync(FastlyAccountCreateRequest body) {
        return this.createFastlyAccountWithHttpInfoAsync(body).thenApply(response -> (FastlyAccountResponse)response.getData());
    }

    public ApiResponse<FastlyAccountResponse> createFastlyAccountWithHttpInfo(FastlyAccountCreateRequest body) throws ApiException {
        FastlyAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFastlyAccount");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.createFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyAccountResponse>> createFastlyAccountWithHttpInfoAsync(FastlyAccountCreateRequest body) {
        Invocation.Builder builder;
        FastlyAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createFastlyAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.createFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountResponse>(){});
    }

    public FastlyServiceResponse createFastlyService(String accountId, FastlyServiceRequest body) throws ApiException {
        return this.createFastlyServiceWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<FastlyServiceResponse> createFastlyServiceAsync(String accountId, FastlyServiceRequest body) {
        return this.createFastlyServiceWithHttpInfoAsync(accountId, body).thenApply(response -> (FastlyServiceResponse)response.getData());
    }

    public ApiResponse<FastlyServiceResponse> createFastlyServiceWithHttpInfo(String accountId, FastlyServiceRequest body) throws ApiException {
        FastlyServiceRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createFastlyService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createFastlyService");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.createFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyServiceResponse>> createFastlyServiceWithHttpInfoAsync(String accountId, FastlyServiceRequest body) {
        Invocation.Builder builder;
        FastlyServiceRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling createFastlyService"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createFastlyService"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.createFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServiceResponse>(){});
    }

    public void deleteFastlyAccount(String accountId) throws ApiException {
        this.deleteFastlyAccountWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteFastlyAccountAsync(String accountId) {
        return this.deleteFastlyAccountWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteFastlyAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteFastlyAccount");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.deleteFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteFastlyAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteFastlyAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.deleteFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteFastlyService(String accountId, String serviceId) throws ApiException {
        this.deleteFastlyServiceWithHttpInfo(accountId, serviceId);
    }

    public CompletableFuture<Void> deleteFastlyServiceAsync(String accountId, String serviceId) {
        return this.deleteFastlyServiceWithHttpInfoAsync(accountId, serviceId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteFastlyServiceWithHttpInfo(String accountId, String serviceId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteFastlyService");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteFastlyService");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services/{service_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.deleteFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteFastlyServiceWithHttpInfoAsync(String accountId, String serviceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteFastlyService"));
            return result;
        }
        if (serviceId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteFastlyService"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services/{service_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.deleteFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public FastlyAccountResponse getFastlyAccount(String accountId) throws ApiException {
        return this.getFastlyAccountWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<FastlyAccountResponse> getFastlyAccountAsync(String accountId) {
        return this.getFastlyAccountWithHttpInfoAsync(accountId).thenApply(response -> (FastlyAccountResponse)response.getData());
    }

    public ApiResponse<FastlyAccountResponse> getFastlyAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFastlyAccount");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.getFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyAccountResponse>> getFastlyAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getFastlyAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.getFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountResponse>(){});
    }

    public FastlyServiceResponse getFastlyService(String accountId, String serviceId) throws ApiException {
        return this.getFastlyServiceWithHttpInfo(accountId, serviceId).getData();
    }

    public CompletableFuture<FastlyServiceResponse> getFastlyServiceAsync(String accountId, String serviceId) {
        return this.getFastlyServiceWithHttpInfoAsync(accountId, serviceId).thenApply(response -> (FastlyServiceResponse)response.getData());
    }

    public ApiResponse<FastlyServiceResponse> getFastlyServiceWithHttpInfo(String accountId, String serviceId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getFastlyService");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getFastlyService");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services/{service_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.getFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyServiceResponse>> getFastlyServiceWithHttpInfoAsync(String accountId, String serviceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getFastlyService"));
            return result;
        }
        if (serviceId == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceId' when calling getFastlyService"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services/{service_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.getFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServiceResponse>(){});
    }

    public FastlyAccountsResponse listFastlyAccounts() throws ApiException {
        return this.listFastlyAccountsWithHttpInfo().getData();
    }

    public CompletableFuture<FastlyAccountsResponse> listFastlyAccountsAsync() {
        return this.listFastlyAccountsWithHttpInfoAsync().thenApply(response -> (FastlyAccountsResponse)response.getData());
    }

    public ApiResponse<FastlyAccountsResponse> listFastlyAccountsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/fastly/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.listFastlyAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyAccountsResponse>> listFastlyAccountsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/fastly/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.listFastlyAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyAccountsResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountsResponse>(){});
    }

    public FastlyServicesResponse listFastlyServices(String accountId) throws ApiException {
        return this.listFastlyServicesWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<FastlyServicesResponse> listFastlyServicesAsync(String accountId) {
        return this.listFastlyServicesWithHttpInfoAsync(accountId).thenApply(response -> (FastlyServicesResponse)response.getData());
    }

    public ApiResponse<FastlyServicesResponse> listFastlyServicesWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listFastlyServices");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.listFastlyServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServicesResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyServicesResponse>> listFastlyServicesWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<FastlyServicesResponse>> result = new CompletableFuture<ApiResponse<FastlyServicesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling listFastlyServices"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.listFastlyServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyServicesResponse>> result = new CompletableFuture<ApiResponse<FastlyServicesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServicesResponse>(){});
    }

    public FastlyAccountResponse updateFastlyAccount(String accountId, FastlyAccountUpdateRequest body) throws ApiException {
        return this.updateFastlyAccountWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<FastlyAccountResponse> updateFastlyAccountAsync(String accountId, FastlyAccountUpdateRequest body) {
        return this.updateFastlyAccountWithHttpInfoAsync(accountId, body).thenApply(response -> (FastlyAccountResponse)response.getData());
    }

    public ApiResponse<FastlyAccountResponse> updateFastlyAccountWithHttpInfo(String accountId, FastlyAccountUpdateRequest body) throws ApiException {
        FastlyAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateFastlyAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateFastlyAccount");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.updateFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyAccountResponse>> updateFastlyAccountWithHttpInfoAsync(String accountId, FastlyAccountUpdateRequest body) {
        Invocation.Builder builder;
        FastlyAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateFastlyAccount"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateFastlyAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.updateFastlyAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyAccountResponse>> result = new CompletableFuture<ApiResponse<FastlyAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyAccountResponse>(){});
    }

    public FastlyServiceResponse updateFastlyService(String accountId, String serviceId, FastlyServiceRequest body) throws ApiException {
        return this.updateFastlyServiceWithHttpInfo(accountId, serviceId, body).getData();
    }

    public CompletableFuture<FastlyServiceResponse> updateFastlyServiceAsync(String accountId, String serviceId, FastlyServiceRequest body) {
        return this.updateFastlyServiceWithHttpInfoAsync(accountId, serviceId, body).thenApply(response -> (FastlyServiceResponse)response.getData());
    }

    public ApiResponse<FastlyServiceResponse> updateFastlyServiceWithHttpInfo(String accountId, String serviceId, FastlyServiceRequest body) throws ApiException {
        FastlyServiceRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateFastlyService");
        }
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling updateFastlyService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateFastlyService");
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services/{service_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.updateFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<FastlyServiceResponse>> updateFastlyServiceWithHttpInfoAsync(String accountId, String serviceId, FastlyServiceRequest body) {
        Invocation.Builder builder;
        FastlyServiceRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateFastlyService"));
            return result;
        }
        if (serviceId == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'serviceId' when calling updateFastlyService"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateFastlyService"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/fastly/accounts/{account_id}/services/{service_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.FastlyIntegrationApi.updateFastlyService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FastlyServiceResponse>> result = new CompletableFuture<ApiResponse<FastlyServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FastlyServiceResponse>(){});
    }
}

