/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.User;
import com.datadog.api.client.v1.model.UserDisableResponse;
import com.datadog.api.client.v1.model.UserListResponse;
import com.datadog.api.client.v1.model.UserResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserResponse createUser(User body) throws ApiException {
        return this.createUserWithHttpInfo(body).getData();
    }

    public CompletableFuture<UserResponse> createUserAsync(User body) {
        return this.createUserWithHttpInfoAsync(body).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> createUserWithHttpInfo(User body) throws ApiException {
        User localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createUser");
        }
        String localVarPath = "/api/v1/user";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.UsersApi.createUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> createUserWithHttpInfoAsync(User body) {
        Invocation.Builder builder;
        User localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createUser"));
            return result;
        }
        String localVarPath = "/api/v1/user";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.UsersApi.createUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public UserDisableResponse disableUser(String userHandle) throws ApiException {
        return this.disableUserWithHttpInfo(userHandle).getData();
    }

    public CompletableFuture<UserDisableResponse> disableUserAsync(String userHandle) {
        return this.disableUserWithHttpInfoAsync(userHandle).thenApply(response -> (UserDisableResponse)response.getData());
    }

    public ApiResponse<UserDisableResponse> disableUserWithHttpInfo(String userHandle) throws ApiException {
        Object localVarPostBody = null;
        if (userHandle == null) {
            throw new ApiException(400, "Missing the required parameter 'userHandle' when calling disableUser");
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.UsersApi.disableUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserDisableResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserDisableResponse>> disableUserWithHttpInfoAsync(String userHandle) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userHandle == null) {
            CompletableFuture<ApiResponse<UserDisableResponse>> result = new CompletableFuture<ApiResponse<UserDisableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userHandle' when calling disableUser"));
            return result;
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.UsersApi.disableUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserDisableResponse>> result = new CompletableFuture<ApiResponse<UserDisableResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserDisableResponse>(){});
    }

    public UserResponse getUser(String userHandle) throws ApiException {
        return this.getUserWithHttpInfo(userHandle).getData();
    }

    public CompletableFuture<UserResponse> getUserAsync(String userHandle) {
        return this.getUserWithHttpInfoAsync(userHandle).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> getUserWithHttpInfo(String userHandle) throws ApiException {
        Object localVarPostBody = null;
        if (userHandle == null) {
            throw new ApiException(400, "Missing the required parameter 'userHandle' when calling getUser");
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.UsersApi.getUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> getUserWithHttpInfoAsync(String userHandle) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userHandle == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userHandle' when calling getUser"));
            return result;
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.UsersApi.getUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public UserListResponse listUsers() throws ApiException {
        return this.listUsersWithHttpInfo().getData();
    }

    public CompletableFuture<UserListResponse> listUsersAsync() {
        return this.listUsersWithHttpInfoAsync().thenApply(response -> (UserListResponse)response.getData());
    }

    public ApiResponse<UserListResponse> listUsersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/user";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.UsersApi.listUsers", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserListResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserListResponse>> listUsersWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/user";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.UsersApi.listUsers", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserListResponse>> result = new CompletableFuture<ApiResponse<UserListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserListResponse>(){});
    }

    public UserResponse updateUser(String userHandle, User body) throws ApiException {
        return this.updateUserWithHttpInfo(userHandle, body).getData();
    }

    public CompletableFuture<UserResponse> updateUserAsync(String userHandle, User body) {
        return this.updateUserWithHttpInfoAsync(userHandle, body).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> updateUserWithHttpInfo(String userHandle, User body) throws ApiException {
        User localVarPostBody = body;
        if (userHandle == null) {
            throw new ApiException(400, "Missing the required parameter 'userHandle' when calling updateUser");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateUser");
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.UsersApi.updateUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> updateUserWithHttpInfoAsync(String userHandle, User body) {
        Invocation.Builder builder;
        User localVarPostBody = body;
        if (userHandle == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userHandle' when calling updateUser"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateUser"));
            return result;
        }
        String localVarPath = "/api/v1/user/{user_handle}".replaceAll("\\{user_handle\\}", this.apiClient.escapeString(userHandle.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.UsersApi.updateUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }
}

