/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.CheckCanDeleteSLOResponse;
import com.datadog.api.client.v1.model.SLOBulkDeleteResponse;
import com.datadog.api.client.v1.model.SLOCorrectionListResponse;
import com.datadog.api.client.v1.model.SLODeleteResponse;
import com.datadog.api.client.v1.model.SLOHistoryResponse;
import com.datadog.api.client.v1.model.SLOListResponse;
import com.datadog.api.client.v1.model.SLOResponse;
import com.datadog.api.client.v1.model.SLOTimeframe;
import com.datadog.api.client.v1.model.SearchSLOResponse;
import com.datadog.api.client.v1.model.ServiceLevelObjective;
import com.datadog.api.client.v1.model.ServiceLevelObjectiveRequest;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ServiceLevelObjectivesApi {
    private ApiClient apiClient;

    public ServiceLevelObjectivesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ServiceLevelObjectivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CheckCanDeleteSLOResponse checkCanDeleteSLO(String ids) throws ApiException {
        return this.checkCanDeleteSLOWithHttpInfo(ids).getData();
    }

    public CompletableFuture<CheckCanDeleteSLOResponse> checkCanDeleteSLOAsync(String ids) {
        return this.checkCanDeleteSLOWithHttpInfoAsync(ids).thenApply(response -> (CheckCanDeleteSLOResponse)response.getData());
    }

    public ApiResponse<CheckCanDeleteSLOResponse> checkCanDeleteSLOWithHttpInfo(String ids) throws ApiException {
        Object localVarPostBody = null;
        if (ids == null) {
            throw new ApiException(400, "Missing the required parameter 'ids' when calling checkCanDeleteSLO");
        }
        String localVarPath = "/api/v1/slo/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.checkCanDeleteSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CheckCanDeleteSLOResponse>(){});
    }

    public CompletableFuture<ApiResponse<CheckCanDeleteSLOResponse>> checkCanDeleteSLOWithHttpInfoAsync(String ids) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ids == null) {
            CompletableFuture<ApiResponse<CheckCanDeleteSLOResponse>> result = new CompletableFuture<ApiResponse<CheckCanDeleteSLOResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ids' when calling checkCanDeleteSLO"));
            return result;
        }
        String localVarPath = "/api/v1/slo/can_delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.checkCanDeleteSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CheckCanDeleteSLOResponse>> result = new CompletableFuture<ApiResponse<CheckCanDeleteSLOResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CheckCanDeleteSLOResponse>(){});
    }

    public SLOListResponse createSLO(ServiceLevelObjectiveRequest body) throws ApiException {
        return this.createSLOWithHttpInfo(body).getData();
    }

    public CompletableFuture<SLOListResponse> createSLOAsync(ServiceLevelObjectiveRequest body) {
        return this.createSLOWithHttpInfoAsync(body).thenApply(response -> (SLOListResponse)response.getData());
    }

    public ApiResponse<SLOListResponse> createSLOWithHttpInfo(ServiceLevelObjectiveRequest body) throws ApiException {
        ServiceLevelObjectiveRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSLO");
        }
        String localVarPath = "/api/v1/slo";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.createSLO", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOListResponse>> createSLOWithHttpInfoAsync(ServiceLevelObjectiveRequest body) {
        Invocation.Builder builder;
        ServiceLevelObjectiveRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SLOListResponse>> result = new CompletableFuture<ApiResponse<SLOListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSLO"));
            return result;
        }
        String localVarPath = "/api/v1/slo";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.createSLO", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOListResponse>> result = new CompletableFuture<ApiResponse<SLOListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOListResponse>(){});
    }

    public SLODeleteResponse deleteSLO(String sloId) throws ApiException {
        return this.deleteSLOWithHttpInfo(sloId, new DeleteSLOOptionalParameters()).getData();
    }

    public CompletableFuture<SLODeleteResponse> deleteSLOAsync(String sloId) {
        return this.deleteSLOWithHttpInfoAsync(sloId, new DeleteSLOOptionalParameters()).thenApply(response -> (SLODeleteResponse)response.getData());
    }

    public SLODeleteResponse deleteSLO(String sloId, DeleteSLOOptionalParameters parameters) throws ApiException {
        return this.deleteSLOWithHttpInfo(sloId, parameters).getData();
    }

    public CompletableFuture<SLODeleteResponse> deleteSLOAsync(String sloId, DeleteSLOOptionalParameters parameters) {
        return this.deleteSLOWithHttpInfoAsync(sloId, parameters).thenApply(response -> (SLODeleteResponse)response.getData());
    }

    public ApiResponse<SLODeleteResponse> deleteSLOWithHttpInfo(String sloId, DeleteSLOOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling deleteSLO");
        }
        String force = parameters.force;
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.deleteSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLODeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLODeleteResponse>> deleteSLOWithHttpInfoAsync(String sloId, DeleteSLOOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (sloId == null) {
            CompletableFuture<ApiResponse<SLODeleteResponse>> result = new CompletableFuture<ApiResponse<SLODeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloId' when calling deleteSLO"));
            return result;
        }
        String force = parameters.force;
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "force", force));
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.deleteSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLODeleteResponse>> result = new CompletableFuture<ApiResponse<SLODeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLODeleteResponse>(){});
    }

    public SLOBulkDeleteResponse deleteSLOTimeframeInBulk(Map<String, List<SLOTimeframe>> body) throws ApiException {
        return this.deleteSLOTimeframeInBulkWithHttpInfo(body).getData();
    }

    public CompletableFuture<SLOBulkDeleteResponse> deleteSLOTimeframeInBulkAsync(Map<String, List<SLOTimeframe>> body) {
        return this.deleteSLOTimeframeInBulkWithHttpInfoAsync(body).thenApply(response -> (SLOBulkDeleteResponse)response.getData());
    }

    public ApiResponse<SLOBulkDeleteResponse> deleteSLOTimeframeInBulkWithHttpInfo(Map<String, List<SLOTimeframe>> body) throws ApiException {
        Map<String, List<SLOTimeframe>> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteSLOTimeframeInBulk");
        }
        String localVarPath = "/api/v1/slo/bulk_delete";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.deleteSLOTimeframeInBulk", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOBulkDeleteResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOBulkDeleteResponse>> deleteSLOTimeframeInBulkWithHttpInfoAsync(Map<String, List<SLOTimeframe>> body) {
        Invocation.Builder builder;
        Map<String, List<SLOTimeframe>> localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SLOBulkDeleteResponse>> result = new CompletableFuture<ApiResponse<SLOBulkDeleteResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteSLOTimeframeInBulk"));
            return result;
        }
        String localVarPath = "/api/v1/slo/bulk_delete";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.deleteSLOTimeframeInBulk", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOBulkDeleteResponse>> result = new CompletableFuture<ApiResponse<SLOBulkDeleteResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOBulkDeleteResponse>(){});
    }

    public SLOResponse getSLO(String sloId) throws ApiException {
        return this.getSLOWithHttpInfo(sloId, new GetSLOOptionalParameters()).getData();
    }

    public CompletableFuture<SLOResponse> getSLOAsync(String sloId) {
        return this.getSLOWithHttpInfoAsync(sloId, new GetSLOOptionalParameters()).thenApply(response -> (SLOResponse)response.getData());
    }

    public SLOResponse getSLO(String sloId, GetSLOOptionalParameters parameters) throws ApiException {
        return this.getSLOWithHttpInfo(sloId, parameters).getData();
    }

    public CompletableFuture<SLOResponse> getSLOAsync(String sloId, GetSLOOptionalParameters parameters) {
        return this.getSLOWithHttpInfoAsync(sloId, parameters).thenApply(response -> (SLOResponse)response.getData());
    }

    public ApiResponse<SLOResponse> getSLOWithHttpInfo(String sloId, GetSLOOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLO");
        }
        Boolean withConfiguredAlertIds = parameters.withConfiguredAlertIds;
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_configured_alert_ids", withConfiguredAlertIds));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.getSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOResponse>> getSLOWithHttpInfoAsync(String sloId, GetSLOOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (sloId == null) {
            CompletableFuture<ApiResponse<SLOResponse>> result = new CompletableFuture<ApiResponse<SLOResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloId' when calling getSLO"));
            return result;
        }
        Boolean withConfiguredAlertIds = parameters.withConfiguredAlertIds;
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with_configured_alert_ids", withConfiguredAlertIds));
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.getSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOResponse>> result = new CompletableFuture<ApiResponse<SLOResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOResponse>(){});
    }

    public SLOCorrectionListResponse getSLOCorrections(String sloId) throws ApiException {
        return this.getSLOCorrectionsWithHttpInfo(sloId).getData();
    }

    public CompletableFuture<SLOCorrectionListResponse> getSLOCorrectionsAsync(String sloId) {
        return this.getSLOCorrectionsWithHttpInfoAsync(sloId).thenApply(response -> (SLOCorrectionListResponse)response.getData());
    }

    public ApiResponse<SLOCorrectionListResponse> getSLOCorrectionsWithHttpInfo(String sloId) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLOCorrections");
        }
        String localVarPath = "/api/v1/slo/{slo_id}/corrections".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.getSLOCorrections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOCorrectionListResponse>> getSLOCorrectionsWithHttpInfoAsync(String sloId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (sloId == null) {
            CompletableFuture<ApiResponse<SLOCorrectionListResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloId' when calling getSLOCorrections"));
            return result;
        }
        String localVarPath = "/api/v1/slo/{slo_id}/corrections".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.getSLOCorrections", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOCorrectionListResponse>> result = new CompletableFuture<ApiResponse<SLOCorrectionListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOCorrectionListResponse>(){});
    }

    public SLOHistoryResponse getSLOHistory(String sloId, Long fromTs, Long toTs) throws ApiException {
        return this.getSLOHistoryWithHttpInfo(sloId, fromTs, toTs, new GetSLOHistoryOptionalParameters()).getData();
    }

    public CompletableFuture<SLOHistoryResponse> getSLOHistoryAsync(String sloId, Long fromTs, Long toTs) {
        return this.getSLOHistoryWithHttpInfoAsync(sloId, fromTs, toTs, new GetSLOHistoryOptionalParameters()).thenApply(response -> (SLOHistoryResponse)response.getData());
    }

    public SLOHistoryResponse getSLOHistory(String sloId, Long fromTs, Long toTs, GetSLOHistoryOptionalParameters parameters) throws ApiException {
        return this.getSLOHistoryWithHttpInfo(sloId, fromTs, toTs, parameters).getData();
    }

    public CompletableFuture<SLOHistoryResponse> getSLOHistoryAsync(String sloId, Long fromTs, Long toTs, GetSLOHistoryOptionalParameters parameters) {
        return this.getSLOHistoryWithHttpInfoAsync(sloId, fromTs, toTs, parameters).thenApply(response -> (SLOHistoryResponse)response.getData());
    }

    public ApiResponse<SLOHistoryResponse> getSLOHistoryWithHttpInfo(String sloId, Long fromTs, Long toTs, GetSLOHistoryOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling getSLOHistory");
        }
        if (fromTs == null) {
            throw new ApiException(400, "Missing the required parameter 'fromTs' when calling getSLOHistory");
        }
        if (toTs == null) {
            throw new ApiException(400, "Missing the required parameter 'toTs' when calling getSLOHistory");
        }
        Double target = parameters.target;
        Boolean applyCorrection = parameters.applyCorrection;
        String localVarPath = "/api/v1/slo/{slo_id}/history".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "target", target));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apply_correction", applyCorrection));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.getSLOHistory", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOHistoryResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOHistoryResponse>> getSLOHistoryWithHttpInfoAsync(String sloId, Long fromTs, Long toTs, GetSLOHistoryOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (sloId == null) {
            CompletableFuture<ApiResponse<SLOHistoryResponse>> result = new CompletableFuture<ApiResponse<SLOHistoryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloId' when calling getSLOHistory"));
            return result;
        }
        if (fromTs == null) {
            CompletableFuture<ApiResponse<SLOHistoryResponse>> result = new CompletableFuture<ApiResponse<SLOHistoryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'fromTs' when calling getSLOHistory"));
            return result;
        }
        if (toTs == null) {
            CompletableFuture<ApiResponse<SLOHistoryResponse>> result = new CompletableFuture<ApiResponse<SLOHistoryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'toTs' when calling getSLOHistory"));
            return result;
        }
        Double target = parameters.target;
        Boolean applyCorrection = parameters.applyCorrection;
        String localVarPath = "/api/v1/slo/{slo_id}/history".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "target", target));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apply_correction", applyCorrection));
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.getSLOHistory", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOHistoryResponse>> result = new CompletableFuture<ApiResponse<SLOHistoryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOHistoryResponse>(){});
    }

    public SLOListResponse listSLOs() throws ApiException {
        return this.listSLOsWithHttpInfo(new ListSLOsOptionalParameters()).getData();
    }

    public CompletableFuture<SLOListResponse> listSLOsAsync() {
        return this.listSLOsWithHttpInfoAsync(new ListSLOsOptionalParameters()).thenApply(response -> (SLOListResponse)response.getData());
    }

    public SLOListResponse listSLOs(ListSLOsOptionalParameters parameters) throws ApiException {
        return this.listSLOsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SLOListResponse> listSLOsAsync(ListSLOsOptionalParameters parameters) {
        return this.listSLOsWithHttpInfoAsync(parameters).thenApply(response -> (SLOListResponse)response.getData());
    }

    public PaginationIterable<ServiceLevelObjective> listSLOsWithPagination() {
        ListSLOsOptionalParameters parameters = new ListSLOsOptionalParameters();
        return this.listSLOsWithPagination(parameters);
    }

    public PaginationIterable<ServiceLevelObjective> listSLOsWithPagination(ListSLOsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "offset";
        Boolean valueSetterParamOptional = true;
        if (parameters.limit == null) {
            limit = 1000L;
            parameters.limit(limit);
        } else {
            limit = parameters.limit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<ServiceLevelObjective> iterator = new PaginationIterable<ServiceLevelObjective>(this, "listSLOs", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SLOListResponse> listSLOsWithHttpInfo(ListSLOsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String ids = parameters.ids;
        String query = parameters.query;
        String tagsQuery = parameters.tagsQuery;
        String metricsQuery = parameters.metricsQuery;
        Long limit = parameters.limit;
        Long offset = parameters.offset;
        String localVarPath = "/api/v1/slo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags_query", tagsQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metrics_query", metricsQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.listSLOs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOListResponse>> listSLOsWithHttpInfoAsync(ListSLOsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String ids = parameters.ids;
        String query = parameters.query;
        String tagsQuery = parameters.tagsQuery;
        String metricsQuery = parameters.metricsQuery;
        Long limit = parameters.limit;
        Long offset = parameters.offset;
        String localVarPath = "/api/v1/slo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ids", ids));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags_query", tagsQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metrics_query", metricsQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.listSLOs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOListResponse>> result = new CompletableFuture<ApiResponse<SLOListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOListResponse>(){});
    }

    public SearchSLOResponse searchSLO() throws ApiException {
        return this.searchSLOWithHttpInfo(new SearchSLOOptionalParameters()).getData();
    }

    public CompletableFuture<SearchSLOResponse> searchSLOAsync() {
        return this.searchSLOWithHttpInfoAsync(new SearchSLOOptionalParameters()).thenApply(response -> (SearchSLOResponse)response.getData());
    }

    public SearchSLOResponse searchSLO(SearchSLOOptionalParameters parameters) throws ApiException {
        return this.searchSLOWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SearchSLOResponse> searchSLOAsync(SearchSLOOptionalParameters parameters) {
        return this.searchSLOWithHttpInfoAsync(parameters).thenApply(response -> (SearchSLOResponse)response.getData());
    }

    public ApiResponse<SearchSLOResponse> searchSLOWithHttpInfo(SearchSLOOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String query = parameters.query;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        Boolean includeFacets = parameters.includeFacets;
        String localVarPath = "/api/v1/slo/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_facets", includeFacets));
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.searchSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SearchSLOResponse>(){});
    }

    public CompletableFuture<ApiResponse<SearchSLOResponse>> searchSLOWithHttpInfoAsync(SearchSLOOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String query = parameters.query;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        Boolean includeFacets = parameters.includeFacets;
        String localVarPath = "/api/v1/slo/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_facets", includeFacets));
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.searchSLO", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SearchSLOResponse>> result = new CompletableFuture<ApiResponse<SearchSLOResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SearchSLOResponse>(){});
    }

    public SLOListResponse updateSLO(String sloId, ServiceLevelObjective body) throws ApiException {
        return this.updateSLOWithHttpInfo(sloId, body).getData();
    }

    public CompletableFuture<SLOListResponse> updateSLOAsync(String sloId, ServiceLevelObjective body) {
        return this.updateSLOWithHttpInfoAsync(sloId, body).thenApply(response -> (SLOListResponse)response.getData());
    }

    public ApiResponse<SLOListResponse> updateSLOWithHttpInfo(String sloId, ServiceLevelObjective body) throws ApiException {
        ServiceLevelObjective localVarPostBody = body;
        if (sloId == null) {
            throw new ApiException(400, "Missing the required parameter 'sloId' when calling updateSLO");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSLO");
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.updateSLO", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SLOListResponse>> updateSLOWithHttpInfoAsync(String sloId, ServiceLevelObjective body) {
        Invocation.Builder builder;
        ServiceLevelObjective localVarPostBody = body;
        if (sloId == null) {
            CompletableFuture<ApiResponse<SLOListResponse>> result = new CompletableFuture<ApiResponse<SLOListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'sloId' when calling updateSLO"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SLOListResponse>> result = new CompletableFuture<ApiResponse<SLOListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSLO"));
            return result;
        }
        String localVarPath = "/api/v1/slo/{slo_id}".replaceAll("\\{slo_id\\}", this.apiClient.escapeString(sloId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.ServiceLevelObjectivesApi.updateSLO", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SLOListResponse>> result = new CompletableFuture<ApiResponse<SLOListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SLOListResponse>(){});
    }

    public static class SearchSLOOptionalParameters {
        private String query;
        private Long pageSize;
        private Long pageNumber;
        private Boolean includeFacets;

        public SearchSLOOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public SearchSLOOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchSLOOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public SearchSLOOptionalParameters includeFacets(Boolean includeFacets) {
            this.includeFacets = includeFacets;
            return this;
        }
    }

    public static class ListSLOsOptionalParameters {
        private String ids;
        private String query;
        private String tagsQuery;
        private String metricsQuery;
        private Long limit;
        private Long offset;

        public ListSLOsOptionalParameters ids(String ids) {
            this.ids = ids;
            return this;
        }

        public ListSLOsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListSLOsOptionalParameters tagsQuery(String tagsQuery) {
            this.tagsQuery = tagsQuery;
            return this;
        }

        public ListSLOsOptionalParameters metricsQuery(String metricsQuery) {
            this.metricsQuery = metricsQuery;
            return this;
        }

        public ListSLOsOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public ListSLOsOptionalParameters offset(Long offset) {
            this.offset = offset;
            return this;
        }
    }

    public static class GetSLOHistoryOptionalParameters {
        private Double target;
        private Boolean applyCorrection;

        public GetSLOHistoryOptionalParameters target(Double target) {
            this.target = target;
            return this;
        }

        public GetSLOHistoryOptionalParameters applyCorrection(Boolean applyCorrection) {
            this.applyCorrection = applyCorrection;
            return this;
        }
    }

    public static class GetSLOOptionalParameters {
        private Boolean withConfiguredAlertIds;

        public GetSLOOptionalParameters withConfiguredAlertIds(Boolean withConfiguredAlertIds) {
            this.withConfiguredAlertIds = withConfiguredAlertIds;
            return this;
        }
    }

    public static class DeleteSLOOptionalParameters {
        private String force;

        public DeleteSLOOptionalParameters force(String force) {
            this.force = force;
            return this;
        }
    }
}

