/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.AzureAccount;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AzureIntegrationApi {
    private ApiClient apiClient;

    public AzureIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AzureIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Object createAzureIntegration(AzureAccount body) throws ApiException {
        return this.createAzureIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> createAzureIntegrationAsync(AzureAccount body) {
        return this.createAzureIntegrationWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> createAzureIntegrationWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAzureIntegration");
        }
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.createAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> createAzureIntegrationWithHttpInfoAsync(AzureAccount body) {
        Invocation.Builder builder;
        AzureAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAzureIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.createAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public Object deleteAzureIntegration(AzureAccount body) throws ApiException {
        return this.deleteAzureIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> deleteAzureIntegrationAsync(AzureAccount body) {
        return this.deleteAzureIntegrationWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> deleteAzureIntegrationWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAzureIntegration");
        }
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.deleteAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> deleteAzureIntegrationWithHttpInfoAsync(AzureAccount body) {
        Invocation.Builder builder;
        AzureAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteAzureIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.deleteAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public List<AzureAccount> listAzureIntegration() throws ApiException {
        return this.listAzureIntegrationWithHttpInfo().getData();
    }

    public CompletableFuture<List<AzureAccount>> listAzureIntegrationAsync() {
        return this.listAzureIntegrationWithHttpInfoAsync().thenApply(response -> (List)response.getData());
    }

    public ApiResponse<List<AzureAccount>> listAzureIntegrationWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.listAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<AzureAccount>>(){});
    }

    public CompletableFuture<ApiResponse<List<AzureAccount>>> listAzureIntegrationWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.listAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<List<AzureAccount>>> result = new CompletableFuture<ApiResponse<List<AzureAccount>>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<List<AzureAccount>>(){});
    }

    public Object updateAzureHostFilters(AzureAccount body) throws ApiException {
        return this.updateAzureHostFiltersWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> updateAzureHostFiltersAsync(AzureAccount body) {
        return this.updateAzureHostFiltersWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> updateAzureHostFiltersWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAzureHostFilters");
        }
        String localVarPath = "/api/v1/integration/azure/host_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.updateAzureHostFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> updateAzureHostFiltersWithHttpInfoAsync(AzureAccount body) {
        Invocation.Builder builder;
        AzureAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAzureHostFilters"));
            return result;
        }
        String localVarPath = "/api/v1/integration/azure/host_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.updateAzureHostFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public Object updateAzureIntegration(AzureAccount body) throws ApiException {
        return this.updateAzureIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<Object> updateAzureIntegrationAsync(AzureAccount body) {
        return this.updateAzureIntegrationWithHttpInfoAsync(body).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> updateAzureIntegrationWithHttpInfo(AzureAccount body) throws ApiException {
        AzureAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAzureIntegration");
        }
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.updateAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> updateAzureIntegrationWithHttpInfoAsync(AzureAccount body) {
        Invocation.Builder builder;
        AzureAccount localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAzureIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/azure";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.AzureIntegrationApi.updateAzureIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }
}

