/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EPSS;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"epss", "exploit_available", "exploit_sources", "exploitation_probability", "poc_exploit_available"})
public class VulnerabilityRisks {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EPSS = "epss";
    private EPSS epss;
    public static final String JSON_PROPERTY_EXPLOIT_AVAILABLE = "exploit_available";
    private Boolean exploitAvailable;
    public static final String JSON_PROPERTY_EXPLOIT_SOURCES = "exploit_sources";
    private List<String> exploitSources = new ArrayList<String>();
    public static final String JSON_PROPERTY_EXPLOITATION_PROBABILITY = "exploitation_probability";
    private Boolean exploitationProbability;
    public static final String JSON_PROPERTY_POC_EXPLOIT_AVAILABLE = "poc_exploit_available";
    private Boolean pocExploitAvailable;
    private Map<String, Object> additionalProperties;

    public VulnerabilityRisks() {
    }

    @JsonCreator
    public VulnerabilityRisks(@JsonProperty(required=true, value="exploit_available") Boolean exploitAvailable, @JsonProperty(required=true, value="exploit_sources") List<String> exploitSources, @JsonProperty(required=true, value="exploitation_probability") Boolean exploitationProbability, @JsonProperty(required=true, value="poc_exploit_available") Boolean pocExploitAvailable) {
        this.exploitAvailable = exploitAvailable;
        this.exploitSources = exploitSources;
        this.exploitationProbability = exploitationProbability;
        this.pocExploitAvailable = pocExploitAvailable;
    }

    public VulnerabilityRisks epss(EPSS epss) {
        this.epss = epss;
        this.unparsed |= epss.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="epss")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EPSS getEpss() {
        return this.epss;
    }

    public void setEpss(EPSS epss) {
        this.epss = epss;
    }

    public VulnerabilityRisks exploitAvailable(Boolean exploitAvailable) {
        this.exploitAvailable = exploitAvailable;
        return this;
    }

    @JsonProperty(value="exploit_available")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getExploitAvailable() {
        return this.exploitAvailable;
    }

    public void setExploitAvailable(Boolean exploitAvailable) {
        this.exploitAvailable = exploitAvailable;
    }

    public VulnerabilityRisks exploitSources(List<String> exploitSources) {
        this.exploitSources = exploitSources;
        return this;
    }

    public VulnerabilityRisks addExploitSourcesItem(String exploitSourcesItem) {
        this.exploitSources.add(exploitSourcesItem);
        return this;
    }

    @JsonProperty(value="exploit_sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getExploitSources() {
        return this.exploitSources;
    }

    public void setExploitSources(List<String> exploitSources) {
        this.exploitSources = exploitSources;
    }

    public VulnerabilityRisks exploitationProbability(Boolean exploitationProbability) {
        this.exploitationProbability = exploitationProbability;
        return this;
    }

    @JsonProperty(value="exploitation_probability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getExploitationProbability() {
        return this.exploitationProbability;
    }

    public void setExploitationProbability(Boolean exploitationProbability) {
        this.exploitationProbability = exploitationProbability;
    }

    public VulnerabilityRisks pocExploitAvailable(Boolean pocExploitAvailable) {
        this.pocExploitAvailable = pocExploitAvailable;
        return this;
    }

    @JsonProperty(value="poc_exploit_available")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPocExploitAvailable() {
        return this.pocExploitAvailable;
    }

    public void setPocExploitAvailable(Boolean pocExploitAvailable) {
        this.pocExploitAvailable = pocExploitAvailable;
    }

    @JsonAnySetter
    public VulnerabilityRisks putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VulnerabilityRisks vulnerabilityRisks = (VulnerabilityRisks)o;
        return Objects.equals(this.epss, vulnerabilityRisks.epss) && Objects.equals(this.exploitAvailable, vulnerabilityRisks.exploitAvailable) && Objects.equals(this.exploitSources, vulnerabilityRisks.exploitSources) && Objects.equals(this.exploitationProbability, vulnerabilityRisks.exploitationProbability) && Objects.equals(this.pocExploitAvailable, vulnerabilityRisks.pocExploitAvailable) && Objects.equals(this.additionalProperties, vulnerabilityRisks.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.epss, this.exploitAvailable, this.exploitSources, this.exploitationProbability, this.pocExploitAvailable, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VulnerabilityRisks {\n");
        sb.append("    epss: ").append(this.toIndentedString(this.epss)).append("\n");
        sb.append("    exploitAvailable: ").append(this.toIndentedString(this.exploitAvailable)).append("\n");
        sb.append("    exploitSources: ").append(this.toIndentedString(this.exploitSources)).append("\n");
        sb.append("    exploitationProbability: ").append(this.toIndentedString(this.exploitationProbability)).append("\n");
        sb.append("    pocExploitAvailable: ").append(this.toIndentedString(this.pocExploitAvailable)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

