/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.BudgetEntry;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"created_at", "created_by", "end_month", "entries", "metrics_query", "name", "org_id", "start_month", "total_amount", "updated_at", "updated_by"})
public class BudgetAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private String createdBy;
    public static final String JSON_PROPERTY_END_MONTH = "end_month";
    private Long endMonth;
    public static final String JSON_PROPERTY_ENTRIES = "entries";
    private List<BudgetEntry> entries = null;
    public static final String JSON_PROPERTY_METRICS_QUERY = "metrics_query";
    private String metricsQuery;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ORG_ID = "org_id";
    private Long orgId;
    public static final String JSON_PROPERTY_START_MONTH = "start_month";
    private Long startMonth;
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
    private Double totalAmount;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updated_by";
    private String updatedBy;
    private Map<String, Object> additionalProperties;

    public BudgetAttributes createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public BudgetAttributes createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public BudgetAttributes endMonth(Long endMonth) {
        this.endMonth = endMonth;
        return this;
    }

    @Nullable
    @JsonProperty(value="end_month")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEndMonth() {
        return this.endMonth;
    }

    public void setEndMonth(Long endMonth) {
        this.endMonth = endMonth;
    }

    public BudgetAttributes entries(List<BudgetEntry> entries) {
        this.entries = entries;
        for (BudgetEntry item : entries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public BudgetAttributes addEntriesItem(BudgetEntry entriesItem) {
        if (this.entries == null) {
            this.entries = new ArrayList<BudgetEntry>();
        }
        this.entries.add(entriesItem);
        this.unparsed |= entriesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="entries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BudgetEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<BudgetEntry> entries) {
        this.entries = entries;
    }

    public BudgetAttributes metricsQuery(String metricsQuery) {
        this.metricsQuery = metricsQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetricsQuery() {
        return this.metricsQuery;
    }

    public void setMetricsQuery(String metricsQuery) {
        this.metricsQuery = metricsQuery;
    }

    public BudgetAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BudgetAttributes orgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }

    @Nullable
    @JsonProperty(value="org_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BudgetAttributes startMonth(Long startMonth) {
        this.startMonth = startMonth;
        return this;
    }

    @Nullable
    @JsonProperty(value="start_month")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartMonth() {
        return this.startMonth;
    }

    public void setStartMonth(Long startMonth) {
        this.startMonth = startMonth;
    }

    public BudgetAttributes totalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BudgetAttributes updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public BudgetAttributes updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @JsonAnySetter
    public BudgetAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BudgetAttributes budgetAttributes = (BudgetAttributes)o;
        return Objects.equals(this.createdAt, budgetAttributes.createdAt) && Objects.equals(this.createdBy, budgetAttributes.createdBy) && Objects.equals(this.endMonth, budgetAttributes.endMonth) && Objects.equals(this.entries, budgetAttributes.entries) && Objects.equals(this.metricsQuery, budgetAttributes.metricsQuery) && Objects.equals(this.name, budgetAttributes.name) && Objects.equals(this.orgId, budgetAttributes.orgId) && Objects.equals(this.startMonth, budgetAttributes.startMonth) && Objects.equals(this.totalAmount, budgetAttributes.totalAmount) && Objects.equals(this.updatedAt, budgetAttributes.updatedAt) && Objects.equals(this.updatedBy, budgetAttributes.updatedBy) && Objects.equals(this.additionalProperties, budgetAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.createdBy, this.endMonth, this.entries, this.metricsQuery, this.name, this.orgId, this.startMonth, this.totalAmount, this.updatedAt, this.updatedBy, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BudgetAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    endMonth: ").append(this.toIndentedString(this.endMonth)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("    metricsQuery: ").append(this.toIndentedString(this.metricsQuery)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    startMonth: ").append(this.toIndentedString(this.startMonth)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

