/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.PermissionsResponse;
import com.datadog.api.client.v2.model.QuerySortOrder;
import com.datadog.api.client.v2.model.User;
import com.datadog.api.client.v2.model.UserCreateRequest;
import com.datadog.api.client.v2.model.UserInvitationResponse;
import com.datadog.api.client.v2.model.UserInvitationsRequest;
import com.datadog.api.client.v2.model.UserInvitationsResponse;
import com.datadog.api.client.v2.model.UserResponse;
import com.datadog.api.client.v2.model.UserUpdateRequest;
import com.datadog.api.client.v2.model.UsersResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserResponse createUser(UserCreateRequest body) throws ApiException {
        return this.createUserWithHttpInfo(body).getData();
    }

    public CompletableFuture<UserResponse> createUserAsync(UserCreateRequest body) {
        return this.createUserWithHttpInfoAsync(body).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> createUserWithHttpInfo(UserCreateRequest body) throws ApiException {
        UserCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createUser");
        }
        String localVarPath = "/api/v2/users";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.createUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> createUserWithHttpInfoAsync(UserCreateRequest body) {
        Invocation.Builder builder;
        UserCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createUser"));
            return result;
        }
        String localVarPath = "/api/v2/users";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.createUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public void disableUser(String userId) throws ApiException {
        this.disableUserWithHttpInfo(userId);
    }

    public CompletableFuture<Void> disableUserAsync(String userId) {
        return this.disableUserWithHttpInfoAsync(userId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> disableUserWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling disableUser");
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.disableUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> disableUserWithHttpInfoAsync(String userId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling disableUser"));
            return result;
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.disableUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public UserInvitationResponse getInvitation(String userInvitationUuid) throws ApiException {
        return this.getInvitationWithHttpInfo(userInvitationUuid).getData();
    }

    public CompletableFuture<UserInvitationResponse> getInvitationAsync(String userInvitationUuid) {
        return this.getInvitationWithHttpInfoAsync(userInvitationUuid).thenApply(response -> (UserInvitationResponse)response.getData());
    }

    public ApiResponse<UserInvitationResponse> getInvitationWithHttpInfo(String userInvitationUuid) throws ApiException {
        Object localVarPostBody = null;
        if (userInvitationUuid == null) {
            throw new ApiException(400, "Missing the required parameter 'userInvitationUuid' when calling getInvitation");
        }
        String localVarPath = "/api/v2/user_invitations/{user_invitation_uuid}".replaceAll("\\{user_invitation_uuid\\}", this.apiClient.escapeString(userInvitationUuid.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.getInvitation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserInvitationResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserInvitationResponse>> getInvitationWithHttpInfoAsync(String userInvitationUuid) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userInvitationUuid == null) {
            CompletableFuture<ApiResponse<UserInvitationResponse>> result = new CompletableFuture<ApiResponse<UserInvitationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userInvitationUuid' when calling getInvitation"));
            return result;
        }
        String localVarPath = "/api/v2/user_invitations/{user_invitation_uuid}".replaceAll("\\{user_invitation_uuid\\}", this.apiClient.escapeString(userInvitationUuid.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.getInvitation", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserInvitationResponse>> result = new CompletableFuture<ApiResponse<UserInvitationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserInvitationResponse>(){});
    }

    public UserResponse getUser(String userId) throws ApiException {
        return this.getUserWithHttpInfo(userId).getData();
    }

    public CompletableFuture<UserResponse> getUserAsync(String userId) {
        return this.getUserWithHttpInfoAsync(userId).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> getUserWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUser");
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.getUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> getUserWithHttpInfoAsync(String userId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling getUser"));
            return result;
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.getUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public UserResponse listUserOrganizations(String userId) throws ApiException {
        return this.listUserOrganizationsWithHttpInfo(userId).getData();
    }

    public CompletableFuture<UserResponse> listUserOrganizationsAsync(String userId) {
        return this.listUserOrganizationsWithHttpInfoAsync(userId).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> listUserOrganizationsWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserOrganizations");
        }
        String localVarPath = "/api/v2/users/{user_id}/orgs".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.listUserOrganizations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> listUserOrganizationsWithHttpInfoAsync(String userId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling listUserOrganizations"));
            return result;
        }
        String localVarPath = "/api/v2/users/{user_id}/orgs".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.listUserOrganizations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public PermissionsResponse listUserPermissions(String userId) throws ApiException {
        return this.listUserPermissionsWithHttpInfo(userId).getData();
    }

    public CompletableFuture<PermissionsResponse> listUserPermissionsAsync(String userId) {
        return this.listUserPermissionsWithHttpInfoAsync(userId).thenApply(response -> (PermissionsResponse)response.getData());
    }

    public ApiResponse<PermissionsResponse> listUserPermissionsWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserPermissions");
        }
        String localVarPath = "/api/v2/users/{user_id}/permissions".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.listUserPermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<PermissionsResponse>> listUserPermissionsWithHttpInfoAsync(String userId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling listUserPermissions"));
            return result;
        }
        String localVarPath = "/api/v2/users/{user_id}/permissions".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.listUserPermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PermissionsResponse>> result = new CompletableFuture<ApiResponse<PermissionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PermissionsResponse>(){});
    }

    public UsersResponse listUsers() throws ApiException {
        return this.listUsersWithHttpInfo(new ListUsersOptionalParameters()).getData();
    }

    public CompletableFuture<UsersResponse> listUsersAsync() {
        return this.listUsersWithHttpInfoAsync(new ListUsersOptionalParameters()).thenApply(response -> (UsersResponse)response.getData());
    }

    public UsersResponse listUsers(ListUsersOptionalParameters parameters) throws ApiException {
        return this.listUsersWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<UsersResponse> listUsersAsync(ListUsersOptionalParameters parameters) {
        return this.listUsersWithHttpInfoAsync(parameters).thenApply(response -> (UsersResponse)response.getData());
    }

    public PaginationIterable<User> listUsersWithPagination() {
        ListUsersOptionalParameters parameters = new ListUsersOptionalParameters();
        return this.listUsersWithPagination(parameters);
    }

    public PaginationIterable<User> listUsersWithPagination(ListUsersOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageNumber";
        Boolean valueSetterParamOptional = true;
        parameters.pageNumber(0L);
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<User> iterator = new PaginationIterable<User>(this, "listUsers", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<UsersResponse> listUsersWithHttpInfo(ListUsersOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        QuerySortOrder sortDir = parameters.sortDir;
        String filter = parameters.filter;
        String filterStatus = parameters.filterStatus;
        String localVarPath = "/api/v2/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.listUsers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public CompletableFuture<ApiResponse<UsersResponse>> listUsersWithHttpInfoAsync(ListUsersOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        QuerySortOrder sortDir = parameters.sortDir;
        String filter = parameters.filter;
        String filterStatus = parameters.filterStatus;
        String localVarPath = "/api/v2/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.listUsers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UsersResponse>> result = new CompletableFuture<ApiResponse<UsersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UsersResponse>(){});
    }

    public UserInvitationsResponse sendInvitations(UserInvitationsRequest body) throws ApiException {
        return this.sendInvitationsWithHttpInfo(body).getData();
    }

    public CompletableFuture<UserInvitationsResponse> sendInvitationsAsync(UserInvitationsRequest body) {
        return this.sendInvitationsWithHttpInfoAsync(body).thenApply(response -> (UserInvitationsResponse)response.getData());
    }

    public ApiResponse<UserInvitationsResponse> sendInvitationsWithHttpInfo(UserInvitationsRequest body) throws ApiException {
        UserInvitationsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling sendInvitations");
        }
        String localVarPath = "/api/v2/user_invitations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.sendInvitations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserInvitationsResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserInvitationsResponse>> sendInvitationsWithHttpInfoAsync(UserInvitationsRequest body) {
        Invocation.Builder builder;
        UserInvitationsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UserInvitationsResponse>> result = new CompletableFuture<ApiResponse<UserInvitationsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling sendInvitations"));
            return result;
        }
        String localVarPath = "/api/v2/user_invitations";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.sendInvitations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserInvitationsResponse>> result = new CompletableFuture<ApiResponse<UserInvitationsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserInvitationsResponse>(){});
    }

    public UserResponse updateUser(String userId, UserUpdateRequest body) throws ApiException {
        return this.updateUserWithHttpInfo(userId, body).getData();
    }

    public CompletableFuture<UserResponse> updateUserAsync(String userId, UserUpdateRequest body) {
        return this.updateUserWithHttpInfoAsync(userId, body).thenApply(response -> (UserResponse)response.getData());
    }

    public ApiResponse<UserResponse> updateUserWithHttpInfo(String userId, UserUpdateRequest body) throws ApiException {
        UserUpdateRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUser");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateUser");
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.UsersApi.updateUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public CompletableFuture<ApiResponse<UserResponse>> updateUserWithHttpInfoAsync(String userId, UserUpdateRequest body) {
        Invocation.Builder builder;
        UserUpdateRequest localVarPostBody = body;
        if (userId == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling updateUser"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateUser"));
            return result;
        }
        String localVarPath = "/api/v2/users/{user_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.UsersApi.updateUser", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UserResponse>> result = new CompletableFuture<ApiResponse<UserResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UserResponse>(){});
    }

    public static class ListUsersOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private String sort;
        private QuerySortOrder sortDir;
        private String filter;
        private String filterStatus;

        public ListUsersOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListUsersOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListUsersOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListUsersOptionalParameters sortDir(QuerySortOrder sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public ListUsersOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListUsersOptionalParameters filterStatus(String filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }
    }
}

