/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.RumRetentionFilterCreateRequest;
import com.datadog.api.client.v2.model.RumRetentionFilterResponse;
import com.datadog.api.client.v2.model.RumRetentionFilterUpdateRequest;
import com.datadog.api.client.v2.model.RumRetentionFiltersOrderRequest;
import com.datadog.api.client.v2.model.RumRetentionFiltersOrderResponse;
import com.datadog.api.client.v2.model.RumRetentionFiltersResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class RumRetentionFiltersApi {
    private ApiClient apiClient;

    public RumRetentionFiltersApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public RumRetentionFiltersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RumRetentionFilterResponse createRetentionFilter(String appId, RumRetentionFilterCreateRequest body) throws ApiException {
        return this.createRetentionFilterWithHttpInfo(appId, body).getData();
    }

    public CompletableFuture<RumRetentionFilterResponse> createRetentionFilterAsync(String appId, RumRetentionFilterCreateRequest body) {
        return this.createRetentionFilterWithHttpInfoAsync(appId, body).thenApply(response -> (RumRetentionFilterResponse)response.getData());
    }

    public ApiResponse<RumRetentionFilterResponse> createRetentionFilterWithHttpInfo(String appId, RumRetentionFilterCreateRequest body) throws ApiException {
        RumRetentionFilterCreateRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createRetentionFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRetentionFilter");
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.createRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumRetentionFilterResponse>> createRetentionFilterWithHttpInfoAsync(String appId, RumRetentionFilterCreateRequest body) {
        Invocation.Builder builder;
        RumRetentionFilterCreateRequest localVarPostBody = body;
        if (appId == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling createRetentionFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.createRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFilterResponse>(){});
    }

    public void deleteRetentionFilter(String appId, String rfId) throws ApiException {
        this.deleteRetentionFilterWithHttpInfo(appId, rfId);
    }

    public CompletableFuture<Void> deleteRetentionFilterAsync(String appId, String rfId) {
        return this.deleteRetentionFilterWithHttpInfoAsync(appId, rfId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteRetentionFilterWithHttpInfo(String appId, String rfId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteRetentionFilter");
        }
        if (rfId == null) {
            throw new ApiException(400, "Missing the required parameter 'rfId' when calling deleteRetentionFilter");
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters/{rf_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{rf_id\\}", this.apiClient.escapeString(rfId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.deleteRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRetentionFilterWithHttpInfoAsync(String appId, String rfId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling deleteRetentionFilter"));
            return result;
        }
        if (rfId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rfId' when calling deleteRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters/{rf_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{rf_id\\}", this.apiClient.escapeString(rfId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.deleteRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RumRetentionFilterResponse getRetentionFilter(String appId, String rfId) throws ApiException {
        return this.getRetentionFilterWithHttpInfo(appId, rfId).getData();
    }

    public CompletableFuture<RumRetentionFilterResponse> getRetentionFilterAsync(String appId, String rfId) {
        return this.getRetentionFilterWithHttpInfoAsync(appId, rfId).thenApply(response -> (RumRetentionFilterResponse)response.getData());
    }

    public ApiResponse<RumRetentionFilterResponse> getRetentionFilterWithHttpInfo(String appId, String rfId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getRetentionFilter");
        }
        if (rfId == null) {
            throw new ApiException(400, "Missing the required parameter 'rfId' when calling getRetentionFilter");
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters/{rf_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{rf_id\\}", this.apiClient.escapeString(rfId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.getRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumRetentionFilterResponse>> getRetentionFilterWithHttpInfoAsync(String appId, String rfId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling getRetentionFilter"));
            return result;
        }
        if (rfId == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rfId' when calling getRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters/{rf_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{rf_id\\}", this.apiClient.escapeString(rfId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.getRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFilterResponse>(){});
    }

    public RumRetentionFiltersResponse listRetentionFilters(String appId) throws ApiException {
        return this.listRetentionFiltersWithHttpInfo(appId).getData();
    }

    public CompletableFuture<RumRetentionFiltersResponse> listRetentionFiltersAsync(String appId) {
        return this.listRetentionFiltersWithHttpInfoAsync(appId).thenApply(response -> (RumRetentionFiltersResponse)response.getData());
    }

    public ApiResponse<RumRetentionFiltersResponse> listRetentionFiltersWithHttpInfo(String appId) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listRetentionFilters");
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.listRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumRetentionFiltersResponse>> listRetentionFiltersWithHttpInfoAsync(String appId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<RumRetentionFiltersResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFiltersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling listRetentionFilters"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.listRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumRetentionFiltersResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFiltersResponse>(){});
    }

    public RumRetentionFiltersOrderResponse orderRetentionFilters(String appId, RumRetentionFiltersOrderRequest body) throws ApiException {
        return this.orderRetentionFiltersWithHttpInfo(appId, body).getData();
    }

    public CompletableFuture<RumRetentionFiltersOrderResponse> orderRetentionFiltersAsync(String appId, RumRetentionFiltersOrderRequest body) {
        return this.orderRetentionFiltersWithHttpInfoAsync(appId, body).thenApply(response -> (RumRetentionFiltersOrderResponse)response.getData());
    }

    public ApiResponse<RumRetentionFiltersOrderResponse> orderRetentionFiltersWithHttpInfo(String appId, RumRetentionFiltersOrderRequest body) throws ApiException {
        RumRetentionFiltersOrderRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling orderRetentionFilters");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling orderRetentionFilters");
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/relationships/retention_filters".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.orderRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFiltersOrderResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>> orderRetentionFiltersWithHttpInfoAsync(String appId, RumRetentionFiltersOrderRequest body) {
        Invocation.Builder builder;
        RumRetentionFiltersOrderRequest localVarPostBody = body;
        if (appId == null) {
            CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling orderRetentionFilters"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling orderRetentionFilters"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/relationships/retention_filters".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.orderRetentionFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFiltersOrderResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFiltersOrderResponse>(){});
    }

    public RumRetentionFilterResponse updateRetentionFilter(String appId, String rfId, RumRetentionFilterUpdateRequest body) throws ApiException {
        return this.updateRetentionFilterWithHttpInfo(appId, rfId, body).getData();
    }

    public CompletableFuture<RumRetentionFilterResponse> updateRetentionFilterAsync(String appId, String rfId, RumRetentionFilterUpdateRequest body) {
        return this.updateRetentionFilterWithHttpInfoAsync(appId, rfId, body).thenApply(response -> (RumRetentionFilterResponse)response.getData());
    }

    public ApiResponse<RumRetentionFilterResponse> updateRetentionFilterWithHttpInfo(String appId, String rfId, RumRetentionFilterUpdateRequest body) throws ApiException {
        RumRetentionFilterUpdateRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateRetentionFilter");
        }
        if (rfId == null) {
            throw new ApiException(400, "Missing the required parameter 'rfId' when calling updateRetentionFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRetentionFilter");
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters/{rf_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{rf_id\\}", this.apiClient.escapeString(rfId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.updateRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<RumRetentionFilterResponse>> updateRetentionFilterWithHttpInfoAsync(String appId, String rfId, RumRetentionFilterUpdateRequest body) {
        Invocation.Builder builder;
        RumRetentionFilterUpdateRequest localVarPostBody = body;
        if (appId == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling updateRetentionFilter"));
            return result;
        }
        if (rfId == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'rfId' when calling updateRetentionFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateRetentionFilter"));
            return result;
        }
        String localVarPath = "/api/v2/rum/applications/{app_id}/retention_filters/{rf_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{rf_id\\}", this.apiClient.escapeString(rfId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RumRetentionFiltersApi.updateRetentionFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RumRetentionFilterResponse>> result = new CompletableFuture<ApiResponse<RumRetentionFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RumRetentionFilterResponse>(){});
    }
}

