/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MetricCustomAggregation;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregations", "exclude_tags_mode", "include_percentiles", "tags"})
public class MetricTagConfigurationUpdateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    private List<MetricCustomAggregation> aggregations = null;
    public static final String JSON_PROPERTY_EXCLUDE_TAGS_MODE = "exclude_tags_mode";
    private Boolean excludeTagsMode;
    public static final String JSON_PROPERTY_INCLUDE_PERCENTILES = "include_percentiles";
    private Boolean includePercentiles;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;

    public MetricTagConfigurationUpdateAttributes aggregations(List<MetricCustomAggregation> aggregations) {
        this.aggregations = aggregations;
        for (MetricCustomAggregation item : aggregations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MetricTagConfigurationUpdateAttributes addAggregationsItem(MetricCustomAggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<MetricCustomAggregation>();
        }
        this.aggregations.add(aggregationsItem);
        this.unparsed |= aggregationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MetricCustomAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<MetricCustomAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public MetricTagConfigurationUpdateAttributes excludeTagsMode(Boolean excludeTagsMode) {
        this.excludeTagsMode = excludeTagsMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclude_tags_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getExcludeTagsMode() {
        return this.excludeTagsMode;
    }

    public void setExcludeTagsMode(Boolean excludeTagsMode) {
        this.excludeTagsMode = excludeTagsMode;
    }

    public MetricTagConfigurationUpdateAttributes includePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
        return this;
    }

    @Nullable
    @JsonProperty(value="include_percentiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePercentiles() {
        return this.includePercentiles;
    }

    public void setIncludePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
    }

    public MetricTagConfigurationUpdateAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricTagConfigurationUpdateAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonAnySetter
    public MetricTagConfigurationUpdateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfigurationUpdateAttributes metricTagConfigurationUpdateAttributes = (MetricTagConfigurationUpdateAttributes)o;
        return Objects.equals(this.aggregations, metricTagConfigurationUpdateAttributes.aggregations) && Objects.equals(this.excludeTagsMode, metricTagConfigurationUpdateAttributes.excludeTagsMode) && Objects.equals(this.includePercentiles, metricTagConfigurationUpdateAttributes.includePercentiles) && Objects.equals(this.tags, metricTagConfigurationUpdateAttributes.tags) && Objects.equals(this.additionalProperties, metricTagConfigurationUpdateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.excludeTagsMode, this.includePercentiles, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfigurationUpdateAttributes {\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    excludeTagsMode: ").append(this.toIndentedString(this.excludeTagsMode)).append("\n");
        sb.append("    includePercentiles: ").append(this.toIndentedString(this.includePercentiles)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

