/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SecurityMonitoringRuleEvaluationWindowSerializer.class)
public class SecurityMonitoringRuleEvaluationWindow {
    public static final SecurityMonitoringRuleEvaluationWindow ZERO_MINUTES = new SecurityMonitoringRuleEvaluationWindow(0);
    public static final SecurityMonitoringRuleEvaluationWindow ONE_MINUTE = new SecurityMonitoringRuleEvaluationWindow(60);
    public static final SecurityMonitoringRuleEvaluationWindow FIVE_MINUTES = new SecurityMonitoringRuleEvaluationWindow(300);
    public static final SecurityMonitoringRuleEvaluationWindow TEN_MINUTES = new SecurityMonitoringRuleEvaluationWindow(600);
    public static final SecurityMonitoringRuleEvaluationWindow FIFTEEN_MINUTES = new SecurityMonitoringRuleEvaluationWindow(900);
    public static final SecurityMonitoringRuleEvaluationWindow THIRTY_MINUTES = new SecurityMonitoringRuleEvaluationWindow(1800);
    public static final SecurityMonitoringRuleEvaluationWindow ONE_HOUR = new SecurityMonitoringRuleEvaluationWindow(3600);
    public static final SecurityMonitoringRuleEvaluationWindow TWO_HOURS = new SecurityMonitoringRuleEvaluationWindow(7200);
    private static final Set<Integer> allowedValues = new HashSet<Integer>(Arrays.asList(0, 60, 300, 600, 900, 1800, 3600, 7200));
    private Integer value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SecurityMonitoringRuleEvaluationWindow(Integer value) {
        this.value = value;
    }

    @JsonValue
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SecurityMonitoringRuleEvaluationWindow)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SecurityMonitoringRuleEvaluationWindow fromValue(Integer value) {
        return new SecurityMonitoringRuleEvaluationWindow(value);
    }

    public static class SecurityMonitoringRuleEvaluationWindowSerializer
    extends StdSerializer<SecurityMonitoringRuleEvaluationWindow> {
        public SecurityMonitoringRuleEvaluationWindowSerializer(Class<SecurityMonitoringRuleEvaluationWindow> t) {
            super(t);
        }

        public SecurityMonitoringRuleEvaluationWindowSerializer() {
            this(null);
        }

        public void serialize(SecurityMonitoringRuleEvaluationWindow value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

