/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.LayerAttributesInterval;
import com.datadog.api.client.v2.model.TimeRestriction;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"effective_date", "end_date", "interval", "name", "restrictions", "rotation_start"})
public class LayerAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EFFECTIVE_DATE = "effective_date";
    private OffsetDateTime effectiveDate;
    public static final String JSON_PROPERTY_END_DATE = "end_date";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private LayerAttributesInterval interval;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_RESTRICTIONS = "restrictions";
    private List<TimeRestriction> restrictions = null;
    public static final String JSON_PROPERTY_ROTATION_START = "rotation_start";
    private OffsetDateTime rotationStart;
    private Map<String, Object> additionalProperties;

    public LayerAttributes effectiveDate(OffsetDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="effective_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(OffsetDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public LayerAttributes endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="end_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public LayerAttributes interval(LayerAttributesInterval interval) {
        this.interval = interval;
        this.unparsed |= interval.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LayerAttributesInterval getInterval() {
        return this.interval;
    }

    public void setInterval(LayerAttributesInterval interval) {
        this.interval = interval;
    }

    public LayerAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LayerAttributes restrictions(List<TimeRestriction> restrictions) {
        this.restrictions = restrictions;
        for (TimeRestriction item : restrictions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LayerAttributes addRestrictionsItem(TimeRestriction restrictionsItem) {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<TimeRestriction>();
        }
        this.restrictions.add(restrictionsItem);
        this.unparsed |= restrictionsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="restrictions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TimeRestriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<TimeRestriction> restrictions) {
        this.restrictions = restrictions;
    }

    public LayerAttributes rotationStart(OffsetDateTime rotationStart) {
        this.rotationStart = rotationStart;
        return this;
    }

    @Nullable
    @JsonProperty(value="rotation_start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getRotationStart() {
        return this.rotationStart;
    }

    public void setRotationStart(OffsetDateTime rotationStart) {
        this.rotationStart = rotationStart;
    }

    @JsonAnySetter
    public LayerAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerAttributes layerAttributes = (LayerAttributes)o;
        return Objects.equals(this.effectiveDate, layerAttributes.effectiveDate) && Objects.equals(this.endDate, layerAttributes.endDate) && Objects.equals(this.interval, layerAttributes.interval) && Objects.equals(this.name, layerAttributes.name) && Objects.equals(this.restrictions, layerAttributes.restrictions) && Objects.equals(this.rotationStart, layerAttributes.rotationStart) && Objects.equals(this.additionalProperties, layerAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveDate, this.endDate, this.interval, this.name, this.restrictions, this.rotationStart, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LayerAttributes {\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    restrictions: ").append(this.toIndentedString(this.restrictions)).append("\n");
        sb.append("    rotationStart: ").append(this.toIndentedString(this.rotationStart)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

