/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsBasicAuth;
import com.datadog.api.client.v1.model.SyntheticsTestCallType;
import com.datadog.api.client.v1.model.SyntheticsTestOptionsHTTPVersion;
import com.datadog.api.client.v1.model.SyntheticsTestRequestBodyFile;
import com.datadog.api.client.v1.model.SyntheticsTestRequestBodyType;
import com.datadog.api.client.v1.model.SyntheticsTestRequestCertificate;
import com.datadog.api.client.v1.model.SyntheticsTestRequestPort;
import com.datadog.api.client.v1.model.SyntheticsTestRequestProxy;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"allow_insecure", "basicAuth", "body", "bodyType", "callType", "certificate", "certificateDomains", "checkCertificateRevocation", "compressedJsonDescriptor", "compressedProtoFile", "dnsServer", "dnsServerPort", "files", "follow_redirects", "form", "headers", "host", "httpVersion", "isMessageBase64Encoded", "message", "metadata", "method", "noSavingResponseBody", "numberOfPackets", "persistCookies", "port", "proxy", "query", "servername", "service", "shouldTrackHops", "timeout", "url"})
public class SyntheticsTestRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALLOW_INSECURE = "allow_insecure";
    private Boolean allowInsecure;
    public static final String JSON_PROPERTY_BASIC_AUTH = "basicAuth";
    private SyntheticsBasicAuth basicAuth;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_BODY_TYPE = "bodyType";
    private SyntheticsTestRequestBodyType bodyType;
    public static final String JSON_PROPERTY_CALL_TYPE = "callType";
    private SyntheticsTestCallType callType;
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private SyntheticsTestRequestCertificate certificate;
    public static final String JSON_PROPERTY_CERTIFICATE_DOMAINS = "certificateDomains";
    private List<String> certificateDomains = null;
    public static final String JSON_PROPERTY_CHECK_CERTIFICATE_REVOCATION = "checkCertificateRevocation";
    private Boolean checkCertificateRevocation;
    public static final String JSON_PROPERTY_COMPRESSED_JSON_DESCRIPTOR = "compressedJsonDescriptor";
    private String compressedJsonDescriptor;
    public static final String JSON_PROPERTY_COMPRESSED_PROTO_FILE = "compressedProtoFile";
    private String compressedProtoFile;
    public static final String JSON_PROPERTY_DNS_SERVER = "dnsServer";
    private String dnsServer;
    public static final String JSON_PROPERTY_DNS_SERVER_PORT = "dnsServerPort";
    private String dnsServerPort;
    public static final String JSON_PROPERTY_FILES = "files";
    private List<SyntheticsTestRequestBodyFile> files = null;
    public static final String JSON_PROPERTY_FOLLOW_REDIRECTS = "follow_redirects";
    private Boolean followRedirects;
    public static final String JSON_PROPERTY_FORM = "form";
    private Map<String, String> form = null;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private Map<String, String> headers = null;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_HTTP_VERSION = "httpVersion";
    private SyntheticsTestOptionsHTTPVersion httpVersion;
    public static final String JSON_PROPERTY_IS_MESSAGE_BASE64_ENCODED = "isMessageBase64Encoded";
    private Boolean isMessageBase64Encoded;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_NO_SAVING_RESPONSE_BODY = "noSavingResponseBody";
    private Boolean noSavingResponseBody;
    public static final String JSON_PROPERTY_NUMBER_OF_PACKETS = "numberOfPackets";
    private Integer numberOfPackets;
    public static final String JSON_PROPERTY_PERSIST_COOKIES = "persistCookies";
    private Boolean persistCookies;
    public static final String JSON_PROPERTY_PORT = "port";
    private SyntheticsTestRequestPort port;
    public static final String JSON_PROPERTY_PROXY = "proxy";
    private SyntheticsTestRequestProxy proxy;
    public static final String JSON_PROPERTY_QUERY = "query";
    private Object query;
    public static final String JSON_PROPERTY_SERVERNAME = "servername";
    private String servername;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private String service;
    public static final String JSON_PROPERTY_SHOULD_TRACK_HOPS = "shouldTrackHops";
    private Boolean shouldTrackHops;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private Double timeout;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private Map<String, Object> additionalProperties;

    public SyntheticsTestRequest allowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @Nullable
    @JsonProperty(value="allow_insecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public void setAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public SyntheticsTestRequest basicAuth(SyntheticsBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
        this.unparsed |= basicAuth.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="basicAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(SyntheticsBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public SyntheticsTestRequest body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SyntheticsTestRequest bodyType(SyntheticsTestRequestBodyType bodyType) {
        this.bodyType = bodyType;
        this.unparsed |= !bodyType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="bodyType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequestBodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(SyntheticsTestRequestBodyType bodyType) {
        if (!bodyType.isValid()) {
            this.unparsed = true;
        }
        this.bodyType = bodyType;
    }

    public SyntheticsTestRequest callType(SyntheticsTestCallType callType) {
        this.callType = callType;
        this.unparsed |= !callType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="callType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestCallType getCallType() {
        return this.callType;
    }

    public void setCallType(SyntheticsTestCallType callType) {
        if (!callType.isValid()) {
            this.unparsed = true;
        }
        this.callType = callType;
    }

    public SyntheticsTestRequest certificate(SyntheticsTestRequestCertificate certificate) {
        this.certificate = certificate;
        this.unparsed |= certificate.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequestCertificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(SyntheticsTestRequestCertificate certificate) {
        this.certificate = certificate;
    }

    public SyntheticsTestRequest certificateDomains(List<String> certificateDomains) {
        this.certificateDomains = certificateDomains;
        return this;
    }

    public SyntheticsTestRequest addCertificateDomainsItem(String certificateDomainsItem) {
        if (this.certificateDomains == null) {
            this.certificateDomains = new ArrayList<String>();
        }
        this.certificateDomains.add(certificateDomainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="certificateDomains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCertificateDomains() {
        return this.certificateDomains;
    }

    public void setCertificateDomains(List<String> certificateDomains) {
        this.certificateDomains = certificateDomains;
    }

    public SyntheticsTestRequest checkCertificateRevocation(Boolean checkCertificateRevocation) {
        this.checkCertificateRevocation = checkCertificateRevocation;
        return this;
    }

    @Nullable
    @JsonProperty(value="checkCertificateRevocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCheckCertificateRevocation() {
        return this.checkCertificateRevocation;
    }

    public void setCheckCertificateRevocation(Boolean checkCertificateRevocation) {
        this.checkCertificateRevocation = checkCertificateRevocation;
    }

    public SyntheticsTestRequest compressedJsonDescriptor(String compressedJsonDescriptor) {
        this.compressedJsonDescriptor = compressedJsonDescriptor;
        return this;
    }

    @Nullable
    @JsonProperty(value="compressedJsonDescriptor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompressedJsonDescriptor() {
        return this.compressedJsonDescriptor;
    }

    public void setCompressedJsonDescriptor(String compressedJsonDescriptor) {
        this.compressedJsonDescriptor = compressedJsonDescriptor;
    }

    public SyntheticsTestRequest compressedProtoFile(String compressedProtoFile) {
        this.compressedProtoFile = compressedProtoFile;
        return this;
    }

    @Nullable
    @JsonProperty(value="compressedProtoFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompressedProtoFile() {
        return this.compressedProtoFile;
    }

    public void setCompressedProtoFile(String compressedProtoFile) {
        this.compressedProtoFile = compressedProtoFile;
    }

    public SyntheticsTestRequest dnsServer(String dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    @Nullable
    @JsonProperty(value="dnsServer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(String dnsServer) {
        this.dnsServer = dnsServer;
    }

    public SyntheticsTestRequest dnsServerPort(String dnsServerPort) {
        this.dnsServerPort = dnsServerPort;
        return this;
    }

    @Nullable
    @JsonProperty(value="dnsServerPort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDnsServerPort() {
        return this.dnsServerPort;
    }

    public void setDnsServerPort(String dnsServerPort) {
        this.dnsServerPort = dnsServerPort;
    }

    public SyntheticsTestRequest files(List<SyntheticsTestRequestBodyFile> files) {
        this.files = files;
        for (SyntheticsTestRequestBodyFile item : files) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsTestRequest addFilesItem(SyntheticsTestRequestBodyFile filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<SyntheticsTestRequestBodyFile>();
        }
        this.files.add(filesItem);
        this.unparsed |= filesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsTestRequestBodyFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<SyntheticsTestRequestBodyFile> files) {
        this.files = files;
    }

    public SyntheticsTestRequest followRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Nullable
    @JsonProperty(value="follow_redirects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public SyntheticsTestRequest form(Map<String, String> form) {
        this.form = form;
        return this;
    }

    public SyntheticsTestRequest putFormItem(String key, String formItem) {
        if (this.form == null) {
            this.form = new HashMap<String, String>();
        }
        this.form.put(key, formItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="form")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getForm() {
        return this.form;
    }

    public void setForm(Map<String, String> form) {
        this.form = form;
    }

    public SyntheticsTestRequest headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public SyntheticsTestRequest putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public SyntheticsTestRequest host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SyntheticsTestRequest httpVersion(SyntheticsTestOptionsHTTPVersion httpVersion) {
        this.httpVersion = httpVersion;
        this.unparsed |= !httpVersion.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="httpVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestOptionsHTTPVersion getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(SyntheticsTestOptionsHTTPVersion httpVersion) {
        if (!httpVersion.isValid()) {
            this.unparsed = true;
        }
        this.httpVersion = httpVersion;
    }

    public SyntheticsTestRequest isMessageBase64Encoded(Boolean isMessageBase64Encoded) {
        this.isMessageBase64Encoded = isMessageBase64Encoded;
        return this;
    }

    @Nullable
    @JsonProperty(value="isMessageBase64Encoded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsMessageBase64Encoded() {
        return this.isMessageBase64Encoded;
    }

    public void setIsMessageBase64Encoded(Boolean isMessageBase64Encoded) {
        this.isMessageBase64Encoded = isMessageBase64Encoded;
    }

    public SyntheticsTestRequest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SyntheticsTestRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public SyntheticsTestRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public SyntheticsTestRequest method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public SyntheticsTestRequest noSavingResponseBody(Boolean noSavingResponseBody) {
        this.noSavingResponseBody = noSavingResponseBody;
        return this;
    }

    @Nullable
    @JsonProperty(value="noSavingResponseBody")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNoSavingResponseBody() {
        return this.noSavingResponseBody;
    }

    public void setNoSavingResponseBody(Boolean noSavingResponseBody) {
        this.noSavingResponseBody = noSavingResponseBody;
    }

    public SyntheticsTestRequest numberOfPackets(Integer numberOfPackets) {
        this.numberOfPackets = numberOfPackets;
        return this;
    }

    @Nullable
    @JsonProperty(value="numberOfPackets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfPackets() {
        return this.numberOfPackets;
    }

    public void setNumberOfPackets(Integer numberOfPackets) {
        this.numberOfPackets = numberOfPackets;
    }

    public SyntheticsTestRequest persistCookies(Boolean persistCookies) {
        this.persistCookies = persistCookies;
        return this;
    }

    @Nullable
    @JsonProperty(value="persistCookies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPersistCookies() {
        return this.persistCookies;
    }

    public void setPersistCookies(Boolean persistCookies) {
        this.persistCookies = persistCookies;
    }

    public SyntheticsTestRequest port(SyntheticsTestRequestPort port) {
        this.port = port;
        this.unparsed |= port.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequestPort getPort() {
        return this.port;
    }

    public void setPort(SyntheticsTestRequestPort port) {
        this.port = port;
    }

    public SyntheticsTestRequest proxy(SyntheticsTestRequestProxy proxy) {
        this.proxy = proxy;
        this.unparsed |= proxy.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="proxy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequestProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(SyntheticsTestRequestProxy proxy) {
        this.proxy = proxy;
    }

    public SyntheticsTestRequest query(Object query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getQuery() {
        return this.query;
    }

    public void setQuery(Object query) {
        this.query = query;
    }

    public SyntheticsTestRequest servername(String servername) {
        this.servername = servername;
        return this;
    }

    @Nullable
    @JsonProperty(value="servername")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public SyntheticsTestRequest service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public SyntheticsTestRequest shouldTrackHops(Boolean shouldTrackHops) {
        this.shouldTrackHops = shouldTrackHops;
        return this;
    }

    @Nullable
    @JsonProperty(value="shouldTrackHops")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShouldTrackHops() {
        return this.shouldTrackHops;
    }

    public void setShouldTrackHops(Boolean shouldTrackHops) {
        this.shouldTrackHops = shouldTrackHops;
    }

    public SyntheticsTestRequest timeout(Double timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Double timeout) {
        this.timeout = timeout;
    }

    public SyntheticsTestRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonAnySetter
    public SyntheticsTestRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestRequest syntheticsTestRequest = (SyntheticsTestRequest)o;
        return Objects.equals(this.allowInsecure, syntheticsTestRequest.allowInsecure) && Objects.equals(this.basicAuth, syntheticsTestRequest.basicAuth) && Objects.equals(this.body, syntheticsTestRequest.body) && Objects.equals(this.bodyType, syntheticsTestRequest.bodyType) && Objects.equals(this.callType, syntheticsTestRequest.callType) && Objects.equals(this.certificate, syntheticsTestRequest.certificate) && Objects.equals(this.certificateDomains, syntheticsTestRequest.certificateDomains) && Objects.equals(this.checkCertificateRevocation, syntheticsTestRequest.checkCertificateRevocation) && Objects.equals(this.compressedJsonDescriptor, syntheticsTestRequest.compressedJsonDescriptor) && Objects.equals(this.compressedProtoFile, syntheticsTestRequest.compressedProtoFile) && Objects.equals(this.dnsServer, syntheticsTestRequest.dnsServer) && Objects.equals(this.dnsServerPort, syntheticsTestRequest.dnsServerPort) && Objects.equals(this.files, syntheticsTestRequest.files) && Objects.equals(this.followRedirects, syntheticsTestRequest.followRedirects) && Objects.equals(this.form, syntheticsTestRequest.form) && Objects.equals(this.headers, syntheticsTestRequest.headers) && Objects.equals(this.host, syntheticsTestRequest.host) && Objects.equals(this.httpVersion, syntheticsTestRequest.httpVersion) && Objects.equals(this.isMessageBase64Encoded, syntheticsTestRequest.isMessageBase64Encoded) && Objects.equals(this.message, syntheticsTestRequest.message) && Objects.equals(this.metadata, syntheticsTestRequest.metadata) && Objects.equals(this.method, syntheticsTestRequest.method) && Objects.equals(this.noSavingResponseBody, syntheticsTestRequest.noSavingResponseBody) && Objects.equals(this.numberOfPackets, syntheticsTestRequest.numberOfPackets) && Objects.equals(this.persistCookies, syntheticsTestRequest.persistCookies) && Objects.equals(this.port, syntheticsTestRequest.port) && Objects.equals(this.proxy, syntheticsTestRequest.proxy) && Objects.equals(this.query, syntheticsTestRequest.query) && Objects.equals(this.servername, syntheticsTestRequest.servername) && Objects.equals(this.service, syntheticsTestRequest.service) && Objects.equals(this.shouldTrackHops, syntheticsTestRequest.shouldTrackHops) && Objects.equals(this.timeout, syntheticsTestRequest.timeout) && Objects.equals(this.url, syntheticsTestRequest.url) && Objects.equals(this.additionalProperties, syntheticsTestRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.allowInsecure, this.basicAuth, this.body, this.bodyType, this.callType, this.certificate, this.certificateDomains, this.checkCertificateRevocation, this.compressedJsonDescriptor, this.compressedProtoFile, this.dnsServer, this.dnsServerPort, this.files, this.followRedirects, this.form, this.headers, this.host, this.httpVersion, this.isMessageBase64Encoded, this.message, this.metadata, this.method, this.noSavingResponseBody, this.numberOfPackets, this.persistCookies, this.port, this.proxy, this.query, this.servername, this.service, this.shouldTrackHops, this.timeout, this.url, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestRequest {\n");
        sb.append("    allowInsecure: ").append(this.toIndentedString(this.allowInsecure)).append("\n");
        sb.append("    basicAuth: ").append(this.toIndentedString(this.basicAuth)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    bodyType: ").append(this.toIndentedString(this.bodyType)).append("\n");
        sb.append("    callType: ").append(this.toIndentedString(this.callType)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    certificateDomains: ").append(this.toIndentedString(this.certificateDomains)).append("\n");
        sb.append("    checkCertificateRevocation: ").append(this.toIndentedString(this.checkCertificateRevocation)).append("\n");
        sb.append("    compressedJsonDescriptor: ").append(this.toIndentedString(this.compressedJsonDescriptor)).append("\n");
        sb.append("    compressedProtoFile: ").append(this.toIndentedString(this.compressedProtoFile)).append("\n");
        sb.append("    dnsServer: ").append(this.toIndentedString(this.dnsServer)).append("\n");
        sb.append("    dnsServerPort: ").append(this.toIndentedString(this.dnsServerPort)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    followRedirects: ").append(this.toIndentedString(this.followRedirects)).append("\n");
        sb.append("    form: ").append(this.toIndentedString(this.form)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    httpVersion: ").append(this.toIndentedString(this.httpVersion)).append("\n");
        sb.append("    isMessageBase64Encoded: ").append(this.toIndentedString(this.isMessageBase64Encoded)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    noSavingResponseBody: ").append(this.toIndentedString(this.noSavingResponseBody)).append("\n");
        sb.append("    numberOfPackets: ").append(this.toIndentedString(this.numberOfPackets)).append("\n");
        sb.append("    persistCookies: ").append(this.toIndentedString(this.persistCookies)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    proxy: ").append(this.toIndentedString(this.proxy)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    servername: ").append(this.toIndentedString(this.servername)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    shouldTrackHops: ").append(this.toIndentedString(this.shouldTrackHops)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

