/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EventsQueryFilter;
import com.datadog.api.client.v2.model.EventsQueryOptions;
import com.datadog.api.client.v2.model.EventsRequestPage;
import com.datadog.api.client.v2.model.EventsSort;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"filter", "options", "page", "sort"})
public class EventsListRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private EventsQueryFilter filter;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private EventsQueryOptions options;
    public static final String JSON_PROPERTY_PAGE = "page";
    private EventsRequestPage page;
    public static final String JSON_PROPERTY_SORT = "sort";
    private EventsSort sort;
    private Map<String, Object> additionalProperties;

    public EventsListRequest filter(EventsQueryFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(EventsQueryFilter filter) {
        this.filter = filter;
    }

    public EventsListRequest options(EventsQueryOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsQueryOptions getOptions() {
        return this.options;
    }

    public void setOptions(EventsQueryOptions options) {
        this.options = options;
    }

    public EventsListRequest page(EventsRequestPage page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsRequestPage getPage() {
        return this.page;
    }

    public void setPage(EventsRequestPage page) {
        this.page = page;
    }

    public EventsListRequest sort(EventsSort sort) {
        this.sort = sort;
        this.unparsed |= !sort.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsSort getSort() {
        return this.sort;
    }

    public void setSort(EventsSort sort) {
        if (!sort.isValid()) {
            this.unparsed = true;
        }
        this.sort = sort;
    }

    @JsonAnySetter
    public EventsListRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsListRequest eventsListRequest = (EventsListRequest)o;
        return Objects.equals(this.filter, eventsListRequest.filter) && Objects.equals(this.options, eventsListRequest.options) && Objects.equals(this.page, eventsListRequest.page) && Objects.equals(this.sort, eventsListRequest.sort) && Objects.equals(this.additionalProperties, eventsListRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.options, this.page, this.sort, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsListRequest {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

