/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RuleSeverity;
import com.datadog.api.client.v2.model.RuleTypesItems;
import com.datadog.api.client.v2.model.TriggerSource;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"query", "rule_types", "severities", "trigger_source"})
public class Selectors {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RULE_TYPES = "rule_types";
    private List<RuleTypesItems> ruleTypes = null;
    public static final String JSON_PROPERTY_SEVERITIES = "severities";
    private List<RuleSeverity> severities = null;
    public static final String JSON_PROPERTY_TRIGGER_SOURCE = "trigger_source";
    private TriggerSource triggerSource;
    private Map<String, Object> additionalProperties;

    public Selectors() {
    }

    @JsonCreator
    public Selectors(@JsonProperty(required=true, value="trigger_source") TriggerSource triggerSource) {
        this.triggerSource = triggerSource;
        this.unparsed |= !triggerSource.isValid();
    }

    public Selectors query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Selectors ruleTypes(List<RuleTypesItems> ruleTypes) {
        this.ruleTypes = ruleTypes;
        return this;
    }

    public Selectors addRuleTypesItem(RuleTypesItems ruleTypesItem) {
        if (this.ruleTypes == null) {
            this.ruleTypes = new ArrayList<RuleTypesItems>();
        }
        this.ruleTypes.add(ruleTypesItem);
        this.unparsed |= !ruleTypesItem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="rule_types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RuleTypesItems> getRuleTypes() {
        return this.ruleTypes;
    }

    public void setRuleTypes(List<RuleTypesItems> ruleTypes) {
        this.ruleTypes = ruleTypes;
    }

    public Selectors severities(List<RuleSeverity> severities) {
        this.severities = severities;
        return this;
    }

    public Selectors addSeveritiesItem(RuleSeverity severitiesItem) {
        if (this.severities == null) {
            this.severities = new ArrayList<RuleSeverity>();
        }
        this.severities.add(severitiesItem);
        this.unparsed |= !severitiesItem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="severities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RuleSeverity> getSeverities() {
        return this.severities;
    }

    public void setSeverities(List<RuleSeverity> severities) {
        this.severities = severities;
    }

    public Selectors triggerSource(TriggerSource triggerSource) {
        this.triggerSource = triggerSource;
        this.unparsed |= !triggerSource.isValid();
        return this;
    }

    @JsonProperty(value="trigger_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TriggerSource getTriggerSource() {
        return this.triggerSource;
    }

    public void setTriggerSource(TriggerSource triggerSource) {
        if (!triggerSource.isValid()) {
            this.unparsed = true;
        }
        this.triggerSource = triggerSource;
    }

    @JsonAnySetter
    public Selectors putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selectors selectors = (Selectors)o;
        return Objects.equals(this.query, selectors.query) && Objects.equals(this.ruleTypes, selectors.ruleTypes) && Objects.equals(this.severities, selectors.severities) && Objects.equals(this.triggerSource, selectors.triggerSource) && Objects.equals(this.additionalProperties, selectors.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.ruleTypes, this.severities, this.triggerSource, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Selectors {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    ruleTypes: ").append(this.toIndentedString(this.ruleTypes)).append("\n");
        sb.append("    severities: ").append(this.toIndentedString(this.severities)).append("\n");
        sb.append("    triggerSource: ").append(this.toIndentedString(this.triggerSource)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

