/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.AWSIntegration;
import com.datadog.api.client.v2.model.HTTPIntegration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import jakarta.ws.rs.core.GenericType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=ActionConnectionIntegrationDeserializer.class)
@JsonSerialize(using=ActionConnectionIntegrationSerializer.class)
public class ActionConnectionIntegration
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ActionConnectionIntegration.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public ActionConnectionIntegration() {
        super("oneOf", Boolean.FALSE);
    }

    public ActionConnectionIntegration(AWSIntegration o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ActionConnectionIntegration(HTTPIntegration o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(AWSIntegration.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(HTTPIntegration.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be AWSIntegration, HTTPIntegration");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public AWSIntegration getAWSIntegration() throws ClassCastException {
        return (AWSIntegration)super.getActualInstance();
    }

    public HTTPIntegration getHTTPIntegration() throws ClassCastException {
        return (HTTPIntegration)super.getActualInstance();
    }

    static {
        schemas.put("AWSIntegration", (GenericType)new GenericType<AWSIntegration>(){});
        schemas.put("HTTPIntegration", (GenericType)new GenericType<HTTPIntegration>(){});
        JSON.registerDescendants(ActionConnectionIntegration.class, Collections.unmodifiableMap(schemas));
    }

    public static class ActionConnectionIntegrationDeserializer
    extends StdDeserializer<ActionConnectionIntegration> {
        public ActionConnectionIntegrationDeserializer() {
            this(ActionConnectionIntegration.class);
        }

        public ActionConnectionIntegrationDeserializer(Class<?> vc) {
            super(vc);
        }

        public ActionConnectionIntegration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((AWSIntegration.class.equals(Integer.class) || AWSIntegration.class.equals(Long.class) || AWSIntegration.class.equals(Float.class) || AWSIntegration.class.equals(Double.class) || AWSIntegration.class.equals(Boolean.class) || AWSIntegration.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (AWSIntegration.class.equals(Integer.class) || AWSIntegration.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!AWSIntegration.class.equals(Float.class) && !AWSIntegration.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= AWSIntegration.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= AWSIntegration.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(AWSIntegration.class);
                    if (!((AWSIntegration)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'AWSIntegration'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'AWSIntegration'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((HTTPIntegration.class.equals(Integer.class) || HTTPIntegration.class.equals(Long.class) || HTTPIntegration.class.equals(Float.class) || HTTPIntegration.class.equals(Double.class) || HTTPIntegration.class.equals(Boolean.class) || HTTPIntegration.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (HTTPIntegration.class.equals(Integer.class) || HTTPIntegration.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!HTTPIntegration.class.equals(Float.class) && !HTTPIntegration.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= HTTPIntegration.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= HTTPIntegration.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(HTTPIntegration.class);
                    if (!((HTTPIntegration)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'HTTPIntegration'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'HTTPIntegration'", e);
            }
            ActionConnectionIntegration ret = new ActionConnectionIntegration();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map res = (Map)new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        public ActionConnectionIntegration getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "ActionConnectionIntegration cannot be null");
        }
    }

    public static class ActionConnectionIntegrationSerializer
    extends StdSerializer<ActionConnectionIntegration> {
        public ActionConnectionIntegrationSerializer(Class<ActionConnectionIntegration> t) {
            super(t);
        }

        public ActionConnectionIntegrationSerializer() {
            this(null);
        }

        public void serialize(ActionConnectionIntegration value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

