/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.OktaAccountRequest;
import com.datadog.api.client.v2.model.OktaAccountResponse;
import com.datadog.api.client.v2.model.OktaAccountUpdateRequest;
import com.datadog.api.client.v2.model.OktaAccountsResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OktaIntegrationApi {
    private ApiClient apiClient;

    public OktaIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OktaIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OktaAccountResponse createOktaAccount(OktaAccountRequest body) throws ApiException {
        return this.createOktaAccountWithHttpInfo(body).getData();
    }

    public CompletableFuture<OktaAccountResponse> createOktaAccountAsync(OktaAccountRequest body) {
        return this.createOktaAccountWithHttpInfoAsync(body).thenApply(response -> (OktaAccountResponse)response.getData());
    }

    public ApiResponse<OktaAccountResponse> createOktaAccountWithHttpInfo(OktaAccountRequest body) throws ApiException {
        OktaAccountRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOktaAccount");
        }
        String localVarPath = "/api/v2/integrations/okta/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.createOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<OktaAccountResponse>> createOktaAccountWithHttpInfoAsync(OktaAccountRequest body) {
        Invocation.Builder builder;
        OktaAccountRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOktaAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/okta/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.createOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountResponse>(){});
    }

    public void deleteOktaAccount(String accountId) throws ApiException {
        this.deleteOktaAccountWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteOktaAccountAsync(String accountId) {
        return this.deleteOktaAccountWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOktaAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteOktaAccount");
        }
        String localVarPath = "/api/v2/integrations/okta/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.deleteOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOktaAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteOktaAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/okta/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.deleteOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public OktaAccountResponse getOktaAccount(String accountId) throws ApiException {
        return this.getOktaAccountWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<OktaAccountResponse> getOktaAccountAsync(String accountId) {
        return this.getOktaAccountWithHttpInfoAsync(accountId).thenApply(response -> (OktaAccountResponse)response.getData());
    }

    public ApiResponse<OktaAccountResponse> getOktaAccountWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getOktaAccount");
        }
        String localVarPath = "/api/v2/integrations/okta/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.getOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<OktaAccountResponse>> getOktaAccountWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getOktaAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/okta/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.getOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountResponse>(){});
    }

    public OktaAccountsResponse listOktaAccounts() throws ApiException {
        return this.listOktaAccountsWithHttpInfo().getData();
    }

    public CompletableFuture<OktaAccountsResponse> listOktaAccountsAsync() {
        return this.listOktaAccountsWithHttpInfoAsync().thenApply(response -> (OktaAccountsResponse)response.getData());
    }

    public ApiResponse<OktaAccountsResponse> listOktaAccountsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/okta/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.listOktaAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<OktaAccountsResponse>> listOktaAccountsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integrations/okta/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.listOktaAccounts", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OktaAccountsResponse>> result = new CompletableFuture<ApiResponse<OktaAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountsResponse>(){});
    }

    public OktaAccountResponse updateOktaAccount(String accountId, OktaAccountUpdateRequest body) throws ApiException {
        return this.updateOktaAccountWithHttpInfo(accountId, body).getData();
    }

    public CompletableFuture<OktaAccountResponse> updateOktaAccountAsync(String accountId, OktaAccountUpdateRequest body) {
        return this.updateOktaAccountWithHttpInfoAsync(accountId, body).thenApply(response -> (OktaAccountResponse)response.getData());
    }

    public ApiResponse<OktaAccountResponse> updateOktaAccountWithHttpInfo(String accountId, OktaAccountUpdateRequest body) throws ApiException {
        OktaAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateOktaAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOktaAccount");
        }
        String localVarPath = "/api/v2/integrations/okta/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.updateOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<OktaAccountResponse>> updateOktaAccountWithHttpInfoAsync(String accountId, OktaAccountUpdateRequest body) {
        Invocation.Builder builder;
        OktaAccountUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateOktaAccount"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOktaAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integrations/okta/accounts/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OktaIntegrationApi.updateOktaAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OktaAccountResponse>> result = new CompletableFuture<ApiResponse<OktaAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OktaAccountResponse>(){});
    }
}

