/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AppsSortField;
import com.datadog.api.client.v2.model.CreateAppRequest;
import com.datadog.api.client.v2.model.CreateAppResponse;
import com.datadog.api.client.v2.model.DeleteAppResponse;
import com.datadog.api.client.v2.model.DeleteAppsRequest;
import com.datadog.api.client.v2.model.DeleteAppsResponse;
import com.datadog.api.client.v2.model.GetAppResponse;
import com.datadog.api.client.v2.model.ListAppsResponse;
import com.datadog.api.client.v2.model.UpdateAppRequest;
import com.datadog.api.client.v2.model.UpdateAppResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AppsApi {
    private ApiClient apiClient;

    public AppsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AppsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateAppResponse createApp(CreateAppRequest body) throws ApiException {
        return this.createAppWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateAppResponse> createAppAsync(CreateAppRequest body) {
        return this.createAppWithHttpInfoAsync(body).thenApply(response -> (CreateAppResponse)response.getData());
    }

    public ApiResponse<CreateAppResponse> createAppWithHttpInfo(CreateAppRequest body) throws ApiException {
        String operationId = "createApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateAppRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApp");
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppsApi.createApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateAppResponse>> createAppWithHttpInfoAsync(CreateAppRequest body) {
        Invocation.Builder builder;
        String operationId = "createApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<CreateAppResponse>> result = new CompletableFuture<ApiResponse<CreateAppResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        CreateAppRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateAppResponse>> result = new CompletableFuture<ApiResponse<CreateAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppsApi.createApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateAppResponse>> result = new CompletableFuture<ApiResponse<CreateAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateAppResponse>(){});
    }

    public DeleteAppResponse deleteApp(String appId) throws ApiException {
        return this.deleteAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<DeleteAppResponse> deleteAppAsync(String appId) {
        return this.deleteAppWithHttpInfoAsync(appId).thenApply(response -> (DeleteAppResponse)response.getData());
    }

    public ApiResponse<DeleteAppResponse> deleteAppWithHttpInfo(String appId) throws ApiException {
        String operationId = "deleteApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppsApi.deleteApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteAppResponse>> deleteAppWithHttpInfoAsync(String appId) {
        Invocation.Builder builder;
        String operationId = "deleteApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeleteAppResponse>> result = new CompletableFuture<ApiResponse<DeleteAppResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<DeleteAppResponse>> result = new CompletableFuture<ApiResponse<DeleteAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling deleteApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppsApi.deleteApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteAppResponse>> result = new CompletableFuture<ApiResponse<DeleteAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppResponse>(){});
    }

    public DeleteAppsResponse deleteApps(DeleteAppsRequest body) throws ApiException {
        return this.deleteAppsWithHttpInfo(body).getData();
    }

    public CompletableFuture<DeleteAppsResponse> deleteAppsAsync(DeleteAppsRequest body) {
        return this.deleteAppsWithHttpInfoAsync(body).thenApply(response -> (DeleteAppsResponse)response.getData());
    }

    public ApiResponse<DeleteAppsResponse> deleteAppsWithHttpInfo(DeleteAppsRequest body) throws ApiException {
        String operationId = "deleteApps";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DeleteAppsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteApps");
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppsApi.deleteApps", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppsResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteAppsResponse>> deleteAppsWithHttpInfoAsync(DeleteAppsRequest body) {
        Invocation.Builder builder;
        String operationId = "deleteApps";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<DeleteAppsResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        DeleteAppsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<DeleteAppsResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling deleteApps"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppsApi.deleteApps", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteAppsResponse>> result = new CompletableFuture<ApiResponse<DeleteAppsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteAppsResponse>(){});
    }

    public GetAppResponse getApp(String appId) throws ApiException {
        return this.getAppWithHttpInfo(appId).getData();
    }

    public CompletableFuture<GetAppResponse> getAppAsync(String appId) {
        return this.getAppWithHttpInfoAsync(appId).thenApply(response -> (GetAppResponse)response.getData());
    }

    public ApiResponse<GetAppResponse> getAppWithHttpInfo(String appId) throws ApiException {
        String operationId = "getApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppsApi.getApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetAppResponse>> getAppWithHttpInfoAsync(String appId) {
        Invocation.Builder builder;
        String operationId = "getApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetAppResponse>> result = new CompletableFuture<ApiResponse<GetAppResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (appId == null) {
            CompletableFuture<ApiResponse<GetAppResponse>> result = new CompletableFuture<ApiResponse<GetAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling getApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppsApi.getApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetAppResponse>> result = new CompletableFuture<ApiResponse<GetAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetAppResponse>(){});
    }

    public ListAppsResponse listApps() throws ApiException {
        return this.listAppsWithHttpInfo(new ListAppsOptionalParameters()).getData();
    }

    public CompletableFuture<ListAppsResponse> listAppsAsync() {
        return this.listAppsWithHttpInfoAsync(new ListAppsOptionalParameters()).thenApply(response -> (ListAppsResponse)response.getData());
    }

    public ListAppsResponse listApps(ListAppsOptionalParameters parameters) throws ApiException {
        return this.listAppsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListAppsResponse> listAppsAsync(ListAppsOptionalParameters parameters) {
        return this.listAppsWithHttpInfoAsync(parameters).thenApply(response -> (ListAppsResponse)response.getData());
    }

    public ApiResponse<ListAppsResponse> listAppsWithHttpInfo(ListAppsOptionalParameters parameters) throws ApiException {
        String operationId = "listApps";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long limit = parameters.limit;
        Long page = parameters.page;
        String filterUserName = parameters.filterUserName;
        String filterUserUuid = parameters.filterUserUuid;
        String filterName = parameters.filterName;
        String filterQuery = parameters.filterQuery;
        Boolean filterDeployed = parameters.filterDeployed;
        String filterTags = parameters.filterTags;
        Boolean filterFavorite = parameters.filterFavorite;
        List sort = parameters.sort;
        String localVarPath = "/api/v2/app-builder/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_name]", filterUserName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_uuid]", filterUserUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deployed]", filterDeployed));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[favorite]", filterFavorite));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "sort", sort));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppsApi.listApps", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAppsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListAppsResponse>> listAppsWithHttpInfoAsync(ListAppsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listApps";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListAppsResponse>> result = new CompletableFuture<ApiResponse<ListAppsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long limit = parameters.limit;
        Long page = parameters.page;
        String filterUserName = parameters.filterUserName;
        String filterUserUuid = parameters.filterUserUuid;
        String filterName = parameters.filterName;
        String filterQuery = parameters.filterQuery;
        Boolean filterDeployed = parameters.filterDeployed;
        String filterTags = parameters.filterTags;
        Boolean filterFavorite = parameters.filterFavorite;
        List sort = parameters.sort;
        String localVarPath = "/api/v2/app-builder/apps";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_name]", filterUserName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[user_uuid]", filterUserUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[deployed]", filterDeployed));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[favorite]", filterFavorite));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "sort", sort));
        try {
            builder = this.apiClient.createBuilder("v2.AppsApi.listApps", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListAppsResponse>> result = new CompletableFuture<ApiResponse<ListAppsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAppsResponse>(){});
    }

    public UpdateAppResponse updateApp(String appId, UpdateAppRequest body) throws ApiException {
        return this.updateAppWithHttpInfo(appId, body).getData();
    }

    public CompletableFuture<UpdateAppResponse> updateAppAsync(String appId, UpdateAppRequest body) {
        return this.updateAppWithHttpInfoAsync(appId, body).thenApply(response -> (UpdateAppResponse)response.getData());
    }

    public ApiResponse<UpdateAppResponse> updateAppWithHttpInfo(String appId, UpdateAppRequest body) throws ApiException {
        String operationId = "updateApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateAppRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateApp");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApp");
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AppsApi.updateApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateAppResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateAppResponse>> updateAppWithHttpInfoAsync(String appId, UpdateAppRequest body) {
        Invocation.Builder builder;
        String operationId = "updateApp";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        UpdateAppRequest localVarPostBody = body;
        if (appId == null) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'appId' when calling updateApp"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApp"));
            return result;
        }
        String localVarPath = "/api/v2/app-builder/apps/{app_id}".replaceAll("\\{app_id\\}", this.apiClient.escapeString(appId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AppsApi.updateApp", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateAppResponse>> result = new CompletableFuture<ApiResponse<UpdateAppResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateAppResponse>(){});
    }

    public static class ListAppsOptionalParameters {
        private Long limit;
        private Long page;
        private String filterUserName;
        private String filterUserUuid;
        private String filterName;
        private String filterQuery;
        private Boolean filterDeployed;
        private String filterTags;
        private Boolean filterFavorite;
        private List<AppsSortField> sort;

        public ListAppsOptionalParameters limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public ListAppsOptionalParameters page(Long page) {
            this.page = page;
            return this;
        }

        public ListAppsOptionalParameters filterUserName(String filterUserName) {
            this.filterUserName = filterUserName;
            return this;
        }

        public ListAppsOptionalParameters filterUserUuid(String filterUserUuid) {
            this.filterUserUuid = filterUserUuid;
            return this;
        }

        public ListAppsOptionalParameters filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public ListAppsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListAppsOptionalParameters filterDeployed(Boolean filterDeployed) {
            this.filterDeployed = filterDeployed;
            return this;
        }

        public ListAppsOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListAppsOptionalParameters filterFavorite(Boolean filterFavorite) {
            this.filterFavorite = filterFavorite;
            return this;
        }

        public ListAppsOptionalParameters sort(List<AppsSortField> sort) {
            this.sort = sort;
            return this;
        }
    }
}

