/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=WidgetColorPreferenceSerializer.class)
public class WidgetColorPreference {
    public static final WidgetColorPreference BACKGROUND = new WidgetColorPreference("background");
    public static final WidgetColorPreference TEXT = new WidgetColorPreference("text");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("background", "text"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    WidgetColorPreference(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((WidgetColorPreference)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static WidgetColorPreference fromValue(String value) {
        return new WidgetColorPreference(value);
    }

    public static class WidgetColorPreferenceSerializer
    extends StdSerializer<WidgetColorPreference> {
        public WidgetColorPreferenceSerializer(Class<WidgetColorPreference> t) {
            super(t);
        }

        public WidgetColorPreferenceSerializer() {
            this(null);
        }

        public void serialize(WidgetColorPreference value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

