/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.EventsResponseMetadataPage;
import com.datadog.api.client.v2.model.EventsWarning;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"elapsed", "page", "request_id", "status", "warnings"})
public class EventsResponseMetadata {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ELAPSED = "elapsed";
    private Long elapsed;
    public static final String JSON_PROPERTY_PAGE = "page";
    private EventsResponseMetadataPage page;
    public static final String JSON_PROPERTY_REQUEST_ID = "request_id";
    private String requestId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<EventsWarning> warnings = null;
    private Map<String, Object> additionalProperties;

    public EventsResponseMetadata elapsed(Long elapsed) {
        this.elapsed = elapsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="elapsed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public EventsResponseMetadata page(EventsResponseMetadataPage page) {
        this.page = page;
        this.unparsed |= page.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventsResponseMetadataPage getPage() {
        return this.page;
    }

    public void setPage(EventsResponseMetadataPage page) {
        this.page = page;
    }

    public EventsResponseMetadata requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @JsonProperty(value="request_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public EventsResponseMetadata status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public EventsResponseMetadata warnings(List<EventsWarning> warnings) {
        this.warnings = warnings;
        for (EventsWarning item : warnings) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public EventsResponseMetadata addWarningsItem(EventsWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<EventsWarning>();
        }
        this.warnings.add(warningsItem);
        this.unparsed |= warningsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventsWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<EventsWarning> warnings) {
        this.warnings = warnings;
    }

    @JsonAnySetter
    public EventsResponseMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsResponseMetadata eventsResponseMetadata = (EventsResponseMetadata)o;
        return Objects.equals(this.elapsed, eventsResponseMetadata.elapsed) && Objects.equals(this.page, eventsResponseMetadata.page) && Objects.equals(this.requestId, eventsResponseMetadata.requestId) && Objects.equals(this.status, eventsResponseMetadata.status) && Objects.equals(this.warnings, eventsResponseMetadata.warnings) && Objects.equals(this.additionalProperties, eventsResponseMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.elapsed, this.page, this.requestId, this.status, this.warnings, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsResponseMetadata {\n");
        sb.append("    elapsed: ").append(this.toIndentedString(this.elapsed)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

