/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.EntityData;
import com.datadog.api.client.v2.model.IncludeType;
import com.datadog.api.client.v2.model.ListEntityCatalogResponse;
import com.datadog.api.client.v2.model.RelationType;
import com.datadog.api.client.v2.model.UpsertCatalogEntityRequest;
import com.datadog.api.client.v2.model.UpsertCatalogEntityResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class SoftwareCatalogApi {
    private ApiClient apiClient;

    public SoftwareCatalogApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SoftwareCatalogApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteCatalogEntity(String entityId) throws ApiException {
        this.deleteCatalogEntityWithHttpInfo(entityId);
    }

    public CompletableFuture<Void> deleteCatalogEntityAsync(String entityId) {
        return this.deleteCatalogEntityWithHttpInfoAsync(entityId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteCatalogEntityWithHttpInfo(String entityId) throws ApiException {
        Object localVarPostBody = null;
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling deleteCatalogEntity");
        }
        String localVarPath = "/api/v2/catalog/entity/{entity_id}".replaceAll("\\{entity_id\\}", this.apiClient.escapeString(entityId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.deleteCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteCatalogEntityWithHttpInfoAsync(String entityId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (entityId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'entityId' when calling deleteCatalogEntity"));
            return result;
        }
        String localVarPath = "/api/v2/catalog/entity/{entity_id}".replaceAll("\\{entity_id\\}", this.apiClient.escapeString(entityId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.deleteCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public ListEntityCatalogResponse listCatalogEntity() throws ApiException {
        return this.listCatalogEntityWithHttpInfo(new ListCatalogEntityOptionalParameters()).getData();
    }

    public CompletableFuture<ListEntityCatalogResponse> listCatalogEntityAsync() {
        return this.listCatalogEntityWithHttpInfoAsync(new ListCatalogEntityOptionalParameters()).thenApply(response -> (ListEntityCatalogResponse)response.getData());
    }

    public ListEntityCatalogResponse listCatalogEntity(ListCatalogEntityOptionalParameters parameters) throws ApiException {
        return this.listCatalogEntityWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListEntityCatalogResponse> listCatalogEntityAsync(ListCatalogEntityOptionalParameters parameters) {
        return this.listCatalogEntityWithHttpInfoAsync(parameters).thenApply(response -> (ListEntityCatalogResponse)response.getData());
    }

    public PaginationIterable<EntityData> listCatalogEntityWithPagination() {
        ListCatalogEntityOptionalParameters parameters = new ListCatalogEntityOptionalParameters();
        return this.listCatalogEntityWithPagination(parameters);
    }

    public PaginationIterable<EntityData> listCatalogEntityWithPagination(ListCatalogEntityOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        parameters.pageOffset(0L);
        if (parameters.pageLimit == null) {
            limit = 100L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<EntityData> iterator = new PaginationIterable<EntityData>(this, "listCatalogEntity", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<ListEntityCatalogResponse> listCatalogEntityWithHttpInfo(ListCatalogEntityOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String fitlerId = parameters.fitlerId;
        String fitlerRef = parameters.fitlerRef;
        String fitlerName = parameters.fitlerName;
        String fitlerKind = parameters.fitlerKind;
        String fitlerOwner = parameters.fitlerOwner;
        RelationType fitlerRelationType = parameters.fitlerRelationType;
        String fitlerExcludeSnapshot = parameters.fitlerExcludeSnapshot;
        IncludeType include = parameters.include;
        String localVarPath = "/api/v2/catalog/entity";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[id]", fitlerId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[ref]", fitlerRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[name]", fitlerName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[kind]", fitlerKind));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[owner]", fitlerOwner));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[relation][type]", fitlerRelationType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[exclude_snapshot]", fitlerExcludeSnapshot));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogEntity", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListEntityCatalogResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListEntityCatalogResponse>> listCatalogEntityWithHttpInfoAsync(ListCatalogEntityOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageOffset = parameters.pageOffset;
        Long pageLimit = parameters.pageLimit;
        String fitlerId = parameters.fitlerId;
        String fitlerRef = parameters.fitlerRef;
        String fitlerName = parameters.fitlerName;
        String fitlerKind = parameters.fitlerKind;
        String fitlerOwner = parameters.fitlerOwner;
        RelationType fitlerRelationType = parameters.fitlerRelationType;
        String fitlerExcludeSnapshot = parameters.fitlerExcludeSnapshot;
        IncludeType include = parameters.include;
        String localVarPath = "/api/v2/catalog/entity";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[id]", fitlerId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[ref]", fitlerRef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[name]", fitlerName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[kind]", fitlerKind));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[owner]", fitlerOwner));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[relation][type]", fitlerRelationType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fitler[exclude_snapshot]", fitlerExcludeSnapshot));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.listCatalogEntity", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListEntityCatalogResponse>> result = new CompletableFuture<ApiResponse<ListEntityCatalogResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListEntityCatalogResponse>(){});
    }

    public UpsertCatalogEntityResponse upsertCatalogEntity(UpsertCatalogEntityRequest body) throws ApiException {
        return this.upsertCatalogEntityWithHttpInfo(body).getData();
    }

    public CompletableFuture<UpsertCatalogEntityResponse> upsertCatalogEntityAsync(UpsertCatalogEntityRequest body) {
        return this.upsertCatalogEntityWithHttpInfoAsync(body).thenApply(response -> (UpsertCatalogEntityResponse)response.getData());
    }

    public ApiResponse<UpsertCatalogEntityResponse> upsertCatalogEntityWithHttpInfo(UpsertCatalogEntityRequest body) throws ApiException {
        UpsertCatalogEntityRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogEntity");
        }
        String localVarPath = "/api/v2/catalog/entity";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.upsertCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpsertCatalogEntityResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>> upsertCatalogEntityWithHttpInfoAsync(UpsertCatalogEntityRequest body) {
        Invocation.Builder builder;
        UpsertCatalogEntityRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>> result = new CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogEntity"));
            return result;
        }
        String localVarPath = "/api/v2/catalog/entity";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SoftwareCatalogApi.upsertCatalogEntity", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>> result = new CompletableFuture<ApiResponse<UpsertCatalogEntityResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpsertCatalogEntityResponse>(){});
    }

    public static class ListCatalogEntityOptionalParameters {
        private Long pageOffset;
        private Long pageLimit;
        private String fitlerId;
        private String fitlerRef;
        private String fitlerName;
        private String fitlerKind;
        private String fitlerOwner;
        private RelationType fitlerRelationType;
        private String fitlerExcludeSnapshot;
        private IncludeType include;

        public ListCatalogEntityOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListCatalogEntityOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerId(String fitlerId) {
            this.fitlerId = fitlerId;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerRef(String fitlerRef) {
            this.fitlerRef = fitlerRef;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerName(String fitlerName) {
            this.fitlerName = fitlerName;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerKind(String fitlerKind) {
            this.fitlerKind = fitlerKind;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerOwner(String fitlerOwner) {
            this.fitlerOwner = fitlerOwner;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerRelationType(RelationType fitlerRelationType) {
            this.fitlerRelationType = fitlerRelationType;
            return this;
        }

        public ListCatalogEntityOptionalParameters fitlerExcludeSnapshot(String fitlerExcludeSnapshot) {
            this.fitlerExcludeSnapshot = fitlerExcludeSnapshot;
            return this;
        }

        public ListCatalogEntityOptionalParameters include(IncludeType include) {
            this.include = include;
            return this;
        }
    }
}

