/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MetricsDataSource;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data_source", "name", "query"})
public class MetricsTimeseriesQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA_SOURCE = "data_source";
    private MetricsDataSource dataSource = MetricsDataSource.METRICS;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    private Map<String, Object> additionalProperties;

    public MetricsTimeseriesQuery() {
    }

    @JsonCreator
    public MetricsTimeseriesQuery(@JsonProperty(required=true, value="data_source") MetricsDataSource dataSource, @JsonProperty(required=true, value="query") String query) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        this.query = query;
    }

    public MetricsTimeseriesQuery dataSource(MetricsDataSource dataSource) {
        this.dataSource = dataSource;
        this.unparsed |= !dataSource.isValid();
        return this;
    }

    @JsonProperty(value="data_source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricsDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(MetricsDataSource dataSource) {
        if (!dataSource.isValid()) {
            this.unparsed = true;
        }
        this.dataSource = dataSource;
    }

    public MetricsTimeseriesQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricsTimeseriesQuery query(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @JsonAnySetter
    public MetricsTimeseriesQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsTimeseriesQuery metricsTimeseriesQuery = (MetricsTimeseriesQuery)o;
        return Objects.equals(this.dataSource, metricsTimeseriesQuery.dataSource) && Objects.equals(this.name, metricsTimeseriesQuery.name) && Objects.equals(this.query, metricsTimeseriesQuery.query) && Objects.equals(this.additionalProperties, metricsTimeseriesQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.name, this.query, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricsTimeseriesQuery {\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

