/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringRuleQueryAggregation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"aggregation", "distinctFields", "groupByFields", "metric", "metrics", "name", "query"})
public class SecurityMonitoringRuleQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private SecurityMonitoringRuleQueryAggregation aggregation;
    public static final String JSON_PROPERTY_DISTINCT_FIELDS = "distinctFields";
    private List<String> distinctFields = null;
    public static final String JSON_PROPERTY_GROUP_BY_FIELDS = "groupByFields";
    private List<String> groupByFields = null;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private List<String> metrics = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;

    public SecurityMonitoringRuleQuery aggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        this.aggregation = aggregation;
        this.unparsed |= !aggregation.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecurityMonitoringRuleQueryAggregation getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(SecurityMonitoringRuleQueryAggregation aggregation) {
        if (!aggregation.isValid()) {
            this.unparsed = true;
        }
        this.aggregation = aggregation;
    }

    public SecurityMonitoringRuleQuery distinctFields(List<String> distinctFields) {
        this.distinctFields = distinctFields;
        return this;
    }

    public SecurityMonitoringRuleQuery addDistinctFieldsItem(String distinctFieldsItem) {
        if (this.distinctFields == null) {
            this.distinctFields = new ArrayList<String>();
        }
        this.distinctFields.add(distinctFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="distinctFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDistinctFields() {
        return this.distinctFields;
    }

    public void setDistinctFields(List<String> distinctFields) {
        this.distinctFields = distinctFields;
    }

    public SecurityMonitoringRuleQuery groupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
        return this;
    }

    public SecurityMonitoringRuleQuery addGroupByFieldsItem(String groupByFieldsItem) {
        if (this.groupByFields == null) {
            this.groupByFields = new ArrayList<String>();
        }
        this.groupByFields.add(groupByFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groupByFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroupByFields() {
        return this.groupByFields;
    }

    public void setGroupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
    }

    public SecurityMonitoringRuleQuery metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public SecurityMonitoringRuleQuery metrics(List<String> metrics) {
        this.metrics = metrics;
        return this;
    }

    public SecurityMonitoringRuleQuery addMetricsItem(String metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<String>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public SecurityMonitoringRuleQuery name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityMonitoringRuleQuery query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityMonitoringRuleQuery securityMonitoringRuleQuery = (SecurityMonitoringRuleQuery)o;
        return Objects.equals(this.aggregation, securityMonitoringRuleQuery.aggregation) && Objects.equals(this.distinctFields, securityMonitoringRuleQuery.distinctFields) && Objects.equals(this.groupByFields, securityMonitoringRuleQuery.groupByFields) && Objects.equals(this.metric, securityMonitoringRuleQuery.metric) && Objects.equals(this.metrics, securityMonitoringRuleQuery.metrics) && Objects.equals(this.name, securityMonitoringRuleQuery.name) && Objects.equals(this.query, securityMonitoringRuleQuery.query);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.distinctFields, this.groupByFields, this.metric, this.metrics, this.name, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityMonitoringRuleQuery {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    distinctFields: ").append(this.toIndentedString(this.distinctFields)).append("\n");
        sb.append("    groupByFields: ").append(this.toIndentedString(this.groupByFields)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

